/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.classloader.jbcl114.test;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;
import org.jboss.test.classloader.AbstractClassLoaderTest;
import org.jboss.test.classloader.domain.support.NoMatchClassFilter;
import org.jboss.test.classloader.jbcl114.BlockingClassLoaderDomain;
import org.jboss.test.classloader.jbcl114.BlockingClassLoaderSystem;

/**
 * Race the synchronized block in BaseClassLoader.loadClass.
 * 
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class CachingClassesUnitTestCase extends AbstractClassLoaderTest
{
   public CachingClassesUnitTestCase(String name)
   {
      super(name);
   }

   protected ClassLoaderSystem createBlockingClassLoaderSystem()
   {
      return new BlockingClassLoaderSystem();
   }
   
   /*
    * The second thread allowed into the synchronized block of BaseClassLoader.loadClass
    * must not touch the ClassLoaderDomain.
    */
   public void testCache() throws Exception
   {
      ClassLoaderSystem system = createBlockingClassLoaderSystem();
      NoMatchClassFilter filter = new NoMatchClassFilter(ClassLoaderDomain.class);
      ParentPolicy parentPolicy = new ParentPolicy(ClassFilter.JAVA_ONLY, filter);
      BlockingClassLoaderDomain domain = (BlockingClassLoaderDomain) system.createAndRegisterDomain("test", parentPolicy, null);
      
      MockClassLoaderPolicy policy = createMockClassLoaderPolicy();
      policy.setPathsAndPackageNames(ClassLoaderDomain.class);
      final ClassLoader classLoader = system.registerClassLoaderPolicy(domain, policy);
      
      int numThreads = 2;
      ExecutorService executor = Executors.newFixedThreadPool(numThreads);
      Future<?>[] results = new Future[numThreads];
      for(int i = 0; i < results.length; i++)
      {
         results[i] = executor.submit(new Callable<Void>() {
            public Void call() throws Exception
            {
               assertLoadClass(ClassLoaderDomain.class, classLoader);
               return null;
            }
         });
      }
      executor.shutdown();
      domain.unblock();
      executor.awaitTermination(5, TimeUnit.SECONDS);
      // no exceptions means a job well done
      for(int i = 0; i < results.length; i++)
      {
         results[i].get(1, TimeUnit.SECONDS);
      }
   }
}
