/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectName;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.PackageInformation;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.base.BaseClassLoaderMBean;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.base.BaseClassLoaderSource;
import org.jboss.classloader.spi.base.BaseDelegateLoader;
import org.jboss.classloader.spi.base.ClassLoaderManager;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.logging.Logger;
import org.jboss.util.collection.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClassLoader
extends SecureClassLoader
implements BaseClassLoaderMBean,
RealClassLoader {
    private static final Logger log = Logger.getLogger(BaseClassLoader.class);
    private ReentrantLock lock = new ReentrantLock(true);
    private ClassLoaderPolicy policy;
    private DelegateLoader loader;
    private Map<String, String> loadedClasses = new ConcurrentHashMap<String, String>();
    private Map<String, URL> resourceCache;
    private Map<String, String> blackList;

    public BaseClassLoader(ClassLoaderPolicy policy) {
        super(null);
        if (policy == null) {
            throw new IllegalArgumentException("Null policy");
        }
        this.policy = policy;
        ClassLoaderPolicy basePolicy = policy;
        basePolicy.setClassLoader(this);
        this.loader = new DelegateLoader(policy);
        if (((BaseClassLoaderPolicy)basePolicy).isCacheable()) {
            this.resourceCache = new ConcurrentHashMap<String, URL>();
        }
        if (((BaseClassLoaderPolicy)basePolicy).isBlackListable()) {
            this.blackList = new ConcurrentHashMap<String, String>();
        }
        log.debug((Object)("Created " + this + " with policy " + policy.toLongString()));
    }

    public ObjectName getObjectName() {
        return this.policy.getObjectName();
    }

    @Override
    public ObjectName getClassLoaderDomain() {
        ClassLoaderPolicy basePolicy = this.policy;
        ClassLoaderDomain domain = (ClassLoaderDomain)basePolicy.getClassLoaderDomain();
        return domain.getObjectName();
    }

    @Override
    public String getName() {
        return this.policy.getName();
    }

    @Override
    public boolean isBlackListable() {
        ClassLoaderPolicy basePolicy = this.policy;
        return ((BaseClassLoaderPolicy)basePolicy).isBlackListable();
    }

    @Override
    public boolean isCacheable() {
        ClassLoaderPolicy basePolicy = this.policy;
        return ((BaseClassLoaderPolicy)basePolicy).isCacheable();
    }

    @Override
    public boolean isImportAll() {
        ClassLoaderPolicy basePolicy = this.policy;
        return ((BaseClassLoaderPolicy)basePolicy).isImportAll();
    }

    @Override
    public Set<String> listExportedPackages() {
        HashSet<String> result = new HashSet<String>();
        String[] packageNames = this.policy.getPackageNames();
        if (packageNames != null) {
            Collections.addAll(result, packageNames);
        }
        return result;
    }

    @Override
    public List<ObjectName> listImports() {
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        ClassLoaderPolicy basePolicy = this.policy;
        List<? extends DelegateLoader> delegates = ((BaseClassLoaderPolicy)basePolicy).getDelegates();
        if (delegates != null) {
            for (DelegateLoader delegateLoader : delegates) {
                DelegateLoader baseDelegate = delegateLoader;
                BaseClassLoaderPolicy otherPolicy = ((BaseDelegateLoader)baseDelegate).getPolicy();
                if (otherPolicy == null) continue;
                result.add(otherPolicy.getObjectName());
            }
        }
        return result;
    }

    @Override
    public String listPolicyDetails() {
        return this.policy.toLongString();
    }

    @Override
    public ObjectName findClassLoaderForClass(String name) throws ClassNotFoundException {
        final Class<?> clazz = this.loadClass(name);
        if (clazz == null) {
            return null;
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
        if (cl != null && cl instanceof RealClassLoader) {
            return ((RealClassLoader)cl).getObjectName();
        }
        return null;
    }

    @Override
    public Set<String> listLoadedClasses() {
        return Collections.unmodifiableSet(this.loadedClasses.keySet());
    }

    @Override
    public Set<String> listLoadedResourceNames() {
        if (this.resourceCache == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.resourceCache.keySet());
    }

    @Override
    public Set<URL> listLoadedResources() {
        if (this.resourceCache == null) {
            return Collections.emptySet();
        }
        TreeSet<URL> result = new TreeSet<URL>(ClassLoaderUtils.URLComparator.INSTANCE);
        result.addAll(this.resourceCache.values());
        return result;
    }

    ClassLoaderPolicy getPolicy() {
        return this.policy;
    }

    DelegateLoader getLoader() {
        return this.loader;
    }

    @Override
    protected Package getPackage(String name) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " getPackage " + name));
        }
        if (name == null) {
            return null;
        }
        Package result = super.getPackage(name);
        if (result != null && trace) {
            log.trace((Object)(this + " already loaded package " + name + " " + result.getName()));
        }
        if (result == null) {
            ClassLoaderPolicy basePolicy = this.policy;
            BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
            if (domain == null) {
                return null;
            }
            if (trace) {
                log.trace((Object)(this + " getPackage " + name + " domain=" + domain));
            }
            result = domain.getPackage(this, name);
        }
        if (result == null && trace) {
            log.trace((Object)(this + " package not found " + name));
        }
        return result;
    }

    @Override
    protected Package[] getPackages() {
        ClassLoaderPolicy basePolicy = this.policy;
        BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
        if (domain == null) {
            return super.getPackages();
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " getPackages domain=" + domain));
        }
        HashSet<Package> packages = new HashSet<Package>();
        domain.getPackages(this, packages);
        return packages.toArray(new Package[packages.size()]);
    }

    Package getPackageLocally(String name) {
        return super.getPackage(name);
    }

    void getPackagesLocally(Set<Package> packages) {
        Package[] pkgs;
        for (Package pkg : pkgs = super.getPackages()) {
            packages.add(pkg);
        }
    }

    protected Class<?> isLoadedClass(String name, boolean trace) {
        RealClassLoader rcl;
        ClassLoader otherClassLoader;
        Class<?> result = this.findLoadedClass(name);
        if (result != null && (otherClassLoader = BaseClassLoader.getClassLoader(result)) != null && otherClassLoader != this && otherClassLoader instanceof RealClassLoader && !(rcl = (RealClassLoader)otherClassLoader).isValid()) {
            if (trace) {
                log.trace((Object)(this + " ignoring already loaded class from undeployed classloader " + ClassLoaderUtils.classToString(result)));
            }
            result = null;
        }
        if (result != null && trace) {
            log.trace((Object)(this + " already loaded class " + ClassLoaderUtils.classToString(result)));
        }
        return result;
    }

    protected Class<?> checkCacheAndBlackList(String name, boolean failIfBlackListed, boolean trace) throws ClassNotFoundException {
        ClassLoaderPolicy basePolicy = this.policy;
        BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
        if (domain == null) {
            return null;
        }
        return domain.checkClassCacheAndBlackList(this, name, null, ((BaseClassLoaderPolicy)basePolicy).isImportAll(), false);
    }

    public ClassLoader findClassLoader(String className) throws ClassNotFoundException {
        ClassLoaderPolicy basePolicy;
        BaseClassLoaderDomain domain;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if ((domain = (basePolicy = this.policy).getClassLoaderDomain()) == null) {
            throw new IllegalStateException(this + " classLoader is not connected to a domain (probably undeployed?) for class " + this.getName());
        }
        ClassLoaderUtils.checkClassName(className);
        String path = ClassLoaderUtils.classNameToPath(className);
        Loader loader = domain.findLoader(this, path, ((BaseClassLoaderPolicy)basePolicy).isImportAll(), true);
        if (loader == null) {
            throw new ClassNotFoundException("Class " + className + " not found from " + this);
        }
        if (loader instanceof BaseClassLoaderSource) {
            return ((BaseClassLoaderSource)((Object)loader)).getClassLoader();
        }
        if (loader instanceof BaseDelegateLoader) {
            return ((BaseDelegateLoader)loader).getPolicy().getClassLoader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " loadClass " + name + " resolve=" + resolve));
        }
        ClassLoaderUtils.checkClassName(name);
        Class<?> result = this.isLoadedClass(name, trace);
        if (result == null && name.charAt(0) == '[') {
            if (trace) {
                log.trace((Object)(this + " resolving array class " + name + " using Class.forName()"));
            }
            result = Class.forName(name, true, this);
            if (trace) {
                log.trace((Object)(this + " resolved array " + ClassLoaderUtils.classToString(result)));
            }
        }
        if (result != null) {
            return result;
        }
        result = this.checkCacheAndBlackList(name, false, trace);
        if (result != null) {
            return result;
        }
        BaseClassLoader baseClassLoader = this;
        synchronized (baseClassLoader) {
            result = this.isLoadedClass(name, trace);
            if (result == null) {
                result = this.loadClassFromDomain(name, trace);
            }
            if (result == null) {
                if (trace) {
                    log.trace((Object)(this + " class not found " + name));
                }
                throw new ClassNotFoundException(name + " from " + this.toLongString());
            }
            if (resolve) {
                if (trace) {
                    log.trace((Object)(this + " resolveClass " + ClassLoaderUtils.classToString(result)));
                }
                this.resolveClass(result);
            }
            return result;
        }
    }

    @Override
    public URL getResource(String name) {
        ClassLoaderPolicy basePolicy = this.policy;
        BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " getResource " + name + " domain=" + domain));
        }
        if (domain != null) {
            return domain.getResource(this, name);
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Set<URL> resourceURLs = this.loadResources(name);
        return Iterators.toEnumeration(resourceURLs.iterator());
    }

    @Override
    public Set<URL> loadResources(String name) throws IOException {
        ClassLoaderPolicy basePolicy = this.policy;
        BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)(this + " findResources " + name + " domain=" + domain));
        }
        TreeSet<URL> resourceURLs = new TreeSet<URL>(ClassLoaderUtils.URLComparator.INSTANCE);
        if (domain != null) {
            domain.getResources(this, name, resourceURLs);
        }
        return resourceURLs;
    }

    Class<?> loadClassLocally(String name) {
        return this.loadClassLocally(name, log.isTraceEnabled());
    }

    synchronized Class<?> loadClassLocally(final String name, final boolean trace) {
        Class result;
        if (trace) {
            log.trace((Object)(this + " load class locally " + name));
        }
        if ((result = this.isLoadedClass(name, trace)) != null) {
            return result;
        }
        final String resourcePath = ClassLoaderUtils.classNameToPath(name);
        result = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                CodeSource codeSource;
                InputStream is = BaseClassLoader.this.policy.getResourceAsStream(resourcePath);
                if (is == null) {
                    if (trace) {
                        log.trace((Object)(BaseClassLoader.this + " resource not found locally " + resourcePath + " for " + name));
                    }
                    return null;
                }
                byte[] byteCode = ClassLoaderUtils.loadByteCode(name, is);
                ClassLoaderPolicy basePolicy = BaseClassLoader.this.policy;
                ProtectionDomain protectionDomain = ((BaseClassLoaderPolicy)basePolicy).getProtectionDomain(name, resourcePath);
                try {
                    byte[] transformed = BaseClassLoader.this.policy.transform(name, byteCode, protectionDomain);
                    if (transformed != null) {
                        byteCode = transformed;
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unexpected error transforming class " + name, t);
                }
                URL codeSourceURL = null;
                if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                    codeSourceURL = codeSource.getLocation();
                }
                BaseClassLoader.this.definePackage(name, codeSourceURL);
                Class result = protectionDomain != null ? BaseClassLoader.this.defineClass(name, byteCode, 0, byteCode.length, protectionDomain) : BaseClassLoader.this.defineClass(name, byteCode, 0, byteCode.length);
                if (trace) {
                    log.trace((Object)(BaseClassLoader.this + " loaded class locally " + ClassLoaderUtils.classToString(result)));
                }
                return result;
            }
        }, this.policy.getAccessControlContext());
        this.loadedClasses.put(name, name);
        return result;
    }

    public URL getResourceLocally(String name) {
        return this.getResourceLocally(name, log.isTraceEnabled());
    }

    URL getResourceLocally(final String name, final boolean trace) {
        URL url;
        if (trace) {
            log.trace((Object)(this + " get resource locally " + name));
        }
        if (this.resourceCache != null && (url = this.resourceCache.get(name)) != null) {
            if (trace) {
                log.trace((Object)(this + " got resource from cache " + name));
            }
            return url;
        }
        if (this.blackList != null && this.blackList.containsKey(name)) {
            if (trace) {
                log.trace((Object)(this + " resource is blacklisted " + name));
            }
            return null;
        }
        URL result = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                URL result = BaseClassLoader.this.policy.getResource(name);
                if (result == null) {
                    if (trace) {
                        log.trace((Object)(BaseClassLoader.this + " resource not found locally " + name));
                    }
                    return null;
                }
                if (trace) {
                    log.trace((Object)(BaseClassLoader.this + " got resource locally " + name));
                }
                return result;
            }
        }, this.policy.getAccessControlContext());
        if (this.resourceCache != null && result != null) {
            this.resourceCache.put(name, result);
        }
        if (this.blackList != null && result == null) {
            this.blackList.put(name, name);
        }
        return result;
    }

    void getResourcesLocally(String name, Set<URL> urls) throws IOException {
        this.getResourcesLocally(name, urls, log.isTraceEnabled());
    }

    void getResourcesLocally(final String name, final Set<URL> urls, boolean trace) throws IOException {
        if (trace) {
            log.trace((Object)(this + " get resources locally " + name));
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    BaseClassLoader.this.policy.getResources(name, urls);
                    return null;
                }
            }, this.policy.getAccessControlContext());
        }
        catch (PrivilegedActionException e) {
            Exception e1 = e.getException();
            if (e1 instanceof RuntimeException) {
                throw (RuntimeException)e1;
            }
            if (e1 instanceof IOException) {
                throw (IOException)e1;
            }
            IOException e2 = new IOException("Unexpected error");
            e2.initCause(e1);
            throw e2;
        }
    }

    protected void definePackage(String className, URL codeSourceURL) {
        String packageName = ClassLoaderUtils.getClassPackageName(className);
        if (packageName.length() == 0) {
            return;
        }
        PackageInformation pi = this.policy.getClassPackageInformation(className, packageName);
        Package pkge = this.getPackage(packageName);
        if (pkge != null) {
            if (pkge.isSealed()) {
                if (codeSourceURL == null || !pkge.isSealed(codeSourceURL)) {
                    throw new SecurityException("Sealing violation for package " + packageName);
                }
            } else if (pi != null && pi.sealBase != null) {
                throw new SecurityException("Can't seal package " + packageName + " it is already loaded");
            }
            return;
        }
        try {
            if (pi != null) {
                this.definePackage(packageName, pi.specTitle, pi.specVersion, pi.specVendor, pi.implTitle, pi.implVersion, pi.implVendor, pi.sealBase);
            } else {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " defined package: " + packageName));
            }
        }
        catch (IllegalArgumentException alreadyDone) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClassFromDomain(String name, boolean trace) throws ClassNotFoundException {
        this.acquireLockFairly(trace);
        try {
            ClassLoaderPolicy basePolicy = this.policy;
            BaseClassLoaderDomain domain = basePolicy.getClassLoaderDomain();
            if (trace) {
                log.trace((Object)(this + " load from domain " + name + " domain=" + domain));
            }
            if (domain == null) {
                Class<?> result = this.loadClassLocally(name, trace);
                if (result == null) {
                    throw new IllegalStateException(this + " classLoader is not connected to a domain (probably undeployed?) for class " + name);
                }
                Class<?> clazz = result;
                return clazz;
            }
            Class<?> result = domain.loadClass(this, name);
            if (result != null && trace) {
                log.trace((Object)(this + " got class from domain " + ClassLoaderUtils.classToString(result)));
            }
            Class<?> clazz = result;
            return clazz;
        }
        finally {
            this.unlock(trace, true);
        }
    }

    @Override
    public boolean isValid() {
        ClassLoaderPolicy basePolicy = this.policy;
        return basePolicy.getClassLoaderUnchecked() != null;
    }

    public Class<?> getCachedClass(String name) {
        return null;
    }

    public URL getCachedResource(String name) {
        return null;
    }

    @Override
    public int getResourceBlackListSize() {
        Map<String, String> blackList = this.blackList;
        if (blackList == null) {
            return 0;
        }
        return blackList.size();
    }

    @Override
    public int getResourceCacheSize() {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache == null) {
            return 0;
        }
        return resourceCache.size();
    }

    @Override
    public Set<String> listResourceBlackList() {
        Map<String, String> blackList = this.blackList;
        if (blackList == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(blackList.keySet());
    }

    @Override
    public Map<String, URL> listResourceCache() {
        Map<String, URL> resourceCache = this.resourceCache;
        if (resourceCache == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(resourceCache);
    }

    @Override
    public void clearBlackList() {
        if (this.blackList != null) {
            for (String name : this.blackList.keySet()) {
                this.clearBlackList(name);
            }
        }
    }

    @Override
    public void clearBlackList(String name) {
        if (this.blackList != null) {
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)(this + " removing from blacklist " + name));
            }
            this.blackList.remove(name);
            this.policy.clearBlackList(name);
        }
    }

    public String toLongString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        builder.append('{').append(this.getPolicy().toLongString());
        this.toLongString(builder);
        builder.append('}');
        return builder.toString();
    }

    protected void shutdownClassLoader() {
        log.debug((Object)(this.toString() + " shutdown!"));
        if (this.resourceCache != null) {
            this.resourceCache.clear();
        }
        if (this.blackList != null) {
            this.blackList.clear();
        }
    }

    protected void toLongString(StringBuilder builder) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        builder.append("{").append(this.policy.getName()).append("}");
        return builder.toString();
    }

    boolean attemptLock() {
        return this.attemptLock(log.isTraceEnabled());
    }

    void lock() {
        this.acquireLockFairly(log.isTraceEnabled());
    }

    void unlock(boolean rescheduleTasks) {
        this.unlock(log.isTraceEnabled(), rescheduleTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptLock(boolean trace) {
        Thread thread = Thread.currentThread();
        if (trace) {
            log.trace((Object)(this + " attemptLock " + thread));
        }
        boolean interrupted = Thread.interrupted();
        boolean result = false;
        try {
            result = this.lock.tryLock(0L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException ignored) {
            interrupted = true;
        }
        finally {
            if (interrupted) {
                thread.interrupt();
            }
        }
        if (trace) {
            if (result) {
                log.trace((Object)(this + " locked " + thread + " holding=" + this.lock.getHoldCount()));
            } else {
                log.trace((Object)(this + " did NOT get the lock " + thread));
            }
        }
        if (result && this.lock.getHoldCount() == 1) {
            ClassLoaderManager.registerLoaderThread(this, thread);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLockFairly(boolean trace) {
        Thread thread = Thread.currentThread();
        if (trace) {
            log.trace((Object)(this + " aquireLockFairly " + thread));
        }
        boolean interrupted = Thread.interrupted();
        int waits = 0;
        try {
            while (true) {
                try {
                    while (!this.lock.tryLock(0L, TimeUnit.MICROSECONDS)) {
                        if (waits++ == 12) {
                            throw new IllegalStateException("Waiting too long to get the classloader lock: " + this);
                        }
                        if (trace) {
                            log.trace((Object)(this + " waiting for lock " + thread));
                        }
                        this.wait(10000L);
                    }
                    if (trace) {
                        log.trace((Object)(this + " aquiredLock " + thread + " holding=" + this.lock.getHoldCount()));
                    }
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                thread.interrupt();
            }
        }
        if (this.lock.getHoldCount() == 1) {
            ClassLoaderManager.registerLoaderThread(this, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(boolean trace, boolean rescheduleTasks) {
        Thread thread = Thread.currentThread();
        if (trace) {
            log.trace((Object)(this + " unlock " + thread + " holding=" + this.lock.getHoldCount()));
        }
        BaseClassLoader baseClassLoader = this;
        synchronized (baseClassLoader) {
            this.lock.unlock();
            if (this.lock.getHoldCount() == 0) {
                ClassLoaderManager.unregisterLoaderThread(this, thread, rescheduleTasks);
                this.notifyAll();
            }
        }
    }

    private static final ClassLoader getClassLoader(final Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }
}

