/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.classloader.plugins.filter.PatternClassFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursivePackageClassFilter
extends PatternClassFilter {
    private static final long serialVersionUID = -2757199997130618510L;
    private static final String[] EVERYTHING_PATTERN = new String[]{".*"};
    private String[] packageNames;

    private static String[] convertPackageNamesToClassPatterns(String[] packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("Null package names");
        }
        String[] patterns = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            if (packageNames[i] == null) {
                throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
            }
            if (packageNames[i].length() == 0) {
                return EVERYTHING_PATTERN;
            }
            patterns[i] = packageNames[i].replace(".", "\\.") + "\\..+";
        }
        return patterns;
    }

    private static String[] convertPackageNamesToResourcePatterns(String[] packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("Null package names");
        }
        String[] patterns = new String[packageNames.length];
        for (int i = 0; i < packageNames.length; ++i) {
            if (packageNames[i] == null) {
                throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
            }
            if (packageNames[i].length() == 0) {
                return EVERYTHING_PATTERN;
            }
            patterns[i] = packageNames[i].replace(".", "/") + "/.+";
        }
        return patterns;
    }

    private static String[] convertPackageNamesToPackagePatterns(String[] packageNames) {
        if (packageNames == null) {
            throw new IllegalArgumentException("Null package names");
        }
        String[] patterns = new String[2 * packageNames.length];
        int j = 0;
        for (int i = 0; i < packageNames.length; ++i) {
            if (packageNames[i] == null) {
                throw new IllegalArgumentException("Null package name in " + Arrays.asList(packageNames));
            }
            if (packageNames[i].length() == 0) {
                return EVERYTHING_PATTERN;
            }
            patterns[j++] = packageNames[i];
            patterns[j++] = packageNames[i] + "\\..*";
        }
        return patterns;
    }

    public static RecursivePackageClassFilter createRecursivePackageClassFilterFromString(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        ArrayList<String> packages = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            packages.add(tokenizer.nextToken());
        }
        return RecursivePackageClassFilter.createRecursivePackageClassFilter(packages);
    }

    public static RecursivePackageClassFilter createRecursivePackageClassFilter(String ... packageNames) {
        return new RecursivePackageClassFilter(packageNames);
    }

    public static RecursivePackageClassFilter createRecursivePackageClassFilter(List<String> packageNames) {
        String[] packages = packageNames == null ? new String[]{} : packageNames.toArray(new String[packageNames.size()]);
        return new RecursivePackageClassFilter(packages);
    }

    public RecursivePackageClassFilter(String[] packageNames) {
        super(RecursivePackageClassFilter.convertPackageNamesToClassPatterns(packageNames), RecursivePackageClassFilter.convertPackageNamesToResourcePatterns(packageNames), RecursivePackageClassFilter.convertPackageNamesToPackagePatterns(packageNames));
        this.packageNames = packageNames;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Arrays.asList(this.packageNames));
        if (this.isIncludeJava()) {
            builder.append(" <INCLUDE_JAVA>");
        }
        return builder.toString();
    }
}

