/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CloneUtil {
    CloneUtil() {
    }

    public static <T extends MetaDataVisitorNode> T cloneObject(T original, Class<T> expectedClass) {
        if (original == null) {
            return null;
        }
        Object clone = original.clone();
        if (!expectedClass.isInstance(clone)) {
            throw new IllegalArgumentException("Clone '" + clone + "' is not of expected class: " + expectedClass);
        }
        return (T)((MetaDataVisitorNode)expectedClass.cast(clone));
    }

    public static <U extends MetaDataVisitorNode, T extends Collection<U>> T cloneCollection(T collection, Class<? extends T> expectedClass, Class<U> componentType) {
        if (collection == null) {
            return null;
        }
        try {
            Collection clone = (Collection)expectedClass.newInstance();
            for (MetaDataVisitorNode item : collection) {
                clone.add(CloneUtil.cloneObject(item, componentType));
            }
            return (T)clone;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <U extends MetaDataVisitorNode, T extends Set<U>> T cloneSet(T collection, Class<? extends T> expectedClass, Class<U> componentType) {
        if (collection == null) {
            return null;
        }
        try {
            Set clone = (Set)expectedClass.newInstance();
            for (MetaDataVisitorNode item : collection) {
                clone.add(CloneUtil.cloneObject(item, componentType));
            }
            return (T)clone;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <U extends MetaDataVisitorNode, T extends List<U>> T cloneList(T collection, Class<? extends T> expectedClass, Class<U> componentType) {
        if (collection == null) {
            return null;
        }
        try {
            List clone = (List)expectedClass.newInstance();
            for (MetaDataVisitorNode item : collection) {
                clone.add(CloneUtil.cloneObject(item, componentType));
            }
            return (T)clone;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <U extends MetaDataVisitorNode, T extends MetaDataVisitorNode> Map<U, T> cloneMap(Map<U, T> map, Class<U> keyClass, Class<T> valueClass) {
        if (map == null) {
            return null;
        }
        HashMap<MetaDataVisitorNode, MetaDataVisitorNode> clone = new HashMap<MetaDataVisitorNode, MetaDataVisitorNode>();
        for (Map.Entry<U, T> entry : map.entrySet()) {
            clone.put(CloneUtil.cloneObject((MetaDataVisitorNode)entry.getKey(), keyClass), CloneUtil.cloneObject((MetaDataVisitorNode)entry.getValue(), valueClass));
        }
        return clone;
    }
}

