/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.vfs.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.version.Version;
import org.jboss.classloading.spi.vfs.dependency.VFSClassLoaderPolicyModule;
import org.jboss.managed.api.annotation.ManagementProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSClassLoaderFactory
extends ClassLoadingMetaData
implements BeanMetaDataFactory {
    private static final long serialVersionUID = -4446195023830263521L;
    public static final String DEFAULT_CLASSLOADER_SYSTEM_NAME = "ClassLoaderSystem";
    private String classLoaderSystemName = "ClassLoaderSystem";
    private String contextName = null;
    private List<String> roots = new CopyOnWriteArrayList<String>();

    public VFSClassLoaderFactory() {
    }

    public VFSClassLoaderFactory(String name) {
        this(name, Version.DEFAULT_VERSION);
    }

    public VFSClassLoaderFactory(String name, String version) {
        this(name, Version.parseVersion((String)version));
    }

    public VFSClassLoaderFactory(String name, Version version) {
        this.setName(name);
        this.setVersion(version);
    }

    public String getClassLoaderSystemName() {
        return this.classLoaderSystemName;
    }

    @ManagementProperty(name="system")
    @XmlAttribute(name="system")
    public void setClassLoaderSystemName(String classLoaderSystemName) {
        if (classLoaderSystemName == null) {
            classLoaderSystemName = DEFAULT_CLASSLOADER_SYSTEM_NAME;
        }
        this.classLoaderSystemName = classLoaderSystemName;
    }

    public String getContextName() {
        return this.contextName;
    }

    @ManagementProperty(name="context")
    @XmlAttribute(name="context")
    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public List<String> getRoots() {
        return this.roots;
    }

    @ManagementProperty(name="roots")
    @XmlElement(name="root")
    public void setRoots(List<String> roots) {
        if (roots == null) {
            roots = new CopyOnWriteArrayList<String>();
        }
        this.roots = roots;
    }

    @XmlTransient
    public List<BeanMetaData> getBeans() {
        String contextName = this.getContextName();
        if (contextName == null) {
            contextName = this.getName() + ":" + this.getVersion().toString();
        }
        String moduleName = contextName + "$MODULE";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)moduleName, (String)VFSClassLoaderPolicyModule.class.getName());
        builder.addConstructorParameter(VFSClassLoaderFactory.class.getName(), (Object)this);
        builder.addConstructorParameter(String.class.getName(), moduleName);
        builder.addPropertyMetaData("roots", this.roots);
        builder.setNoClassLoader();
        builder.addUninstall("removeClassLoader");
        BeanMetaData module = builder.getBeanMetaData();
        builder = BeanMetaDataBuilder.createBuilder((String)contextName, (String)ClassLoader.class.getName());
        builder.setNoClassLoader();
        builder.setFactory(moduleName);
        builder.setFactoryMethod("registerClassLoaderPolicy");
        builder.addConstructorParameter(ClassLoaderSystem.class.getName(), builder.createInject((Object)this.classLoaderSystemName));
        BeanMetaData classLoader = builder.getBeanMetaData();
        return Arrays.asList(classLoader, module);
    }
}

