/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.vfs.dependency;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.plugins.vfs.PackageVisitor;
import org.jboss.classloading.plugins.vfs.VFSResourceVisitor;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSClassLoaderPolicyModule
extends ClassLoaderPolicyModule
implements KernelControllerContextAware {
    private static final long serialVersionUID = 1L;
    private List<String> roots;
    private VirtualFile[] vfsRoots;

    public VFSClassLoaderPolicyModule(VFSClassLoaderFactory classLoadingMetaData, String contextName) {
        super((ClassLoadingMetaData)classLoadingMetaData, contextName);
    }

    public List<String> getRoots() {
        return this.roots;
    }

    public void setRoots(List<String> roots) {
        this.roots = roots;
    }

    protected List<Capability> determineCapabilities() {
        VirtualFile[] roots = this.determineVFSRoots();
        CopyOnWriteArrayList<Capability> capabilities = super.determineCapabilities();
        if (capabilities != null) {
            return capabilities;
        }
        ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
        capabilities = new CopyOnWriteArrayList<Capability>();
        Object version = this.getVersion();
        Capability capability = factory.createModule(this.getName(), version);
        capabilities.add(capability);
        ClassFilter included = this.getIncluded();
        ClassFilter excluded = this.getExcluded();
        ClassFilter excludedExport = this.getExcludedExport();
        ExportAll exportAll = this.getExportAll();
        if (exportAll != null) {
            Set<String> exportedPackages = PackageVisitor.determineAllPackages(roots, null, exportAll, included, excluded, excludedExport);
            for (String packageName : exportedPackages) {
                capability = factory.createPackage(packageName, version);
                capabilities.add(capability);
            }
        }
        return capabilities;
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.setControllerContext((ControllerContext)context);
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.setControllerContext(null);
    }

    protected VFSClassLoaderFactory getClassLoadingMetaData() {
        return (VFSClassLoaderFactory)super.getClassLoadingMetaData();
    }

    protected VirtualFile[] determineVFSRoots() {
        if (this.vfsRoots != null) {
            return this.vfsRoots;
        }
        if (this.roots == null) {
            this.vfsRoots = new VirtualFile[0];
        } else {
            VirtualFile[] vfsRoots = new VirtualFile[this.roots.size()];
            for (int i = 0; i < this.roots.size(); ++i) {
                String root = this.roots.get(i);
                try {
                    URI uri = new URI(root);
                    vfsRoots[i] = VFS.getRoot((URI)uri);
                    continue;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating VFS file for " + root, e);
                }
            }
            this.vfsRoots = vfsRoots;
        }
        return this.vfsRoots;
    }

    public VFSClassLoaderPolicy getPolicy() {
        return (VFSClassLoaderPolicy)super.getPolicy();
    }

    protected VFSClassLoaderPolicy determinePolicy() {
        VirtualFile[] roots = this.determineVFSRoots();
        VFSClassLoaderPolicy policy = VFSClassLoaderPolicy.createVFSClassLoaderPolicy(this.getContextName(), roots);
        String[] packageNames = this.getPackageNames();
        policy.setExportedPackages(packageNames);
        policy.setIncluded(this.getIncluded());
        policy.setExcluded(this.getExcluded());
        policy.setExcludedExport(this.getExcludedExport());
        policy.setExportAll(this.getExportAll());
        policy.setImportAll(this.isImportAll());
        policy.setCacheable(this.isCacheable());
        policy.setBlackListable(this.isBlackListable());
        policy.setDelegates(this.getDelegates());
        return policy;
    }

    public void reset() {
        super.reset();
        this.vfsRoots = null;
    }

    public void visit(ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter, URL ... urls) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("ClassLoader has not been constructed for " + this.getContextName());
        }
        VirtualFile[] roots = this.determineVFSRoots();
        if (roots != null && roots.length > 0) {
            ClassFilter included = this.getIncluded();
            ClassFilter excluded = this.getExcluded();
            VFSResourceVisitor.visit(roots, null, included, excluded, classLoader, visitor, filter, recurseFilter, urls);
        }
    }
}

