/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.jboss.classloader.plugins.ClassLoaderUtils;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderPolicyFactory;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.ImportType;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WildcardDelegateLoader
extends FilteredDelegateLoader {
    private Controller controller;
    private Module module;
    private VersionRange range;

    public WildcardDelegateLoader(Controller controller, ClassLoaderPolicyFactory factory, ClassFilter filter, RequirementDependencyItem item) {
        super(factory, filter);
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        if (item == null) {
            throw new IllegalArgumentException("Null item");
        }
        Requirement requirement = item.getRequirement();
        if (!(requirement instanceof PackageRequirement)) {
            throw new IllegalArgumentException("Illegal package requirement: " + requirement);
        }
        this.controller = controller;
        this.module = item.getModule();
        this.range = ((PackageRequirement)requirement).getVersionRange();
    }

    protected DelegateLoader resolve(String pckg) {
        PackageRequirement requirement = new PackageRequirement(pckg, this.range);
        ControllerState state = this.module.getClassLoaderState();
        WildcardRequirementDependencyItem item = new WildcardRequirementDependencyItem(this.module, requirement, state, state);
        if (item.resolve(this.controller)) {
            Module resolvedModule = item.getResolvedModule();
            DelegateLoader loader = resolvedModule.getDelegateLoader(this.module, requirement);
            loader.setImportType(ImportType.AFTER);
            item.setLoader(loader);
            ClassLoaderPolicy policy = this.getPolicy();
            policy.addExtraDelegate(loader);
            this.module.addIDependOn(item);
            return loader;
        }
        return null;
    }

    protected Class<?> doLoadClass(String className) {
        DelegateLoader loader = this.resolve(ClassLoaderUtils.getClassPackageName((String)className));
        return loader != null ? loader.loadClass(className) : null;
    }

    protected URL doGetResource(String name) {
        DelegateLoader loader = this.resolve(ClassLoaderUtils.getResourcePackageName((String)name));
        return loader != null ? loader.getResource(name) : null;
    }

    protected void doGetResources(String name, Set<URL> urls) throws IOException {
        DelegateLoader loader = this.resolve(ClassLoaderUtils.getResourcePackageName((String)name));
        if (loader != null) {
            loader.getResources(name, urls);
        }
    }

    protected Package doGetPackage(String name) {
        DelegateLoader loader = this.resolve(ClassLoaderUtils.pathToPackage((String)name));
        return loader != null ? loader.getPackage(name) : null;
    }

    public ImportType getImportType() {
        return ImportType.AFTER;
    }

    public void setImportType(ImportType importType) {
    }

    private class WildcardRequirementDependencyItem
    extends RequirementDependencyItem {
        private DelegateLoader loader;

        private WildcardRequirementDependencyItem(Module module, Requirement requirement, ControllerState whenRequired, ControllerState dependentState) {
            super(module, requirement, whenRequired, dependentState);
        }

        public boolean unresolved(Controller controller) {
            ControllerContext context;
            Object iDependOn;
            if (this.loader != null) {
                ClassLoaderPolicy policy = WildcardDelegateLoader.this.getPolicy();
                policy.removeExtraDelegate(this.loader);
            }
            if ((iDependOn = this.getIDependOn()) != null && (context = controller.getContext(iDependOn, null)) != null) {
                DependencyInfo info = context.getDependencyInfo();
                info.removeDependsOnMe((DependencyItem)this);
            }
            WildcardDelegateLoader.this.module.removeIDependOn(this);
            super.unresolved(controller);
            return false;
        }

        void setLoader(DelegateLoader loader) {
            this.loader = loader;
        }
    }
}

