/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency.policy;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderPolicyFactory;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.FilteredDelegateLoader;
import org.jboss.classloader.spi.filter.LazyFilteredDelegateLoader;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.dependency.helpers.ClassLoadingMetaDataModule;
import org.jboss.classloading.spi.dependency.policy.DynamicClassLoaderPolicyFactory;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoaderPolicyModule
extends ClassLoadingMetaDataModule
implements ClassLoaderPolicyFactory {
    private static final long serialVersionUID = -3357427104777457717L;
    private ClassLoaderPolicy policy;
    private ClassLoaderSystem system;
    private ClassLoader classLoader;
    private ClassLoaderPolicyFactory policyFactory;

    public ClassLoaderPolicyModule(ClassLoadingMetaData classLoadingMetaData, String contextName) {
        super(classLoadingMetaData, contextName);
    }

    public void setPolicyFactory(ClassLoaderPolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    @Override
    protected ClassLoader getClassLoaderForClass(final String className) throws ClassNotFoundException {
        if (this.classLoader == null) {
            throw new IllegalStateException("No classloader for module " + this);
        }
        if (!(this.classLoader instanceof BaseClassLoader)) {
            return super.getClassLoaderForClass(className);
        }
        final BaseClassLoader bcl = (BaseClassLoader)this.classLoader;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return bcl.findClassLoader(className);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("Error during findClassLoader for " + className, e);
            }
        }
        return bcl.findClassLoader(className);
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderSystem system) {
        if (system == null) {
            throw new IllegalArgumentException("Null classloader system");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Module " + this + " is not registered, see previous error messages");
        }
        String domainName = this.getDeterminedDomainName();
        ParentPolicy parentPolicy = this.getDeterminedParentPolicy();
        String parentName = this.getDeterminedParentDomainName();
        ClassLoader result = system.registerClassLoaderPolicy(domainName, parentPolicy, parentName, this.getPolicy());
        this.system = system;
        this.classLoader = result;
        ClassLoaderPolicyModule.registerModuleClassLoader(this, result);
        return result;
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderSystem system, ClassLoader parent) {
        ClassLoader result;
        if (system == null) {
            throw new IllegalArgumentException("Null classloader system");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Module " + this + " is not registered, see previous error messages");
        }
        ClassLoaderToLoaderAdapter loader = new ClassLoaderToLoaderAdapter(parent);
        this.classLoader = result = this.registerClassLoaderPolicy(system, (Loader)loader);
        ClassLoaderPolicyModule.registerModuleClassLoader(this, result);
        return result;
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderSystem system, Loader loader) {
        if (system == null) {
            throw new IllegalArgumentException("Null classloader system");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Module " + this + " is not registered, see previous error messages");
        }
        String domainName = this.getDeterminedDomainName();
        ParentPolicy parentPolicy = this.getDeterminedParentPolicy();
        ClassLoader result = system.registerClassLoaderPolicy(domainName, parentPolicy, loader, this.getPolicy());
        this.system = system;
        this.classLoader = result;
        ClassLoaderPolicyModule.registerModuleClassLoader(this, result);
        return result;
    }

    public ClassLoaderPolicy getPolicy() {
        if (this.policy != null) {
            return this.policy;
        }
        if (this.policyFactory == null) {
            this.policyFactory = this;
        }
        this.policy = this.policyFactory.createClassLoaderPolicy();
        return this.policy;
    }

    public void removeClassLoader() {
        if (this.system != null && this.policy != null) {
            this.system.unregisterClassLoaderPolicy(this.policy);
        }
        if (this.classLoader != null) {
            ClassLoaderPolicyModule.unregisterModuleClassLoader(this, this.classLoader);
        }
        this.classLoader = null;
        this.system = null;
        this.policy = null;
    }

    public ClassLoaderPolicy createClassLoaderPolicy() {
        return this.determinePolicy();
    }

    protected abstract ClassLoaderPolicy determinePolicy();

    @Override
    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public DelegateLoader createLazyDelegateLoader(Domain domain, RequirementDependencyItem item) {
        ControllerContext context = this.getControllerContext();
        if (context == null) {
            throw new IllegalStateException("No controller context");
        }
        Controller controller = context.getController();
        Requirement requirement = item.getRequirement();
        if (requirement instanceof PackageRequirement) {
            PackageRequirement pr = (PackageRequirement)requirement;
            ClassFilter filter = pr.toClassFilter();
            if (pr.isWildcard()) {
                ClassLoaderPolicyFactory factory = new ClassLoaderPolicyFactory(){

                    public ClassLoaderPolicy createClassLoaderPolicy() {
                        return ClassLoaderPolicyModule.this.getPolicy();
                    }
                };
                return this.resolveWildcard(controller, factory, filter, item);
            }
            DynamicClassLoaderPolicyFactory factory = new DynamicClassLoaderPolicyFactory(controller, domain, item);
            return new FilteredDelegateLoader((ClassLoaderPolicyFactory)factory, filter);
        }
        DynamicClassLoaderPolicyFactory factory = new DynamicClassLoaderPolicyFactory(controller, domain, item);
        return new LazyFilteredDelegateLoader((ClassLoaderPolicyFactory)factory);
    }

    @Override
    public DelegateLoader getDelegateLoader(Module requiringModule, Requirement requirement) {
        PackageClassFilter filter;
        ClassLoaderPolicyFactory clpf = new ClassLoaderPolicyFactory(){

            public ClassLoaderPolicy createClassLoaderPolicy() {
                if (ClassLoaderPolicyModule.this.policy == null) {
                    throw new IllegalStateException("ClassLoaderPolicy not available");
                }
                return ClassLoaderPolicyModule.this.policy;
            }
        };
        if (requirement instanceof PackageRequirement) {
            PackageRequirement pr = (PackageRequirement)requirement;
            filter = pr.toClassFilter();
        } else {
            filter = PackageClassFilter.createPackageClassFilter(this.determinePackageNames(true));
        }
        return new FilteredDelegateLoader(clpf, (ClassFilter)filter);
    }

    @Override
    public DelegateLoader getDelegateLoader(Module requiringModule, List<String> packages) {
        ClassLoaderPolicyFactory clpf = new ClassLoaderPolicyFactory(){

            public ClassLoaderPolicy createClassLoaderPolicy() {
                return ClassLoaderPolicyModule.this.getPolicy();
            }
        };
        PackageClassFilter filter = PackageClassFilter.createPackageClassFilter(packages);
        return new FilteredDelegateLoader(clpf, (ClassFilter)filter);
    }

    @Override
    public void reset() {
        super.reset();
        this.classLoader = null;
        this.system = null;
        this.policy = null;
    }
}

