/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;

public class MDCUtils {
    private static final String REQUEST_CONTEXT_KEY = "requestContext";
    private static final String PROCESS_CONTEXT_KEY = "processContext";
    private static final String USER_ID_KEY = "userId";
    private static final String TMP_KEY = "tmp";
    private static final String EXP_KEY = "exp";
    private static final Map<String, String> MDC_TO_HEADER = new HashMap<String, String>();
    private static final Map<String, String> HEADER_TO_MDC = new HashMap<String, String>();

    public static Map<String, String> headersFromContext() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, String> e : MDC_TO_HEADER.entrySet()) {
            String value = MDC.get((String)e.getKey());
            if (value == null) continue;
            headers.put(e.getValue(), value);
        }
        return headers;
    }

    public static void contextFromHeader(String header, String value) {
        MDC.put((String)HEADER_TO_MDC.get(header), (String)value);
    }

    public static Set<String> keys() {
        return MDC_TO_HEADER.keySet();
    }

    public static Set<String> headerKeys() {
        return HEADER_TO_MDC.keySet();
    }

    static {
        MDC_TO_HEADER.put(USER_ID_KEY, "log-user-id");
        MDC_TO_HEADER.put(REQUEST_CONTEXT_KEY, "log-request-context");
        MDC_TO_HEADER.put(PROCESS_CONTEXT_KEY, "log-process-context");
        MDC_TO_HEADER.put(TMP_KEY, "log-tmp");
        MDC_TO_HEADER.put(EXP_KEY, "log-exp");
        MDC_TO_HEADER.forEach((k, v) -> HEADER_TO_MDC.put((String)v, (String)k));
    }
}

