/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common.version;

import java.util.Objects;
import java.util.Optional;
import org.commonjava.maven.ext.manip.impl.Version;

public class SuffixedVersion
implements Comparable<SuffixedVersion> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private final String suffix;
    private final Integer suffixVersion;
    private final String originalVersion;

    public SuffixedVersion(int major, int minor, int micro, String qualifier, String originalVersion) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = Objects.requireNonNull(qualifier);
        this.suffix = null;
        this.suffixVersion = null;
        this.originalVersion = originalVersion;
    }

    public SuffixedVersion(int major, int minor, int micro, String qualifier, String suffix, int suffixVersion, String originalVersion) {
        if (suffix == null || suffix.isEmpty()) {
            throw new IllegalArgumentException("Suffix must be provided in this constructor.");
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = Objects.requireNonNull(qualifier);
        this.suffix = Objects.requireNonNull(suffix);
        this.suffixVersion = suffixVersion;
        this.originalVersion = originalVersion;
    }

    public Optional<String> getSuffix() {
        return Optional.ofNullable(this.suffix);
    }

    public Optional<Integer> getSuffixVersion() {
        return Optional.ofNullable(this.suffixVersion);
    }

    public boolean isSuffixed() {
        return this.suffix != null;
    }

    @Override
    public int compareTo(SuffixedVersion other) {
        int r = Integer.compare(this.major, other.major);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.minor, other.minor);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.micro, other.micro);
        if (r != 0) {
            return r;
        }
        r = this.qualifier.compareToIgnoreCase(other.qualifier);
        if (r != 0) {
            return r;
        }
        if (this.suffix == null) {
            if (other.suffix == null) {
                return 0;
            }
            return -1;
        }
        if (other.suffix == null) {
            return 1;
        }
        r = this.suffix.compareToIgnoreCase(other.suffix);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.suffixVersion, other.suffixVersion);
        if (r != 0) {
            return r;
        }
        if (this.isOsgiVersion() && !other.isOsgiVersion()) {
            return 1;
        }
        if (!this.isOsgiVersion() && other.isOsgiVersion()) {
            return -1;
        }
        return 0;
    }

    private boolean isOsgiVersion() {
        Version osgi = new Version(this.originalVersion);
        return this.originalVersion.equals(osgi.getOSGiVersionString());
    }

    public final String normalizedVesion() {
        String q = this.qualifier.isEmpty() ? "" : "." + this.qualifier;
        Object s = "";
        if (this.suffix != null && !this.suffix.isEmpty()) {
            s = q.isEmpty() ? "." : "-";
            s = (String)s + this.suffix + "-" + this.suffixVersion;
        }
        return this.major + "." + this.minor + "." + this.micro + q + (String)s;
    }

    public final String unsuffixedVesion() {
        String q = this.qualifier.isEmpty() ? "" : "." + this.qualifier;
        return this.major + "." + this.minor + "." + this.micro + q;
    }

    public String toString() {
        return this.normalizedVesion();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuffixedVersion)) {
            return false;
        }
        SuffixedVersion other = (SuffixedVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getMicro() != other.getMicro()) {
            return false;
        }
        Optional<Integer> this$suffixVersion = this.getSuffixVersion();
        Optional<Integer> other$suffixVersion = other.getSuffixVersion();
        if (this$suffixVersion == null ? other$suffixVersion != null : !((Object)this$suffixVersion).equals(other$suffixVersion)) {
            return false;
        }
        String this$qualifier = this.getQualifier();
        String other$qualifier = other.getQualifier();
        if (this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier)) {
            return false;
        }
        Optional<String> this$suffix = this.getSuffix();
        Optional<String> other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !((Object)this$suffix).equals(other$suffix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuffixedVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getMicro();
        Optional<Integer> $suffixVersion = this.getSuffixVersion();
        result = result * 59 + ($suffixVersion == null ? 43 : ((Object)$suffixVersion).hashCode());
        String $qualifier = this.getQualifier();
        result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
        Optional<String> $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : ((Object)$suffix).hashCode());
        return result;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }
}

