/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common.version;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.da.common.version.SuffixedVersion;
import org.jboss.da.common.version.VersionComparator;
import org.jboss.da.common.version.VersionParser;

public class VersionAnalyzer {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^((?<major>[0-9]{1,9})?(\\.(?<minor>[0-9]{1,9})(\\.$|[.-](?<micro>[0-9]{1,9}))?)?)(?<qualifier>[.-]?(.+?))?");
    private final VersionParser versionParser;
    private final List<String> suffixes = new ArrayList<String>();

    public VersionAnalyzer(List<String> suffixes) {
        this.suffixes.addAll(suffixes);
        this.versionParser = new VersionParser(suffixes);
    }

    public List<String> sortVersions(String querry, Collection<String> versions) {
        VersionComparator comparator = new VersionComparator(querry, this.versionParser);
        List<String> sortedVersions = versions.stream().sorted(comparator).distinct().collect(Collectors.toList());
        return sortedVersions;
    }

    public Optional<String> findBiggestMatchingVersion(String query, Collection<String> versions) {
        String unsuffixedQuery = this.versionParser.parse(query).unsuffixedVesion();
        List candidateSuffixedVersions = versions.stream().map(this.versionParser::parseSuffixed).flatMap(Collection::stream).filter(v -> unsuffixedQuery.equals(v.unsuffixedVesion())).collect(Collectors.toList());
        List<SuffixedVersion> versionsToSearch = Collections.emptyList();
        for (String suffix : this.suffixes) {
            versionsToSearch = candidateSuffixedVersions.stream().filter(v -> suffix.equals(v.getSuffix().get())).collect(Collectors.toList());
            if (versionsToSearch.isEmpty()) continue;
            break;
        }
        String bestMatchVersion = null;
        int biggestBuildNumber = 0;
        for (SuffixedVersion ver : versionsToSearch) {
            int foundBuildNumber = ver.getSuffixVersion().get();
            if (bestMatchVersion == null || foundBuildNumber > biggestBuildNumber) {
                bestMatchVersion = ver.getOriginalVersion();
                biggestBuildNumber = foundBuildNumber;
                continue;
            }
            if (foundBuildNumber != biggestBuildNumber) continue;
            bestMatchVersion = this.getMoreSpecificVersion(bestMatchVersion, ver.getOriginalVersion());
        }
        return Optional.ofNullable(bestMatchVersion);
    }

    private String getMoreSpecificVersion(String first, String second) {
        boolean returnFirst;
        Matcher firstMatcher = VERSION_PATTERN.matcher(first);
        Matcher secondMatcher = VERSION_PATTERN.matcher(second);
        if (!firstMatcher.matches()) {
            throw new IllegalArgumentException("Couldn't parse version " + first);
        }
        if (!secondMatcher.matches()) {
            throw new IllegalArgumentException("Couldn't parse version " + second);
        }
        boolean firstIsOSGi = first.equals(VersionParser.getOSGiVersion(first));
        String firstMinor = firstMatcher.group("minor");
        String firstMicro = firstMatcher.group("micro");
        if (firstIsOSGi != second.equals(VersionParser.getOSGiVersion(second))) {
            returnFirst = firstIsOSGi;
        } else if (!Objects.equals(firstMinor, secondMatcher.group("minor"))) {
            returnFirst = firstMinor != null;
        } else if (!Objects.equals(firstMicro, secondMatcher.group("micro"))) {
            returnFirst = firstMicro != null;
        } else {
            boolean bl = returnFirst = firstMatcher.group("qualifier").startsWith(".") || !secondMatcher.group("qualifier").startsWith(".");
        }
        if (returnFirst) {
            return first;
        }
        return second;
    }
}

