/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common.version;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.jboss.da.common.version.SuffixedVersion;
import org.jboss.da.common.version.VersionParser;

public class VersionComparator
implements Comparator<String>,
Serializable {
    private final SuffixedVersion base;
    private final VersionParser versionParser;

    public VersionComparator(VersionParser versionParser) {
        this.base = null;
        this.versionParser = versionParser;
    }

    public VersionComparator(String base, VersionParser versionParser) {
        this.versionParser = versionParser;
        this.base = versionParser.parse(base);
    }

    public VersionDifference difference(String version1, String version2) {
        SuffixedVersion v1 = this.versionParser.parse(version1);
        SuffixedVersion v2 = this.versionParser.parse(version2);
        if (v1.getMajor() != v2.getMajor()) {
            return VersionDifference.MAJOR;
        }
        if (v1.getMinor() != v2.getMinor()) {
            return VersionDifference.MINOR;
        }
        if (v1.getMicro() != v2.getMicro()) {
            return VersionDifference.MICRO;
        }
        if (!v1.getQualifier().equals(v2.getQualifier())) {
            return VersionDifference.QUALIFIER;
        }
        if (!v1.getSuffix().equals(v2.getSuffix())) {
            return VersionDifference.SUFFIX;
        }
        if (!v1.getSuffixVersion().equals(v2.getSuffixVersion())) {
            return VersionDifference.RH_SUFFIX;
        }
        return VersionDifference.EQUAL;
    }

    @Override
    public int compare(String version1, String version2) {
        SuffixedVersion v2;
        SuffixedVersion v1 = this.versionParser.parse(version1);
        int r = v1.compareTo(v2 = this.versionParser.parse(version2));
        if (r == 0 || this.base == null) {
            return r;
        }
        return this.compareByDistance(v1, v2);
    }

    private int compareByDistance(SuffixedVersion v1, SuffixedVersion v2) {
        if (this.base.equals(v1)) {
            return -1;
        }
        if (this.base.equals(v2)) {
            return 1;
        }
        if (v1.getMajor() != v2.getMajor()) {
            if (v1.getMajor() == this.base.getMajor()) {
                return -1;
            }
            if (v2.getMajor() == this.base.getMajor()) {
                return 1;
            }
        }
        Object[] versions = new SuffixedVersion[]{this.base, v1, v2};
        Arrays.sort(versions);
        if (versions[0] == this.base) {
            int candidate = versions[1] == v1 ? -1 : 1;
            if (v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v2.getMicro()) {
                candidate *= -1;
            }
            return candidate;
        }
        if (versions[2] == this.base) {
            if (versions[1] == v1) {
                return -1;
            }
            return 1;
        }
        if (versions[2] == v1) {
            return -1;
        }
        return 1;
    }

    public static enum VersionDifference {
        MAJOR,
        MINOR,
        MICRO,
        QUALIFIER,
        SUFFIX,
        RH_SUFFIX,
        EQUAL;

    }
}

