/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common.version;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonjava.maven.ext.manip.impl.Version;
import org.jboss.da.common.version.SuffixedVersion;

public class VersionParser {
    private final Map<String, Pattern> versionPatterns = new HashMap<String, Pattern>();
    static final String RE_MICRO = "(\\.$|[.-](?<micro>[0-9]{1,9}))";
    static final String RE_MMM = "((?<major>[0-9]{1,9})?(\\.(?<minor>[0-9]{1,9})(\\.$|[.-](?<micro>[0-9]{1,9}))?)?)";
    static final String RE_QUALIFIER = "([.-]?(?<qualifier>.+?))";
    static final String RE_QUALIFIER_WITH_SEPARATOR = "(?<qualifier>[.-]?(.+?))";
    private static final String RE_SUFFIX_S = "([.-]";
    private static final String RE_SUFFIX_E = "-(?<suffixversion>[0-9]{1,9}))?";
    private static final Pattern UNSUFFIXED_PATTERN = Pattern.compile("^((?<major>[0-9]{1,9})?(\\.(?<minor>[0-9]{1,9})(\\.$|[.-](?<micro>[0-9]{1,9}))?)?)([.-]?(?<qualifier>.+?))?$");

    public VersionParser(String ... suffix) {
        this(Arrays.asList(suffix));
    }

    public VersionParser(List<String> suffixes) {
        for (String suffix : suffixes) {
            this.versionPatterns.put(suffix, Pattern.compile("^((?<major>[0-9]{1,9})?(\\.(?<minor>[0-9]{1,9})(\\.$|[.-](?<micro>[0-9]{1,9}))?)?)([.-]?(?<qualifier>.+?))??([.-]" + suffix + "-(?<suffixversion>[0-9]{1,9}))?$"));
        }
    }

    public static SuffixedVersion parseUnsuffixed(String version) {
        return VersionParser.parseVersion(UNSUFFIXED_PATTERN.matcher(version), version);
    }

    public SuffixedVersion parse(String version) {
        SuffixedVersion normalized = VersionParser.parseUnsuffixed(version);
        int length = normalized.getQualifier().length();
        for (SuffixedVersion suffixedVersion : this.parseSuffixed(version)) {
            if (suffixedVersion.getQualifier().length() >= length) continue;
            normalized = suffixedVersion;
            length = suffixedVersion.getQualifier().length();
        }
        return normalized;
    }

    public Set<SuffixedVersion> parseSuffixed(String version) {
        HashSet<SuffixedVersion> ret = new HashSet<SuffixedVersion>();
        for (Map.Entry<String, Pattern> entry : this.versionPatterns.entrySet()) {
            String suffix = entry.getKey();
            Pattern versionPattern = entry.getValue();
            SuffixedVersion suffixedVersion = VersionParser.parseVersion(versionPattern.matcher(version), version, suffix);
            if (!suffixedVersion.isSuffixed()) continue;
            ret.add(suffixedVersion);
        }
        return ret;
    }

    private static SuffixedVersion parseVersion(Matcher versionMatcher, String version) throws NumberFormatException, IllegalArgumentException {
        if (!versionMatcher.matches()) {
            throw new IllegalArgumentException("Version " + version + "is unparsable");
        }
        String majorString = versionMatcher.group("major");
        String minorString = versionMatcher.group("minor");
        String microString = versionMatcher.group("micro");
        String qualifierString = versionMatcher.group("qualifier");
        int major = VersionParser.parseNumberString(majorString);
        int minor = VersionParser.parseNumberString(minorString);
        int micro = VersionParser.parseNumberString(microString);
        String qualifier = qualifierString == null ? "" : qualifierString.replace('.', '-').replace(',', '-');
        return new SuffixedVersion(major, minor, micro, qualifier, version);
    }

    private static SuffixedVersion parseVersion(Matcher versionMatcher, String version, String parseSuffix) throws NumberFormatException, IllegalArgumentException {
        String qualifier;
        if (!versionMatcher.matches()) {
            throw new IllegalArgumentException("Version " + version + "is unparsable");
        }
        String majorString = versionMatcher.group("major");
        String minorString = versionMatcher.group("minor");
        String microString = versionMatcher.group("micro");
        String qualifierString = versionMatcher.group("qualifier");
        String suffixVersionString = versionMatcher.group("suffixversion");
        int major = VersionParser.parseNumberString(majorString);
        int minor = VersionParser.parseNumberString(minorString);
        int micro = VersionParser.parseNumberString(microString);
        String string = qualifier = qualifierString == null ? "" : qualifierString.replace('.', '-').replace(',', '-');
        if (suffixVersionString == null) {
            return new SuffixedVersion(major, minor, micro, qualifier, version);
        }
        int suffixVersion = Integer.parseInt(suffixVersionString);
        return new SuffixedVersion(major, minor, micro, qualifier, parseSuffix, suffixVersion, version);
    }

    private static int parseNumberString(String segmentString) {
        return segmentString == null ? 0 : Integer.parseInt(segmentString);
    }

    public static String getOSGiVersion(String version) {
        String osgiS = new Version(version + ".foo").getOSGiVersionString();
        int len = osgiS.length();
        return osgiS.substring(0, len - 4);
    }
}

