/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common;

import java.util.Comparator;
import org.jboss.pnc.common.alignment.ranking.VersionStrategy;

public abstract class ScopedStrategy<T>
extends VersionStrategy
implements Comparator<T> {
    private final String artifactScope;

    public abstract int matchSignificance(T var1);

    public static ScopedStrategy<Object> none() {
        return DefaultScopedStrategy.get();
    }

    @Override
    public int compare(T o1, T o2) {
        int s1 = this.matchSignificance(o1);
        int s2 = this.matchSignificance(o2);
        return Integer.compare(s1, s2);
    }

    protected ScopedStrategy(ScopedStrategyBuilder<T, ?, ?> b) {
        super(b);
        this.artifactScope = b.artifactScope;
    }

    public String getArtifactScope() {
        return this.artifactScope;
    }

    public static abstract class ScopedStrategyBuilder<T, C extends ScopedStrategy<T>, B extends ScopedStrategyBuilder<T, C, B>>
    extends VersionStrategy.VersionStrategyBuilder<C, B> {
        private String artifactScope;

        protected abstract B self();

        public abstract C build();

        public B artifactScope(String artifactScope) {
            this.artifactScope = artifactScope;
            return (B)this.self();
        }

        public String toString() {
            return "ScopedStrategy.ScopedStrategyBuilder(super=" + super.toString() + ", artifactScope=" + this.artifactScope + ")";
        }
    }

    private static class DefaultScopedStrategy
    extends ScopedStrategy<Object> {
        @Override
        public int matchSignificance(Object artifactIdentifier) {
            return 0;
        }

        private static DefaultScopedStrategy get() {
            VersionStrategy vStrategy = VersionStrategy.none();
            return ((DefaultScopedStrategyBuilder)((DefaultScopedStrategyBuilder)((DefaultScopedStrategyBuilder)((DefaultScopedStrategyBuilder)((Object)DefaultScopedStrategy.builder().artifactScope(null))).ranks(vStrategy.getRanks())).allowList(vStrategy.getAllowList())).denyList(vStrategy.getDenyList())).build();
        }

        protected DefaultScopedStrategy(DefaultScopedStrategyBuilder<?, ?> b) {
            super(b);
        }

        public static DefaultScopedStrategyBuilder<?, ?> builder() {
            return new DefaultScopedStrategyBuilderImpl();
        }

        private static final class DefaultScopedStrategyBuilderImpl
        extends DefaultScopedStrategyBuilder<DefaultScopedStrategy, DefaultScopedStrategyBuilderImpl> {
            private DefaultScopedStrategyBuilderImpl() {
            }

            @Override
            protected DefaultScopedStrategyBuilderImpl self() {
                return this;
            }

            @Override
            public DefaultScopedStrategy build() {
                return new DefaultScopedStrategy(this);
            }
        }

        public static abstract class DefaultScopedStrategyBuilder<C extends DefaultScopedStrategy, B extends DefaultScopedStrategyBuilder<C, B>>
        extends ScopedStrategyBuilder<Object, C, B> {
            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "ScopedStrategy.DefaultScopedStrategy.DefaultScopedStrategyBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

