/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common;

import org.jboss.da.common.ScopedStrategy;
import org.jboss.da.model.rest.GAV;
import org.jboss.da.model.rest.Strategy;
import org.jboss.pnc.common.alignment.ranking.AlignmentPredicate;
import org.jboss.pnc.common.alignment.ranking.AlignmentRanking;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;

public class ScopedGAVStrategy
extends ScopedStrategy<GAV> {
    @Override
    public int matchSignificance(GAV gav) {
        if (this.getArtifactScope() == null) {
            return 1;
        }
        String[] scopeSplit = this.getArtifactScope().split(":");
        String group = gav.getGroupId();
        String artifact = gav.getArtifactId();
        String version = gav.getVersion();
        if (scopeSplit.length == 1 && group.equals(scopeSplit[0])) {
            return 2;
        }
        if (scopeSplit.length == 2 && group.equals(scopeSplit[0]) && artifact.equals(scopeSplit[1])) {
            return 3;
        }
        if (scopeSplit.length == 3 && group.equals(scopeSplit[0]) && artifact.equals(scopeSplit[1]) && version.equals(scopeSplit[2])) {
            return 4;
        }
        return 0;
    }

    public static ScopedGAVStrategy from(Strategy restStrategy) throws ValidationException {
        return ((ScopedGAVStrategyBuilder)((ScopedGAVStrategyBuilder)((ScopedGAVStrategyBuilder)((ScopedGAVStrategyBuilder)((Object)ScopedGAVStrategy.builder().artifactScope(restStrategy.getArtifactScope()))).ranks(new AlignmentRanking(restStrategy.getRanks(), null))).allowList(new AlignmentPredicate(restStrategy.getAllowList(), ver -> true))).denyList(new AlignmentPredicate(restStrategy.getDenyList(), ver -> false))).build();
    }

    protected ScopedGAVStrategy(ScopedGAVStrategyBuilder<?, ?> b) {
        super(b);
    }

    public static ScopedGAVStrategyBuilder<?, ?> builder() {
        return new ScopedGAVStrategyBuilderImpl();
    }

    private static final class ScopedGAVStrategyBuilderImpl
    extends ScopedGAVStrategyBuilder<ScopedGAVStrategy, ScopedGAVStrategyBuilderImpl> {
        private ScopedGAVStrategyBuilderImpl() {
        }

        @Override
        protected ScopedGAVStrategyBuilderImpl self() {
            return this;
        }

        @Override
        public ScopedGAVStrategy build() {
            return new ScopedGAVStrategy(this);
        }
    }

    public static abstract class ScopedGAVStrategyBuilder<C extends ScopedGAVStrategy, B extends ScopedGAVStrategyBuilder<C, B>>
    extends ScopedStrategy.ScopedStrategyBuilder<GAV, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ScopedGAVStrategy.ScopedGAVStrategyBuilder(super=" + super.toString() + ")";
        }
    }
}

