/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.da.common.json.AbstractModuleGroup;
import org.jboss.da.common.json.DAConfig;
import org.jboss.da.common.json.DAGroupWrapper;
import org.jboss.da.common.json.GlobalConfig;
import org.jboss.da.common.json.ModuleConfigJson;
import org.jboss.da.common.util.ConfigurationParseException;

@ApplicationScoped
public class Configuration {
    static final String CONFIG_SYSPROP = "da-config-file";
    static final String CONFIG_DEFAULT = "da-config.json";
    private ModuleConfigJson configJson;

    public DAConfig getConfig() throws ConfigurationParseException {
        ModuleConfigJson configJson = this.getConfigJson();
        for (AbstractModuleGroup c : configJson.getConfigs()) {
            if (!c.getClass().isAssignableFrom(DAGroupWrapper.class)) continue;
            DAGroupWrapper daConfigWrapper = (DAGroupWrapper)c;
            return daConfigWrapper.getConfiguration();
        }
        throw new ConfigurationParseException("Config for Dependency Analysis not found");
    }

    public GlobalConfig getGlobalConfig() throws ConfigurationParseException {
        ModuleConfigJson configJson = this.getConfigJson();
        for (AbstractModuleGroup c : configJson.getConfigs()) {
            if (!c.getClass().isAssignableFrom(GlobalConfig.class)) continue;
            return (GlobalConfig)c;
        }
        throw new ConfigurationParseException("Config for Dependency Analysis not found");
    }

    private ModuleConfigJson getConfigJson() throws ConfigurationParseException {
        if (this.configJson == null) {
            try (InputStream configStream = this.getConfigStream();){
                ObjectMapper mapper = new ObjectMapper();
                mapper.registerSubtypes(new NamedType[]{new NamedType(GlobalConfig.class, "global")});
                mapper.registerSubtypes(new NamedType[]{new NamedType(DAGroupWrapper.class, "da")});
                mapper.registerSubtypes(new NamedType[]{new NamedType(DAConfig.class, "da-config")});
                this.configJson = (ModuleConfigJson)mapper.readValue(configStream, ModuleConfigJson.class);
            }
            catch (IOException | RuntimeException e) {
                throw new ConfigurationParseException("Failed to read configuration", e);
            }
        }
        return this.configJson;
    }

    private InputStream getConfigStream() throws IOException {
        File file;
        String configFileName = System.getProperty(CONFIG_SYSPROP);
        if (configFileName == null) {
            configFileName = CONFIG_DEFAULT;
        }
        if ((file = new File(configFileName)).exists()) {
            return new FileInputStream(file);
        }
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(configFileName);
        if (inStream != null) {
            return inStream;
        }
        throw new FileNotFoundException("Missing project config file " + configFileName + ".");
    }
}

