/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.indy.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.da.common.CommunicationException;
import org.jboss.da.communication.indy.model.VersionResponse;
import org.jboss.da.communication.indy.model.npm.NpmMetadata;

@ApplicationScoped
public class MetadataFileParser {
    @Inject
    private ObjectMapper om;

    public static VersionResponse parseMavenMetadata(InputStream in) throws IOException, CommunicationException, JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{VersionResponse.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        return (VersionResponse)jaxbUnmarshaller.unmarshal(in);
    }

    public NpmMetadata parseNpmMetadata(URLConnection connection) throws IOException {
        try (InputStream in = connection.getInputStream();){
            NpmMetadata npmMetadata = (NpmMetadata)this.om.readValue(in, NpmMetadata.class);
            return npmMetadata;
        }
    }
}

