/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.indy.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jboss.da.model.rest.GAV;

public class GAVDependencyTree
implements Comparable<GAVDependencyTree> {
    @NonNull
    private GAV gav;
    private Set<GAVDependencyTree> dependencies = new TreeSet<GAVDependencyTree>();

    public void addDependency(GAVDependencyTree dep) {
        this.dependencies.add(dep);
    }

    public void prune() {
        int previous;
        HashMap<GAV, Set<GAVDependencyTree>> forest = new HashMap<GAV, Set<GAVDependencyTree>>();
        GAVDependencyTree.fillForest(this, forest);
        Map<GAV, Set<GAVDependencyTree>> candidates = forest.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).collect(Collectors.toMap(e -> (GAV)e.getKey(), e -> (Set)e.getValue()));
        do {
            previous = candidates.size();
            GAVDependencyTree.pruneLeaves(this, candidates);
        } while (!candidates.isEmpty() && previous > candidates.size());
    }

    private static void fillForest(GAVDependencyTree tree, Map<GAV, Set<GAVDependencyTree>> forest) {
        Set trees = forest.computeIfAbsent(tree.getGav(), k -> new HashSet());
        trees.add(tree);
        for (GAVDependencyTree t : tree.getDependencies()) {
            GAVDependencyTree.fillForest(t, forest);
        }
    }

    private static void pruneLeaves(GAVDependencyTree tree, Map<GAV, Set<GAVDependencyTree>> candidates) {
        GAVDependencyTree t;
        LinkedList<GAVDependencyTree> bfsQueue = new LinkedList<GAVDependencyTree>();
        LinkedList<GAVDependencyTree> reverseLevelOrder = new LinkedList<GAVDependencyTree>();
        bfsQueue.add(tree);
        while (!bfsQueue.isEmpty()) {
            t = (GAVDependencyTree)bfsQueue.poll();
            reverseLevelOrder.push(t);
            for (GAVDependencyTree d : t.dependencies) {
                bfsQueue.add(d);
            }
        }
        while (!reverseLevelOrder.isEmpty()) {
            t = (GAVDependencyTree)reverseLevelOrder.pop();
            GAVDependencyTree.pruneLeaf(t, candidates);
        }
    }

    private static void pruneLeaf(GAVDependencyTree tree, Map<GAV, Set<GAVDependencyTree>> candidates) {
        Iterator<GAVDependencyTree> it = tree.getDependencies().iterator();
        while (it.hasNext()) {
            GAVDependencyTree d = it.next();
            if (!d.getDependencies().isEmpty() || !candidates.containsKey(d.getGav())) continue;
            it.remove();
            Set<GAVDependencyTree> forest = candidates.get(d.getGav());
            forest.remove(d);
            if (forest.size() > 1) continue;
            candidates.remove(d.getGav());
        }
    }

    @Override
    public int compareTo(GAVDependencyTree o) {
        return this.gav.compareTo(o.gav);
    }

    public GAVDependencyTree() {
    }

    public GAVDependencyTree(@NonNull GAV gav) {
        if (gav == null) {
            throw new NullPointerException("gav is marked non-null but is null");
        }
        this.gav = gav;
    }

    public GAVDependencyTree(@NonNull GAV gav, Set<GAVDependencyTree> dependencies) {
        if (gav == null) {
            throw new NullPointerException("gav is marked non-null but is null");
        }
        this.gav = gav;
        this.dependencies = dependencies;
    }

    @NonNull
    public GAV getGav() {
        return this.gav;
    }

    public void setGav(@NonNull GAV gav) {
        if (gav == null) {
            throw new NullPointerException("gav is marked non-null but is null");
        }
        this.gav = gav;
    }

    public Set<GAVDependencyTree> getDependencies() {
        return this.dependencies;
    }
}

