/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.pnc;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.da.common.json.GlobalConfig;
import org.jboss.da.common.json.LookupMode;
import org.jboss.da.common.util.Configuration;
import org.jboss.da.common.util.ConfigurationParseException;
import org.jboss.da.communication.pnc.PncConnector;
import org.jboss.da.communication.repository.api.RepositoryException;
import org.jboss.da.model.rest.GA;
import org.jboss.pnc.client.ArtifactClient;
import org.jboss.pnc.client.Configuration;
import org.jboss.pnc.client.RemoteCollection;
import org.jboss.pnc.client.RemoteResourceException;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.dto.response.ArtifactInfo;
import org.jboss.pnc.enums.RepositoryType;
import org.slf4j.Logger;

@ApplicationScoped
public class PncConnectorImpl
implements PncConnector {
    @Inject
    private Logger log;
    private GlobalConfig globalConfig;

    @Inject
    public PncConnectorImpl(Configuration configuration) {
        try {
            this.globalConfig = configuration.getGlobalConfig();
        }
        catch (ConfigurationParseException ex) {
            throw new IllegalStateException("Configuration failure, can't parse default repository group", ex);
        }
    }

    private Collection<ArtifactInfo> getArtifacts(String identifierPattern, RepositoryType repoType, LookupMode mode) throws RepositoryException {
        RemoteCollection artCollection;
        ArtifactClient artifactClient = this.getArtifactClient();
        try {
            artCollection = artifactClient.getAllFiltered(identifierPattern, (Set)mode.getArtifactQualities(), repoType, (Set)mode.getBuildCategories());
        }
        catch (RemoteResourceException ex) {
            throw new RepositoryException("Error when reading artifacts from PNC: " + (Object)((Object)ex), ex);
        }
        return artCollection.getAll();
    }

    @Override
    public List<String> getMavenVersions(GA ga, LookupMode mode) throws RepositoryException {
        String identifierPattern = ga.getGroupId() + ':' + ga.getArtifactId() + ":pom:*";
        Collection<ArtifactInfo> arts = this.getArtifacts(identifierPattern, RepositoryType.MAVEN, mode);
        ArrayList<String> versions = new ArrayList<String>(arts.size());
        for (ArtifactInfo art : arts) {
            String[] parts = art.getIdentifier().split(":");
            if (parts.length == 4) {
                versions.add(parts[3]);
                continue;
            }
            this.log.error("Cannot read version for artifact with identifier %s", (Object)art.getIdentifier());
        }
        return versions;
    }

    @Override
    public List<String> getNpmVersions(String packageName, LookupMode mode) throws RepositoryException {
        String identifierPattern = packageName + ":*";
        Collection<ArtifactInfo> arts = this.getArtifacts(identifierPattern, RepositoryType.NPM, mode);
        ArrayList<String> versions = new ArrayList<String>(arts.size());
        for (ArtifactInfo art : arts) {
            String[] parts = art.getIdentifier().split(":");
            if (parts.length == 2) {
                versions.add(parts[1]);
                continue;
            }
            this.log.error("Cannot read version for artifact with identifier %s", (Object)art.getIdentifier());
        }
        return versions;
    }

    private ArtifactClient getArtifactClient() {
        URI uri = URI.create(this.globalConfig.getPncUrl());
        org.jboss.pnc.client.Configuration config = this.getClientConfig(uri.getScheme(), uri.getHost(), uri.getPort());
        return new ArtifactClient(config);
    }

    private org.jboss.pnc.client.Configuration getClientConfig(String protocol, String host, int port) {
        Configuration.ConfigurationBuilder builder = org.jboss.pnc.client.Configuration.builder();
        builder.protocol(protocol);
        builder.host(host);
        builder.port(port == -1 ? null : Integer.valueOf(port));
        builder.mdcToHeadersMappings(MDCUtils.getMDCToHeaderMappings());
        org.jboss.pnc.client.Configuration config = builder.build();
        return config;
    }
}

