/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.pom.impl;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.maven.atlas.graph.rel.DependencyRelationship;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.jboss.da.communication.indy.model.GAVDependencyTree;
import org.jboss.da.communication.pom.GalleyWrapper;
import org.jboss.da.model.rest.DummyVersionComparator;
import org.jboss.da.model.rest.GAV;
import org.slf4j.Logger;

@ApplicationScoped
public class DependencyTreeBuilder {
    @Inject
    private Logger log;

    public GAVDependencyTree getDependencyTree(Set<DependencyRelationship> rels, GAV origin, boolean testDeps, boolean providedDeps) {
        PathNode pathRoot = new PathNode(origin);
        TreeMap<GAV, Set<DependencyRelationship>> byGav = new TreeMap<GAV, Set<DependencyRelationship>>();
        for (DependencyRelationship rel : rels) {
            GAV gav = GalleyWrapper.generateGAV(rel.getDeclaring());
            Set deps = byGav.computeIfAbsent(gav, k -> new TreeSet<DependencyRelationship>(new DependencyRelationshipComparator()));
            deps.add(rel);
        }
        this.walkDependencies(pathRoot, byGav, testDeps, providedDeps);
        GAVDependencyTree depRoot = new GAVDependencyTree(pathRoot.gav);
        this.constructDepTree(depRoot, pathRoot);
        depRoot.prune();
        return depRoot;
    }

    private void constructDepTree(GAVDependencyTree depTree, PathNode pathTree) {
        for (PathNode child : pathTree.childs) {
            GAVDependencyTree d = new GAVDependencyTree(child.gav);
            depTree.addDependency(d);
            this.constructDepTree(d, child);
        }
    }

    private void walkDependencies(PathNode root, Map<GAV, Set<DependencyRelationship>> byGav, boolean testDeps, boolean providedDeps) {
        Set<DependencyRelationship> rels = byGav.get(root.gav);
        if (rels == null) {
            return;
        }
        for (DependencyRelationship d : rels) {
            ArtifactRef target = (ArtifactRef)d.getTarget();
            GAV targetGav = GalleyWrapper.generateGAV((ProjectVersionRef)target);
            if (root.exclude((ProjectRef)target)) continue;
            PathNode pn = new PathNode(root, targetGav);
            pn.addExcludes(d.getExcludes());
            root.addChild(pn);
            if (pn.parents.contains(targetGav)) {
                this.log.warn("Found cyclic dependency: " + root.gav + " -> " + targetGav);
                continue;
            }
            if (!GalleyWrapper.shouldAnalyzeDependencies(d, testDeps, providedDeps)) continue;
            this.walkDependencies(pn, byGav, testDeps, providedDeps);
        }
    }

    private static class PathNodeComparator
    implements Comparator<PathNode>,
    Serializable {
        private PathNodeComparator() {
        }

        @Override
        public int compare(PathNode o1, PathNode o2) {
            return o1.gav.compareTo(o2.gav);
        }
    }

    private static class DependencyRelationshipComparator
    implements Comparator<DependencyRelationship>,
    Serializable {
        private DependencyRelationshipComparator() {
        }

        @Override
        public int compare(DependencyRelationship o1, DependencyRelationship o2) {
            ArtifactRef target1 = (ArtifactRef)o1.getTarget();
            ArtifactRef target2 = (ArtifactRef)o2.getTarget();
            int ret = target1.getGroupId().compareTo(target2.getGroupId());
            if (ret == 0) {
                ret = target1.getArtifactId().compareTo(target2.getArtifactId());
            }
            if (ret == 0) {
                ret = DummyVersionComparator.compareVersions((String)target1.getVersionString(), (String)target2.getVersionString());
            }
            if (ret == 0) {
                String class1 = target1.getClassifier() == null ? "" : target1.getClassifier();
                String class2 = target2.getClassifier() == null ? "" : target2.getClassifier();
                ret = class1.compareTo(class2);
            }
            if (ret == 0) {
                ret = target1.getType().compareTo(target2.getType());
            }
            return ret;
        }
    }

    private static class PathNode {
        private final Set<GAV> parents = new HashSet<GAV>();
        private final Set<ProjectRef> excludes = new HashSet<ProjectRef>();
        private final GAV gav;
        private final Set<PathNode> childs = new TreeSet<PathNode>(new PathNodeComparator());

        public PathNode(GAV gav) {
            this.gav = gav;
        }

        public PathNode(PathNode parent, GAV gav) {
            this.parents.addAll(parent.parents);
            this.parents.add(parent.gav);
            this.excludes.addAll(parent.excludes);
            this.gav = gav;
        }

        public void addExcludes(Set<ProjectRef> excludes) {
            this.excludes.addAll(excludes);
        }

        public boolean exclude(ProjectRef ref) {
            return this.excludes.stream().anyMatch(ex -> ex.matches(ref));
        }

        public void addChild(PathNode pn) {
            this.childs.add(pn);
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + Objects.hashCode(this.parents);
            hash = 89 * hash + Objects.hashCode(this.gav);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathNode other = (PathNode)obj;
            if (!Objects.equals(this.parents, other.parents)) {
                return false;
            }
            return Objects.equals(this.gav, other.gav);
        }
    }
}

