/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.pom;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.commonjava.cartographer.CartoDataException;
import org.commonjava.maven.atlas.graph.model.EProjectDirectRelationships;
import org.commonjava.maven.atlas.graph.rel.DependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.RelationshipType;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.galley.maven.GalleyMaven;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenGAVView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.parse.MavenPomReader;
import org.commonjava.maven.galley.maven.parse.PomPeek;
import org.commonjava.maven.galley.maven.rel.MavenModelProcessor;
import org.commonjava.maven.galley.maven.rel.ModelProcessorConfig;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.SimpleLocation;
import org.jboss.da.common.util.Configuration;
import org.jboss.da.common.util.ConfigurationParseException;
import org.jboss.da.communication.pom.LocalRepo;
import org.jboss.da.communication.pom.PomAnalysisException;
import org.jboss.da.communication.pom.PomReader;
import org.jboss.da.model.rest.GAV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleyWrapper
implements AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(GalleyWrapper.class);
    private final MavenPomReader mvnPomReader;
    private final List<Location> locations = new ArrayList<Location>();
    private final Path scm;
    private final LocalRepo localRepo;
    private ModelProcessorConfig disConf;
    private MavenModelProcessor processor;

    public GalleyWrapper(GalleyMaven galley, File scmDir, ModelProcessorConfig disConf, MavenModelProcessor processor) throws IOException {
        this.disConf = disConf;
        this.processor = processor;
        this.mvnPomReader = galley.getPomReader();
        this.scm = scmDir.toPath();
        this.localRepo = new LocalRepo(galley, scmDir);
        this.locations.add(this.localRepo.getLocation());
    }

    public Artifact getPom(String pomPath) throws PomAnalysisException {
        Artifact a = new Artifact(this.scm, pomPath);
        if (a.ref == null) {
            throw new PomAnalysisException("Could not analyse pom " + this.scm.resolve(pomPath));
        }
        return a;
    }

    public Artifact getGAV(GAV gav) throws PomAnalysisException {
        try {
            for (Path p : LocalRepo.getAllPoms(this.scm)) {
                PomPeek pp = new PomPeek(p.toFile());
                if (pp.getKey() == null || !gav.equals((Object)GalleyWrapper.generateGAV(pp.getKey()))) continue;
                return new Artifact(p);
            }
        }
        catch (IOException ex) {
            throw new PomAnalysisException(ex);
        }
        throw new PomAnalysisException("Artifact " + gav + " was not found in repository");
    }

    public Set<Artifact> getModules(Artifact artifact) {
        return artifact.pp.getModules().stream().map(m -> artifact.path.resolve((String)m)).map(x$0 -> new Artifact((Path)x$0)).filter(a -> ((Artifact)a).ref != null).collect(Collectors.toSet());
    }

    public Set<Artifact> getAllModules(Artifact artifact) {
        HashSet<Artifact> ret = new HashSet<Artifact>();
        this.fillModules(ret, artifact);
        return ret;
    }

    private void fillModules(Set<Artifact> modules, Artifact artifact) {
        modules.add(artifact);
        for (Artifact a : this.getModules(artifact)) {
            this.fillModules(modules, a);
        }
    }

    public MavenPomView getPomView(Artifact artifact) throws PomAnalysisException {
        try {
            return this.mvnPomReader.read(artifact.ref, this.locations, new String[0]);
        }
        catch (GalleyMavenException ex) {
            throw new PomAnalysisException(ex);
        }
    }

    public Set<GAV> getDependencies(Artifact artifact) throws PomAnalysisException {
        List allDirectDependencies;
        ProjectVersionRef ref = artifact.ref;
        try {
            MavenPomView view = this.mvnPomReader.read(ref, this.locations, new String[0]);
            allDirectDependencies = view.getAllDirectDependencies();
        }
        catch (GalleyMavenException ex) {
            throw new PomAnalysisException(ex);
        }
        return allDirectDependencies.stream().map(GalleyWrapper::generateGAV).filter(x -> x != null).collect(Collectors.toSet());
    }

    public void addLocations(List<String> repositories) {
        repositories.stream().map(repository -> new SimpleLocation(repository, repository)).forEachOrdered(this.locations::add);
    }

    public void addLocationsFromPoms(PomReader pomReader) throws IOException {
        Set<Path> allPoms = this.localRepo.getAllPoms();
        allPoms.stream().map(Path::toFile).map(pomReader::analyze).filter(Optional::isPresent).map(Optional::get).map(p -> p.getMavenRepositories()).filter(r -> r != null).flatMap(r -> r.stream()).map(r -> new SimpleLocation(r.getId(), r.getUrl())).forEach(l -> this.locations.add((Location)l));
    }

    public void addDefaultLocations(Configuration config) {
        try {
            this.locations.add((Location)new SimpleLocation("indy", config.getGlobalConfig().getIndyUrl() + "/api/content/maven/group/" + config.getConfig().getIndyGroupPublic() + "/"));
        }
        catch (ConfigurationParseException e) {
            log.error("Failed to add indy group to locations" + (Object)((Object)e));
        }
    }

    @Override
    public void close() {
        this.localRepo.delete();
    }

    public Set<DependencyRelationship> getAllDependencies(Artifact artifact) throws GalleyMavenException, CartoDataException {
        return this.getAllDependencies(artifact, false, false);
    }

    public Set<DependencyRelationship> getAllDependencies(Artifact artifact, boolean testDeps, boolean providedDeps) throws GalleyMavenException, CartoDataException {
        HashSet<DependencyRelationship> deps = new HashSet<DependencyRelationship>();
        URI src = this.localRepo.getUri();
        LinkedList<DependencyRelationship> work = new LinkedList<DependencyRelationship>();
        work.addAll(this.getDeps(artifact.ref, this.processor, src, this.disConf));
        while (!work.isEmpty()) {
            DependencyRelationship dr = (DependencyRelationship)work.remove();
            if (deps.contains(dr)) continue;
            deps.add(dr);
            if (!GalleyWrapper.shouldAnalyzeDependencies(dr, testDeps, providedDeps)) continue;
            try {
                work.addAll(this.getDeps(dr.getTarget(), this.processor, src, this.disConf));
            }
            catch (CartoDataException | GalleyMavenException ex) {
                log.warn("Failed to get dependencies for " + dr.getTarget(), ex);
            }
        }
        return deps;
    }

    private Set<DependencyRelationship> getDeps(ProjectVersionRef ref, MavenModelProcessor processor, URI src, ModelProcessorConfig disConf) throws GalleyMavenException, CartoDataException {
        MavenPomView pomView = this.mvnPomReader.read(ref, this.locations, new String[0]);
        EProjectDirectRelationships relationships = processor.readRelationships(pomView, src, disConf);
        return relationships.getAllRelationships().stream().filter(r -> r.getType() == RelationshipType.DEPENDENCY).map(r -> (DependencyRelationship)r).collect(Collectors.toSet());
    }

    public static boolean shouldAnalyzeDependencies(DependencyRelationship dr, boolean testDeps, boolean providedDeps) {
        switch (dr.getScope()) {
            case _import: 
            case embedded: 
            case system: 
            case toolchain: {
                return false;
            }
            case test: {
                return testDeps;
            }
            case provided: {
                return providedDeps;
            }
        }
        return true;
    }

    private static GAV generateGAV(MavenGAVView dep) {
        try {
            if (dep.getGroupId() == null || dep.getArtifactId() == null || dep.getVersion() == null) {
                log.warn("Failed to get gav of dependency because of null field. Dependency: " + dep);
                return null;
            }
            return new GAV(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
        }
        catch (GalleyMavenException ex) {
            log.warn("Failed to get gav of dependency " + dep, (Throwable)ex);
            return null;
        }
    }

    public static GAV generateGAV(ProjectVersionRef dep) {
        return new GAV(dep.getGroupId(), dep.getArtifactId(), dep.getVersionString());
    }

    public static class Artifact {
        private Path path;
        private PomPeek pp;
        private ProjectVersionRef ref;

        private Artifact(Path p) {
            this.path = p;
            if (this.path.endsWith("pom.xml")) {
                this.path = this.path.getParent();
            }
            this.pp = new PomPeek(this.path.resolve("pom.xml").toFile());
            this.ref = this.pp.getKey();
        }

        private Artifact(Path basePath, String pomPath) {
            this(basePath.resolve(Artifact.toRelative(pomPath)));
        }

        public String toString() {
            return "GalleyWrapper.Artifact{path=" + this.path + '}';
        }

        public GAV getGAV() throws PomAnalysisException {
            if (this.ref == null) {
                throw new PomAnalysisException("Failed to get gav from " + this.path);
            }
            return new GAV(this.ref.getGroupId(), this.ref.getArtifactId(), this.ref.getVersionString());
        }

        private static String toRelative(String path) {
            if (path.startsWith("/")) {
                return path.replaceFirst("/", "");
            }
            return path;
        }
    }
}

