/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.scm.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.maven.scm.ScmException;
import org.jboss.da.communication.indy.model.GAVDependencyTree;
import org.jboss.da.communication.pom.PomAnalysisException;
import org.jboss.da.communication.pom.api.PomAnalyzer;
import org.jboss.da.communication.pom.model.MavenProject;
import org.jboss.da.communication.scm.api.SCMConnector;
import org.jboss.da.model.rest.GA;
import org.jboss.da.model.rest.GAV;
import org.jboss.da.scm.api.SCM;
import org.jboss.da.scm.api.SCMType;

@ApplicationScoped
public class SCMConnectorImpl
implements SCMConnector {
    @Inject
    private SCM scmManager;
    @Inject
    private PomAnalyzer pomAnalyzer;

    @Override
    public GAVDependencyTree getDependencyTreeOfRevision(String scmUrl, String revision, GAV gav) throws ScmException, PomAnalysisException {
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        GAVDependencyTree gavDependencyTree = this.pomAnalyzer.readRelationships(tempDir, gav);
        return gavDependencyTree;
    }

    @Override
    public Set<GAV> getToplevelDependencyOfRevision(String scmUrl, String revision, GAV gav) throws ScmException, PomAnalysisException {
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        return this.pomAnalyzer.getToplevelDepency(tempDir, gav);
    }

    @Override
    public GAVDependencyTree getDependencyTreeOfRevision(String scmUrl, String revision, String pomPath, List<String> repositories) throws ScmException, PomAnalysisException {
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        GAVDependencyTree gavDependencyTree = this.pomAnalyzer.readRelationships(tempDir, pomPath, repositories);
        return gavDependencyTree;
    }

    @Override
    public Set<GAV> getToplevelDependencyOfRevision(String scmUrl, String revision, String pomPath, List<String> repositories) throws ScmException, PomAnalysisException {
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        return this.pomAnalyzer.getToplevelDepency(tempDir, pomPath, repositories);
    }

    @Override
    public Optional<MavenProject> getPom(String scmUrl, String revision, String pomPath) throws ScmException {
        if (!pomPath.endsWith("pom.xml")) {
            pomPath = pomPath + "/pom.xml";
        }
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        return this.pomAnalyzer.readPom(new File(tempDir, pomPath));
    }

    @Override
    public boolean isGAVInRepository(String scmUrl, String revision, GAV gav) throws ScmException {
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        return this.pomAnalyzer.getPOMFileForGAV(tempDir, gav).isPresent();
    }

    @Override
    public Optional<MavenProject> getPom(String scmUrl, String revision, GAV gav) throws ScmException {
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        return this.pomAnalyzer.getPOMFileForGAV(tempDir, gav).flatMap(file -> this.pomAnalyzer.readPom((File)file));
    }

    @Override
    public Map<GA, Set<GAV>> getDependenciesOfModules(String scmUrl, String revision, String pomPath, List<String> repositories) throws ScmException, PomAnalysisException {
        File tempDir = this.scmManager.cloneRepository(SCMType.GIT, scmUrl, revision);
        return this.pomAnalyzer.getDependenciesOfModules(tempDir, pomPath, repositories);
    }
}

