/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.indy.impl;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import org.jboss.da.common.CommunicationException;
import org.jboss.da.common.json.DAConfig;
import org.jboss.da.common.json.GlobalConfig;
import org.jboss.da.common.logging.MDCUtils;
import org.jboss.da.common.util.Configuration;
import org.jboss.da.common.util.ConfigurationParseException;
import org.jboss.da.common.util.UserLog;
import org.jboss.da.communication.indy.api.IndyConnector;
import org.jboss.da.communication.indy.impl.MetadataFileParser;
import org.jboss.da.communication.indy.model.VersionResponse;
import org.jboss.da.communication.pom.api.PomAnalyzer;
import org.jboss.da.communication.pom.model.MavenProject;
import org.jboss.da.communication.repository.api.RepositoryException;
import org.jboss.da.model.rest.GA;
import org.jboss.da.model.rest.GAV;
import org.jboss.pnc.pncmetrics.MetricsConfiguration;
import org.slf4j.Logger;

@ApplicationScoped
public class IndyConnectorImpl
implements IndyConnector {
    private static final String METRICS_KEY = "da.client.indy.timer";
    @Inject
    private Logger log;
    @Inject
    @UserLog
    private Logger userLog;
    private DAConfig config;
    private GlobalConfig globalConfig;
    @Inject
    private PomAnalyzer pomAnalyzer;
    @Inject
    private MetadataFileParser parser;
    @Inject
    private MetricsConfiguration metricsConfiguration;

    @Inject
    public IndyConnectorImpl(Configuration configuration) {
        try {
            this.config = configuration.getConfig();
            this.globalConfig = configuration.getGlobalConfig();
        }
        catch (ConfigurationParseException ex) {
            throw new IllegalStateException("Configuration failure, can't parse default repository group", ex);
        }
    }

    @Override
    public List<String> getVersionsOfGA(GA ga) throws RepositoryException {
        String query = this.repositoryLink("maven", ga.getGroupId().replace(".", "/") + "/" + ga.getArtifactId());
        MetricRegistry registry = this.metricsConfiguration.getMetricRegistry();
        Timer.Context context = null;
        if (registry != null) {
            Timer timer = registry.timer(METRICS_KEY);
            context = timer.time();
        }
        try {
            this.userLog.info("Retrieving versions for maven artifacts " + ga + " from " + query);
            HttpURLConnection connection = this.getResponse(query);
            List<String> versions = this.parseMetadataFile(connection).getVersioning().getVersions().getVersion();
            this.log.debug("Maven metadata for {} found. Response: {}. Versions: {}", new Object[]{ga, connection.getResponseCode(), versions});
            List<String> list = versions;
            return list;
        }
        catch (FileNotFoundException ex) {
            this.log.debug("Maven metadata for {} not found. Assuming empty version list.", (Object)ga);
            List<String> list = Collections.emptyList();
            return list;
        }
        catch (IOException | CommunicationException e) {
            throw new RepositoryException("Failed to obtain versions for " + ga + " from repository on url " + query, e);
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    @Override
    public List<String> getVersionsOfNpm(String packageName) throws RepositoryException {
        String query = this.repositoryLink("npm", packageName);
        try {
            this.userLog.info("Retrieving versions for npm artifacts " + packageName + " from " + query);
            this.log.info("Retrieving npm metadata for " + packageName + " from " + query);
            HttpURLConnection connection = this.getResponse(query);
            Set<String> versions = this.parser.parseNpmMetadata(connection).getVersions().keySet();
            this.log.debug("Npm metadata for {} found. Response: {}. Versions: {}", new Object[]{packageName, connection.getResponseCode(), versions});
            return new ArrayList<String>(versions);
        }
        catch (FileNotFoundException ex) {
            this.log.debug("Npm metadata for {} not found. Assuming empty version list.", (Object)packageName);
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to obtain versions for " + packageName + " from repository on url " + query, e);
        }
    }

    private String repositoryLink(String type, String path) {
        StringBuilder query = new StringBuilder();
        query.append(this.globalConfig.getIndyUrl());
        query.append("/api/content/");
        query.append(type);
        query.append("/group/");
        query.append(this.config.getIndyGroup()).append('/');
        query.append(path).append('/');
        switch (type) {
            case "maven": {
                query.append("maven-metadata.xml");
                break;
            }
            case "npm": {
                query.append("package.json");
            }
        }
        return query.toString();
    }

    private HttpURLConnection getResponse(String query) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(query).openConnection();
        MDCUtils.headersFromContext().forEach(connection::addRequestProperty);
        connection.setConnectTimeout(this.config.getIndyRequestTimeout());
        connection.setReadTimeout(this.config.getIndyRequestTimeout());
        int retry = 0;
        while ((connection.getResponseCode() == 504 || connection.getResponseCode() == 500) && retry < this.config.getIndyRequestRetries()) {
            this.userLog.warn("Connection to: {} failed with status: {}. retrying...", (Object)query, (Object)connection.getResponseCode());
            this.log.warn("Connection to: {} failed with status: {}. retrying...", (Object)query, (Object)connection.getResponseCode());
            ++retry;
            try {
                Thread.sleep(Math.min((long)Math.pow(2.0, retry) * 100L, 5000L));
            }
            catch (InterruptedException e) {
                this.log.error(e.getMessage());
            }
            connection = (HttpURLConnection)new URL(query).openConnection();
            MDCUtils.headersFromContext().forEach(connection::addRequestProperty);
            connection.setConnectTimeout(this.config.getIndyRequestTimeout());
            connection.setReadTimeout(this.config.getIndyRequestTimeout());
        }
        return connection;
    }

    @Override
    public Optional<MavenProject> getPom(GAV gav) throws RepositoryException {
        return this.getPomStream(gav).flatMap(this.pomAnalyzer::readPom);
    }

    @Override
    public Optional<InputStream> getPomStream(GAV gav) throws RepositoryException {
        StringBuilder query = new StringBuilder();
        try {
            query.append(this.globalConfig.getIndyUrl());
            query.append("/api/content/maven/group/");
            query.append(this.config.getIndyGroupPublic()).append('/');
            query.append(gav.getGroupId().replace(".", "/")).append("/");
            query.append(gav.getArtifactId()).append('/');
            query.append(gav.getVersion()).append('/');
            query.append(gav.getArtifactId()).append('-').append(gav.getVersion()).append(".pom");
            URLConnection connection = new URL(query.toString()).openConnection();
            MDCUtils.headersFromContext().forEach(connection::addRequestProperty);
            return Optional.of(connection.getInputStream());
        }
        catch (FileNotFoundException ex) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to obtain pom for " + gav + " from repository on url " + query, e);
        }
    }

    @Override
    public boolean doesGAVExistInPublicRepo(GAV gav) throws RepositoryException {
        StringBuilder query = new StringBuilder();
        try {
            query.append(this.globalConfig.getIndyUrl());
            query.append("/api/content/maven/group/");
            query.append(this.config.getIndyGroupPublic()).append('/');
            query.append(gav.getGroupId().replace(".", "/")).append("/");
            query.append(gav.getArtifactId()).append('/');
            query.append(gav.getVersion()).append('/');
            query.append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".pom");
            URLConnection connection = new URL(query.toString()).openConnection();
            MDCUtils.headersFromContext().forEach(connection::addRequestProperty);
            try {
                connection.getInputStream().close();
                return true;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to check existence of pom for " + gav + " in repository on url " + query, e);
        }
    }

    private VersionResponse parseMetadataFile(URLConnection connection) throws IOException, CommunicationException {
        VersionResponse versionResponse;
        block8: {
            InputStream in = connection.getInputStream();
            try {
                versionResponse = MetadataFileParser.parseMavenMetadata(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JAXBException e) {
                    throw new RepositoryException("Failed to parse metadata file", e);
                }
            }
            in.close();
        }
        return versionResponse;
    }
}

