/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.pom;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.maven.GalleyMaven;
import org.commonjava.maven.galley.maven.parse.PomPeek;
import org.commonjava.maven.galley.maven.spi.type.TypeMapper;
import org.commonjava.maven.galley.maven.util.ArtifactPathUtils;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.SimpleLocation;
import org.jboss.da.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepo {
    private static final Logger log = LoggerFactory.getLogger(LocalRepo.class);
    private Path path = Files.createTempDirectory("deps", new FileAttribute[0]);
    private static final String SUFFIX = "-20150205.044024-1.pom";

    public LocalRepo(GalleyMaven galley, File scmDir) throws IOException {
        this.initLocalRepo(galley, scmDir.toPath());
    }

    public synchronized Location getLocation() {
        return new SimpleLocation(this.getUri().toString());
    }

    public synchronized URI getUri() {
        return this.path.toUri();
    }

    private void initLocalRepo(GalleyMaven galley, Path scmDir) throws IOException {
        Set<Path> poms = LocalRepo.getAllPoms(scmDir);
        for (Path pomFile : poms) {
            PomPeek peek = new PomPeek(pomFile.toFile());
            ProjectVersionRef key = peek.getKey();
            if (key == null) {
                log.warn("Could not parse " + pomFile.toAbsolutePath());
                continue;
            }
            try {
                String artifactPath = ArtifactPathUtils.formatArtifactPath((ProjectVersionRef)key.asPomArtifact(), (TypeMapper)galley.getTypeMapper());
                Path p = this.path.resolve(artifactPath);
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                if (key.getVersionSpec().isSnapshot()) {
                    this.initSnapshot(key, pomFile, p);
                    continue;
                }
                Files.copy(pomFile, p, new CopyOption[0]);
            }
            catch (RuntimeException | TransferException ex) {
                log.warn("Could not parse " + pomFile.toAbsolutePath(), ex);
            }
            catch (FileAlreadyExistsException ex) {
                log.error("File already exists. This is because there are multiple file with same GAV. This ususaly happens when there are pom files in tests and is harmless in this case.", (Throwable)ex);
            }
        }
    }

    public static Set<Path> getAllPoms(Path scmDir) throws IOException {
        return Files.walk(scmDir, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.endsWith("pom.xml")).collect(Collectors.toSet());
    }

    public synchronized Set<Path> getAllPoms() throws IOException {
        return Files.walk(this.path, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.toString().endsWith(".pom")).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete() {
        File f;
        LocalRepo localRepo = this;
        synchronized (localRepo) {
            f = this.path.toFile();
            this.path = null;
        }
        FileUtils.deleteDirectory((File)f);
    }

    private void initSnapshot(ProjectVersionRef key, Path pomFile, Path p) throws IOException {
        Path dir = p.getParent();
        Path metadata = dir.resolve("maven-metadata.xml");
        if (Files.exists(metadata, new LinkOption[0])) {
            throw new UnsupportedOperationException("Merging of metadata is not supported yet. Conflicting metadata: " + metadata);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(LocalRepo.class.getResourceAsStream("/template/maven-metadata.xml")));){
            Stream<String> lines = reader.lines().map(l -> l.replace("${groupId}", key.getGroupId())).map(l -> l.replace("${artifactId}", key.getGroupId())).map(l -> l.replace("${version}", key.getVersionString().replace("-SNAPSHOT", "")));
            Files.write(metadata, lines::iterator, new OpenOption[0]);
            Path newPomFile = dir.resolve(p.getFileName().toString().replace("-SNAPSHOT.pom", SUFFIX));
            Files.copy(pomFile, newPomFile, new CopyOption[0]);
        }
    }
}

