/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.pom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.cartographer.CartoDataException;
import org.commonjava.cartographer.CartographerCore;
import org.commonjava.maven.atlas.graph.rel.DependencyRelationship;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.parse.MavenPomReader;
import org.commonjava.maven.galley.maven.parse.PomPeek;
import org.commonjava.maven.galley.maven.rel.MavenModelProcessor;
import org.commonjava.maven.galley.maven.rel.ModelProcessorConfig;
import org.commonjava.maven.galley.model.SimpleLocation;
import org.jboss.da.common.json.DAConfig;
import org.jboss.da.common.json.GlobalConfig;
import org.jboss.da.common.util.Configuration;
import org.jboss.da.common.util.ConfigurationParseException;
import org.jboss.da.communication.indy.model.GAVDependencyTree;
import org.jboss.da.communication.pom.GalleyWrapper;
import org.jboss.da.communication.pom.LocalRepo;
import org.jboss.da.communication.pom.PomAnalysisException;
import org.jboss.da.communication.pom.PomReader;
import org.jboss.da.communication.pom.api.PomAnalyzer;
import org.jboss.da.communication.pom.impl.DependencyTreeBuilder;
import org.jboss.da.communication.pom.model.MavenProject;
import org.jboss.da.communication.pom.qualifier.DACartographerCore;
import org.jboss.da.model.rest.GA;
import org.jboss.da.model.rest.GAV;
import org.slf4j.Logger;

@ApplicationScoped
public class PomAnalyzerImpl
implements PomAnalyzer {
    @Inject
    private Logger log;
    @Inject
    private PomReader pomReader;
    @Inject
    @DACartographerCore
    private CartographerCore carto;
    @Inject
    private Configuration config;
    @Inject
    private DependencyTreeBuilder dtb;
    @Inject
    private ModelProcessorConfig disConf;
    @Inject
    private MavenModelProcessor processor;

    @Override
    public GAVDependencyTree readRelationships(File pomRepoDir, String pomPath, List<String> repositories) throws PomAnalysisException {
        GalleyWrapper gw = new GalleyWrapper(this.carto.getGalley(), pomRepoDir, this.disConf, this.processor);
        try {
            GalleyWrapper.Artifact pom = gw.getPom(pomPath);
            gw.addLocations(repositories);
            GAVDependencyTree gAVDependencyTree = this.readRelationships(gw, pom);
            gw.close();
            return gAVDependencyTree;
        }
        catch (Throwable throwable) {
            try {
                try {
                    gw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new PomAnalysisException(ex);
            }
        }
    }

    @Override
    public GAVDependencyTree readRelationships(File pomRepoDir, GAV gav) throws PomAnalysisException {
        GalleyWrapper gw = new GalleyWrapper(this.carto.getGalley(), pomRepoDir, this.disConf, this.processor);
        try {
            GalleyWrapper.Artifact artifact = gw.getGAV(gav);
            GAVDependencyTree gAVDependencyTree = this.readRelationships(gw, artifact);
            gw.close();
            return gAVDependencyTree;
        }
        catch (Throwable throwable) {
            try {
                try {
                    gw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new PomAnalysisException(ex);
            }
        }
    }

    private GAVDependencyTree readRelationships(GalleyWrapper gw, GalleyWrapper.Artifact a) throws PomAnalysisException {
        try {
            gw.addDefaultLocations(this.config);
            gw.addLocationsFromPoms(this.pomReader);
            Set<DependencyRelationship> relationships = gw.getAllDependencies(a);
            GAV originGAV = a.getGAV();
            return this.dtb.getDependencyTree(relationships, originGAV, false, false);
        }
        catch (IOException | CartoDataException | GalleyMavenException ex) {
            throw new PomAnalysisException(ex);
        }
    }

    @Override
    public Set<GAV> getToplevelDepency(File pomRepoDir, GAV gav) throws PomAnalysisException {
        GalleyWrapper gw = new GalleyWrapper(this.carto.getGalley(), pomRepoDir, this.disConf, this.processor);
        try {
            GalleyWrapper.Artifact artifact = gw.getGAV(gav);
            gw.addDefaultLocations(this.config);
            gw.addLocationsFromPoms(this.pomReader);
            Set<GAV> set = gw.getDependencies(artifact);
            gw.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    gw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new PomAnalysisException(ex);
            }
        }
    }

    @Override
    public Set<GAV> getToplevelDepency(File pomRepoDir, String pomPath, List<String> repositories) throws PomAnalysisException {
        GalleyWrapper gw = new GalleyWrapper(this.carto.getGalley(), pomRepoDir, this.disConf, this.processor);
        try {
            GalleyWrapper.Artifact artifact = gw.getPom(pomPath);
            gw.addLocations(repositories);
            gw.addDefaultLocations(this.config);
            gw.addLocationsFromPoms(this.pomReader);
            Set<GAV> set = gw.getDependencies(artifact);
            gw.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    gw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new PomAnalysisException(ex);
            }
        }
    }

    @Override
    public Optional<File> getPOMFileForGAV(File pomRepoDir, GAV gav) {
        try {
            return LocalRepo.getAllPoms(pomRepoDir.toPath()).stream().filter(p -> this.isProjectVersionRefSameAsGAV((Path)p, gav)).map(Path::toFile).findAny();
        }
        catch (IOException ex) {
            this.log.warn("Failed to find pom for GAV", (Throwable)ex);
            return Optional.empty();
        }
    }

    @Override
    public MavenPomView getGitPomView(File repoDir, String pomPath, List<String> repositories) throws PomAnalysisException {
        GalleyWrapper gw = new GalleyWrapper(this.carto.getGalley(), repoDir, this.disConf, this.processor);
        try {
            GalleyWrapper.Artifact pom = gw.getPom(pomPath);
            gw.addDefaultLocations(this.config);
            gw.addLocationsFromPoms(this.pomReader);
            gw.addLocations(repositories);
            MavenPomView mavenPomView = gw.getPomView(pom);
            gw.close();
            return mavenPomView;
        }
        catch (Throwable throwable) {
            try {
                try {
                    gw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new PomAnalysisException(ex);
            }
        }
    }

    @Override
    public MavenPomView getMavenPomView(InputStream is) throws ConfigurationParseException, GalleyMavenException {
        PomPeek pom = new PomPeek(is);
        if (pom.getKey() == null) {
            this.log.warn("Could not parse pom for GAV");
        }
        StringBuilder query = new StringBuilder();
        GlobalConfig globalCfg = this.config.getGlobalConfig();
        DAConfig cfg = this.config.getConfig();
        query.append(globalCfg.getIndyUrl());
        query.append("/api/content/maven/group/");
        query.append(this.config.getConfig().getIndyGroupPublic());
        query.append('/');
        SimpleLocation repoLocation = new SimpleLocation(query.toString());
        ArrayList<SimpleLocation> repos = new ArrayList<SimpleLocation>();
        repos.add(repoLocation);
        MavenPomReader mavenPomReader = this.carto.getGalley().getPomReader();
        MavenPomView pomView = mavenPomReader.read(pom.getKey(), repos, new String[0]);
        return pomView;
    }

    @Override
    public Map<GA, Set<GAV>> getDependenciesOfModules(File scmDir, String pomPath, List<String> repositories) throws PomAnalysisException {
        GalleyWrapper wrapper = new GalleyWrapper(this.carto.getGalley(), scmDir, this.disConf, this.processor);
        try {
            wrapper.addDefaultLocations(this.config);
            wrapper.addLocations(repositories);
            wrapper.addLocationsFromPoms(this.pomReader);
            GalleyWrapper.Artifact rootPom = wrapper.getPom(pomPath);
            Set<GalleyWrapper.Artifact> allModules = wrapper.getAllModules(rootPom);
            HashMap<GA, Set<GAV>> ret = new HashMap<GA, Set<GAV>>();
            for (GalleyWrapper.Artifact a : allModules) {
                try {
                    Set<GAV> dependencies = wrapper.getDependencies(a);
                    ret.put(a.getGAV().getGA(), dependencies);
                }
                catch (PomAnalysisException ex) {
                    this.log.warn("Failed to get dependencies for module " + a, (Throwable)ex);
                }
            }
            HashMap<GA, Set<GAV>> hashMap = ret;
            wrapper.close();
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                try {
                    wrapper.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | PomAnalysisException ex) {
                throw new PomAnalysisException("Failted to get dependencies of modules for " + new File(scmDir, pomPath), ex);
            }
        }
    }

    @Override
    public Optional<MavenProject> readPom(File pomPath) {
        return this.pomReader.analyze(pomPath);
    }

    @Override
    public Optional<MavenProject> readPom(InputStream is) {
        return this.pomReader.analyze(is);
    }

    private boolean isProjectVersionRefSameAsGAV(Path file, GAV gav) {
        PomPeek pk = new PomPeek(file.toFile());
        if (pk.getKey() == null) {
            return false;
        }
        return gav.equals((Object)GalleyWrapper.generateGAV(pk.getKey()));
    }
}

