/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.communication.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.jboss.da.communication.pom.impl.NamespaceFilter;
import org.jboss.da.communication.pom.model.MavenProject;
import org.slf4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

@ApplicationScoped
public class PomReader {
    @Inject
    private Logger log;

    public Optional<MavenProject> analyze(File pomFile) {
        try {
            Source source = this.filterNamespace(new InputSource(new FileInputStream(pomFile)));
            return Optional.of(this.unmarshal(source));
        }
        catch (FileNotFoundException | JAXBException | SAXException e) {
            this.log.warn("Exception parsing the pom.xml: " + pomFile, e);
            return Optional.empty();
        }
    }

    public Optional<MavenProject> analyze(InputStream pom) {
        try {
            Source source = this.filterNamespace(new InputSource(pom));
            return Optional.of(this.unmarshal(source));
        }
        catch (JAXBException | SAXException e) {
            this.log.warn("Exception parsing the pom.xml from stream.", e);
            return Optional.empty();
        }
    }

    private Source filterNamespace(InputSource is) throws SAXException {
        NamespaceFilter nf = new NamespaceFilter("http://maven.apache.org/POM/4.0.0");
        nf.setParent(XMLReaderFactory.createXMLReader());
        return new SAXSource(nf, is);
    }

    private MavenProject unmarshal(Source source) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MavenProject.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (MavenProject)unmarshaller.unmarshal(source);
    }
}

