/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.scm.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import javax.ejb.Schedule;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.da.scm.impl.DirectoryReference;
import org.jboss.da.scm.impl.FutureReference;
import org.jboss.da.scm.impl.SCMSpecifier;
import org.jboss.da.scm.impl.ScmFacade;
import org.slf4j.Logger;

@Singleton
public class SCMCache {
    @Inject
    Logger log;
    @Inject
    ScmFacade scm;
    private final Map<SCMSpecifier, DirectoryReference> cache = new HashMap<SCMSpecifier, DirectoryReference>();
    private final Map<SCMSpecifier, FutureReference> futureCache = new HashMap<SCMSpecifier, FutureReference>();

    public FutureReference get(SCMSpecifier spec) {
        DirectoryReference ref;
        Optional<File> file;
        this.checkFutureCache();
        if (this.cache.containsKey(spec) && (file = (ref = this.cache.get(spec)).get()).isPresent()) {
            return new FutureReference(ref);
        }
        if (this.futureCache.containsKey(spec)) {
            return new FutureReference(this.futureCache.get(spec));
        }
        FutureReference future = new FutureReference();
        this.futureCache.put(spec, future);
        return future;
    }

    private void checkFutureCache() {
        Iterator<Map.Entry<SCMSpecifier, FutureReference>> it = this.futureCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SCMSpecifier, FutureReference> e = it.next();
            FutureReference value = e.getValue();
            if (!value.isDone()) continue;
            try {
                this.cache.put(e.getKey(), value.get(1L, TimeUnit.SECONDS));
                it.remove();
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                this.log.error("Error while geting Future object.", (Throwable)ex);
            }
        }
    }

    @Schedule(hour="*", minute="*/10")
    public void invalidateCache() {
        this.checkFutureCache();
        Iterator<Map.Entry<SCMSpecifier, DirectoryReference>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            DirectoryReference ref = it.next().getValue();
            if (ref.check()) continue;
            it.remove();
        }
    }

    @PreDestroy
    private void cleanup() {
        Iterator<Map.Entry<SCMSpecifier, DirectoryReference>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().delete();
            it.remove();
        }
    }
}

