/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.scm.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.da.scm.impl.DirectoryReference;

class FutureReference {
    final CompletableFuture<DirectoryReference> futureReference;
    private final boolean shouldIComplete;

    public FutureReference() {
        this.futureReference = new CompletableFuture();
        this.shouldIComplete = true;
    }

    public FutureReference(DirectoryReference ref) {
        this.futureReference = CompletableFuture.completedFuture(ref);
        this.shouldIComplete = false;
    }

    public FutureReference(FutureReference fref) {
        this.futureReference = fref.futureReference;
        this.shouldIComplete = false;
    }

    public boolean shouldIComplete() {
        return this.shouldIComplete;
    }

    public boolean isDone() {
        return this.futureReference.isDone();
    }

    public void complete(DirectoryReference ref) {
        if (!this.shouldIComplete) {
            throw new IllegalStateException("Completing when this instance shouldn't complete the future.");
        }
        if (!this.futureReference.complete(ref)) {
            throw new IllegalStateException("Already completed.");
        }
    }

    public void completeExceptionally(Exception ex) {
        if (!this.shouldIComplete) {
            throw new IllegalStateException("Completing when this instance shouldn't complete the future.");
        }
        this.futureReference.completeExceptionally(ex);
    }

    public DirectoryReference get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.futureReference.get(timeout, unit);
    }
}

