/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.scm.impl;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.time.Instant;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.jboss.da.scm.api.SCM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectoryReference {
    Logger log = LoggerFactory.getLogger(DirectoryReference.class);
    private WeakReference<File> reference;
    private final String directoryPath;
    private Instant removeAt;
    private boolean deleted = false;

    public DirectoryReference(File directory) {
        this.directoryPath = directory.getAbsolutePath();
        this.setReference(directory);
    }

    private void setReference(File directory) {
        this.reference = new WeakReference<File>(directory);
        this.removeAt = Instant.MAX;
    }

    public synchronized Optional<File> get() {
        if (this.deleted) {
            return Optional.empty();
        }
        File directory = (File)this.reference.get();
        if (directory == null) {
            directory = new File(this.directoryPath);
            if (directory.canRead() && directory.isDirectory()) {
                this.setReference(directory);
            } else {
                return Optional.empty();
            }
        }
        return Optional.of(directory);
    }

    synchronized boolean check() {
        if (this.deleted) {
            return false;
        }
        if (this.reference.get() != null) {
            return true;
        }
        if (this.removeAt.equals(Instant.MAX)) {
            this.removeAt = Instant.now().plus(SCM.TIME_TO_KEEP);
            return true;
        }
        if (Instant.now().isAfter(this.removeAt)) {
            this.delete();
            return false;
        }
        return true;
    }

    public synchronized void delete() {
        this.deleted = true;
        File directory = new File(this.directoryPath);
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException ex) {
            this.log.warn("Temporary directory could not be deleted", (Throwable)ex);
        }
    }
}

