/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.scm.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.scm.ScmException;
import org.jboss.da.scm.api.SCM;
import org.jboss.da.scm.api.SCMType;
import org.jboss.da.scm.impl.DirectoryReference;
import org.jboss.da.scm.impl.FutureReference;
import org.jboss.da.scm.impl.SCMCache;
import org.jboss.da.scm.impl.SCMSpecifier;
import org.jboss.da.scm.impl.ScmFacade;
import org.slf4j.Logger;

public class SCMImpl
implements SCM {
    @Inject
    Logger log;
    @Inject
    ScmFacade scm;
    @Inject
    SCMCache cache;

    @Override
    public File cloneRepository(SCMType scmType, String scmUrl, String revision) throws ScmException {
        SCMSpecifier spec = new SCMSpecifier(scmType, scmUrl, revision);
        FutureReference fref = this.cache.get(spec);
        if (fref.shouldIComplete()) {
            try {
                File tempDir = Files.createTempDirectory("cloned_repo", new FileAttribute[0]).toFile();
                this.log.info("Cached repository for {} not found. Cloning to {}.", (Object)spec, (Object)tempDir);
                try {
                    this.scm.shallowCloneRepository(scmType, scmUrl, revision, tempDir);
                    DirectoryReference ref = new DirectoryReference(tempDir);
                    fref.complete(ref);
                    return tempDir;
                }
                catch (ScmException ex) {
                    fref.completeExceptionally((Exception)((Object)ex));
                    try {
                        FileUtils.deleteDirectory((File)tempDir);
                    }
                    catch (IOException ioex) {
                        this.log.warn("Temporary directory could not be deleted", (Throwable)ioex);
                    }
                    throw ex;
                }
            }
            catch (IOException ex) {
                throw new ScmException("Could not create temp directory for cloning the repository", (Throwable)ex);
            }
        }
        try {
            File dir = fref.get(30L, TimeUnit.MINUTES).get().orElseThrow(() -> new IllegalStateException("Now completed reference has empty file."));
            this.log.info("Cached repository for {} found in {}.", (Object)spec, (Object)dir);
            return dir;
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new ScmException("Could not obtain cloned repository.", (Throwable)ex);
        }
    }
}

