/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.da.scm.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.git.jgit.JGitScmProvider;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.jboss.da.scm.api.SCMType;
import org.slf4j.Logger;

@ApplicationScoped
public class ScmFacade {
    @Inject
    private Logger logger;
    private final ScmManager scmManager = new BasicScmManager();

    public ScmFacade() {
        this.scmManager.setScmProvider(SCMType.GIT.toString(), (ScmProvider)new JGitScmProvider());
        this.scmManager.setScmProvider(SCMType.SVN.toString(), (ScmProvider)new SvnExeScmProvider());
    }

    public void shallowCloneRepository(SCMType scmType, String scmUrl, String revision, File cloneTo) throws ScmException {
        if (!cloneTo.exists()) {
            cloneTo.mkdir();
        }
        if (this.shallowClone(scmType, scmUrl, revision, cloneTo)) {
            return;
        }
        this.cloneRepository(scmType, scmUrl, revision, cloneTo);
    }

    public void cloneRepository(SCMType scmType, String scmUrl, String revision, File cloneTo) throws ScmException {
        ScmRepository repo = this.getScmRepository(scmType.getSCMUrl(scmUrl), this.scmManager);
        CheckOutScmResult checkOut = this.scmManager.checkOut(repo, new ScmFileSet(cloneTo), (ScmVersion)new ScmTag(revision));
        if (!checkOut.isSuccess()) {
            throw new ScmException("Repository was not clonned: " + checkOut.getProviderMessage());
        }
    }

    public void commitAndPush(SCMType scmType, String scmUrl, File baseDir, List<File> files, String commitMessage) throws ScmException {
        ScmFileSet scmFileSet;
        ScmRepository repo = this.getScmRepository(scmType.getSCMUrl(scmUrl), this.scmManager);
        AddScmResult addResult = this.scmManager.add(repo, scmFileSet = new ScmFileSet(baseDir, files));
        if (!addResult.isSuccess()) {
            throw new ScmException("The manager wasn't able to ADD these files " + scmFileSet.toString() + " to the repository " + repo);
        }
        CheckInScmResult pushResult = this.scmManager.checkIn(repo, scmFileSet, commitMessage);
        if (!pushResult.isSuccess()) {
            throw new ScmException("The manager wasn't able to PUSH these files " + scmFileSet.toString() + " to the repository " + repo);
        }
    }

    private ScmRepository getScmRepository(String scmUrl, ScmManager scmManager) throws ScmException {
        try {
            return scmManager.makeScmRepository(scmUrl);
        }
        catch (NoSuchScmProviderException ex) {
            throw new ScmException("Could not find a provider.", (Throwable)ex);
        }
        catch (ScmRepositoryException ex) {
            throw new ScmException("Error while connecting to the repository", (Throwable)ex);
        }
    }

    private boolean shallowClone(SCMType scmType, String scmUrl, String revision, File cloneTo) {
        if (!scmType.equals((Object)SCMType.GIT)) {
            return false;
        }
        try {
            ProcessBuilder pb = revision == null || revision.isEmpty() ? new ProcessBuilder("git", "clone", "--depth", "1", scmUrl, ".") : new ProcessBuilder("git", "clone", "--depth", "1", "--branch", revision, scmUrl, ".");
            pb.directory(cloneTo);
            Map<String, String> env = pb.environment();
            env.put("GIT_ASKPASS", "/bin/echo");
            env.put("GIT_TERMINAL_PROMPT", "0");
            Process p = pb.start();
            int status = p.waitFor();
            return status == 0;
        }
        catch (IOException | InterruptedException ex) {
            this.logger.error("Could not shallow clone", (Throwable)ex);
            return false;
        }
    }
}

