/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.jcr.AbstractJcrRepositoryTest;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.maven.ArtifactType;
import org.jboss.dna.maven.MavenClassLoaders;
import org.jboss.dna.maven.MavenDependency;
import org.jboss.dna.maven.MavenId;
import org.jboss.dna.maven.MavenRepository;
import org.jboss.dna.maven.SignatureType;
import org.jboss.dna.maven.spi.JcrMavenUrlProvider;
import org.jboss.dna.maven.spi.MavenUrlProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MavenRepositoryTest
extends AbstractJcrRepositoryTest {
    public static final String MAVEN_PATH = "/maven";
    public static final String PATH_TO_TEST_POM_A = "testPomA.xml";
    public static final String PATH_TO_EMPTY_JAR = "empty.jar";
    private Properties urlProviderProperties;
    private JcrMavenUrlProvider urlProvider;
    private MavenRepository maven;
    private MavenId mavenId1;
    private MavenId mavenId2;
    private ClassLoader parentLoader;
    private MavenId projectA;
    private MavenId projectB;
    private MavenId projectC;
    private MavenId projectD;
    private MavenId projectE;
    private MavenId projectF;
    private MavenId projectG;
    private MavenId projectH;
    private MavenId projectI;

    @Before
    public void beforeEach() throws Exception {
        this.urlProviderProperties = new Properties();
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.repository.workspace", "default");
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.repository.path", "/path/to/repository/root");
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.username", "jsmith");
        this.urlProviderProperties.setProperty("dna.maven.urlprovider.password", "secret");
        this.urlProvider = new JcrMavenUrlProvider();
        this.urlProvider.setRepository(this.getRepository());
        this.maven = new MavenRepository((MavenUrlProvider)this.urlProvider);
        this.mavenId1 = new MavenId("org.jboss.dna", "dna-maven", "1.0-SNAPSHOT");
        this.mavenId2 = new MavenId("org.jboss.dna", "dna-common", "1.0.2");
        this.parentLoader = null;
        this.projectA = new MavenId("org.jboss.example:ProjectA:1.0");
        this.projectB = new MavenId("org.jboss.example:ProjectB:1.0");
        this.projectC = new MavenId("org.jboss.example:ProjectC:1.0");
        this.projectD = new MavenId("org.jboss.example:ProjectD:1.0");
        this.projectE = new MavenId("org.jboss.example:ProjectE:1.0");
        this.projectF = new MavenId("org.jboss.example:ProjectF:1.0");
        this.projectG = new MavenId("org.jboss.example:ProjectG:1.0");
        this.projectH = new MavenId("org.jboss.example:ProjectH:1.0");
        this.projectI = new MavenId("org.jboss.example:ProjectI:1.0");
    }

    public void startRepository() throws RepositoryException, IOException {
        super.startRepository();
        this.urlProvider.configure(this.urlProviderProperties);
    }

    public void loadTestLibraries() throws Exception {
        this.loadTestLibrary("org.jboss.example:ProjectA:1.0", "test/dependency/case1/testProjectA.xml");
        this.loadTestLibrary("org.jboss.example:ProjectB:1.0", "test/dependency/case1/testProjectB.xml");
        this.loadTestLibrary("org.jboss.example:ProjectC:1.0", "test/dependency/case1/testProjectC.xml");
        this.loadTestLibrary("org.jboss.example:ProjectD:1.0", "test/dependency/case1/testProjectD.xml");
        this.loadTestLibrary("org.jboss.example:ProjectE:1.0", "test/dependency/case1/testProjectE.xml");
        this.loadTestLibrary("org.jboss.example:ProjectF:1.0", "test/dependency/case1/testProjectF.xml");
        this.loadTestLibrary("org.jboss.example:ProjectG:1.0", "test/dependency/case1/testProjectG.xml");
        this.loadTestLibrary("org.jboss.example:ProjectH:1.0", "test/dependency/case1/testProjectH.xml");
        this.loadTestLibrary("org.jboss.example:ProjectI:1.0", "test/dependency/case1/testProjectI.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRepositoryContent(MavenId mavenId, ArtifactType artifactType, SignatureType signatureType, InputStream content) throws Exception {
        URL url = this.urlProvider.getUrl(mavenId, artifactType, signatureType, true);
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        URLConnection connection = url.openConnection();
        OutputStream outputStream = connection.getOutputStream();
        try {
            IoUtil.write((InputStream)content, (OutputStream)outputStream);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            finally {
                content.close();
            }
        }
    }

    protected void loadTestLibrary(String mavenId, String pathToPomFile) throws Exception {
        MavenId id = new MavenId(mavenId);
        this.setRepositoryContent(id, ArtifactType.POM, null, ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(pathToPomFile));
        this.setRepositoryContent(id, ArtifactType.JAR, null, ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PATH_TO_EMPTY_JAR));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowZeroIdsWhenGettingClassLoader() {
        this.maven.getClassLoader(this.parentLoader, (MavenId[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullIdsWhenGettingClassLoader() {
        this.maven.getClassLoader(this.parentLoader, new MavenId[]{this.mavenId1, null, this.mavenId2});
    }

    @Test
    public void shouldConsiderNullIdToNotExist() {
        Assert.assertThat((Object)this.maven.exists((MavenId)null), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnEmptySetWhenPassedAllNullIdsForCheckingWhetherProjectsExist() {
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}).size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.maven.exists(null, new MavenId[]{null}).size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdAndArtifactTypeAndSignatureType() throws Exception {
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.MD5).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.PGP).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.JAR, SignatureType.SHA1).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.jar.sha1"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, null).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.MD5).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.PGP).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.SOURCE, SignatureType.SHA1).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT-sources.jar.sha1"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, null).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.MD5).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.PGP).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.POM, SignatureType.SHA1).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/dna-maven-1.0-SNAPSHOT.pom.sha1"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, null).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/maven-metadata.xml"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.MD5).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/maven-metadata.xml.md5"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.PGP).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/maven-metadata.xml.asc"));
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, ArtifactType.METADATA, SignatureType.SHA1).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/maven-metadata.xml.sha1"));
    }

    @Test
    public void shouldReturnValidUrlForMavenIdWithNoArtifactType() throws Exception {
        Assert.assertThat((Object)this.maven.getUrl(this.mavenId1, null, null).toString(), (Matcher)Is.is((Object)"jcr:/default/org/jboss/dna/dna-maven/1.0-SNAPSHOT/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnUrlThatCanBeReadFromAndWrittenTo() throws Exception {
        this.startRepository();
        String content = "";
        this.setRepositoryContent(this.mavenId1, ArtifactType.JAR, null, new ByteArrayInputStream(content.getBytes()));
        URL url = this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null);
        InputStream stream = url.openConnection().getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, (Matcher)Is.is((Object)content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        content = "";
        for (int i = 0; i != 100; ++i) {
            content = content + "The old gray mare just ain't what she used to be. Ain't what she used to be. Ain't what she used to be. ";
        }
        this.setRepositoryContent(this.mavenId1, ArtifactType.JAR, null, new ByteArrayInputStream(content.getBytes()));
        url = this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null);
        stream = url.openConnection().getInputStream();
        try {
            String readContent = StringUtil.read((InputStream)stream);
            Assert.assertThat((Object)readContent, (Matcher)Is.is((Object)content));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        String updatedContent = "Updated! " + content;
        OutputStream ostream = url.openConnection().getOutputStream();
        try {
            StringUtil.write((String)updatedContent, (OutputStream)ostream);
        }
        finally {
            if (ostream != null) {
                ostream.close();
            }
        }
        url = this.maven.getUrl(this.mavenId1, ArtifactType.JAR, null);
        stream = url.openConnection().getInputStream();
        String actualContent = null;
        try {
            actualContent = StringUtil.read((InputStream)stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        Assert.assertThat((Object)actualContent, (Matcher)Is.is((Object)updatedContent));
    }

    @Test
    public void shouldGetAllDependenciesFromInputStreamToPomFile() throws Exception {
        MavenId id = new MavenId("org.jboss.dna:dna-maven:0.1-SNAPSHOT");
        MavenDependency.Scope[] scopes = MavenDependency.Scope.values();
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PATH_TO_TEST_POM_A);
        List dependencies = this.maven.getDependencies(id, stream, scopes);
        Assert.assertThat((Object)dependencies, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)dependencies.size(), (Matcher)Is.is((Object)11));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).toString(), (Matcher)Is.is((Object)"org.jboss.dna:common:0.1-SNAPSHOT:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.getDefault()));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).toString(), (Matcher)Is.is((Object)"junit:junit:4.4:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).toString(), (Matcher)Is.is((Object)"org.jmock:jmock:2.4.0:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(3)).toString(), (Matcher)Is.is((Object)"org.jmock:jmock-junit4:2.4.0:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(3)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(3)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(4)).toString(), (Matcher)Is.is((Object)"org.slf4j:slf4j-api:1.4.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(4)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(4)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(5)).toString(), (Matcher)Is.is((Object)"org.slf4j:slf4j-log4j12:1.4.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(5)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(5)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(6)).toString(), (Matcher)Is.is((Object)"log4j:log4j:1.2.14:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(6)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(6)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(7)).toString(), (Matcher)Is.is((Object)"javax.jcr:jcr:1.0.1:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(7)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(7)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).toString(), (Matcher)Is.is((Object)"org.apache.jackrabbit:jackrabbit-api:1.3.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getExclusions().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getExclusions().contains(new MavenId("xml-apis:xml-apis")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(8)).getExclusions().contains(new MavenId("xerces:xercesImpl")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).toString(), (Matcher)Is.is((Object)"org.apache.jackrabbit:jackrabbit-core:1.3.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getExclusions().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getExclusions().contains(new MavenId("xml-apis:xml-apis")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(9)).getExclusions().contains(new MavenId("xerces:xercesImpl")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(10)).toString(), (Matcher)Is.is((Object)"org.apache.derby:derby:10.2.1.6:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(10)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.TEST));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(10)).getExclusions().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldGetCompileAndRuntimeDependenciesFromInputStreamToPomFile() throws Exception {
        MavenId id = new MavenId("org.jboss.dna:dna-maven:0.1-SNAPSHOT");
        MavenDependency.Scope[] scopes = new MavenDependency.Scope[]{MavenDependency.Scope.COMPILE, MavenDependency.Scope.RUNTIME};
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PATH_TO_TEST_POM_A);
        List dependencies = this.maven.getDependencies(id, stream, scopes);
        Assert.assertThat((Object)dependencies, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)dependencies.size(), (Matcher)Is.is((Object)3));
        stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PATH_TO_TEST_POM_A);
        dependencies = this.maven.getDependencies(id, stream, new MavenDependency.Scope[0]);
        Assert.assertThat((Object)dependencies, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)dependencies.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).toString(), (Matcher)Is.is((Object)"org.jboss.dna:common:0.1-SNAPSHOT:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.getDefault()));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(0)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).toString(), (Matcher)Is.is((Object)"org.slf4j:slf4j-api:1.4.3:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(1)).getExclusions().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).toString(), (Matcher)Is.is((Object)"javax.jcr:jcr:1.0.1:"));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getScope(), (Matcher)Is.is((Object)MavenDependency.Scope.COMPILE));
        Assert.assertThat((Object)((MavenDependency)dependencies.get(2)).getExclusions().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldBuildCorrectClasspathForOneProjectWithNoDependencies() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.checkClasspath(new MavenId[]{this.projectA}, new MavenId[]{this.projectA});
    }

    @Test
    public void shouldBuildCorrectClasspathForMultipleProjectsWithNoDependencies() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.checkClasspath(new MavenId[]{this.projectA, this.projectB, this.projectC}, new MavenId[]{this.projectA, this.projectB, this.projectC});
    }

    @Test
    public void shouldBuildCorrectClasspathForProjectsWithVariousDependencies() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.checkClasspath(new MavenId[]{this.projectA}, new MavenId[]{this.projectA});
        this.checkClasspath(new MavenId[]{this.projectB}, new MavenId[]{this.projectB});
        this.checkClasspath(new MavenId[]{this.projectC}, new MavenId[]{this.projectC});
        this.checkClasspath(new MavenId[]{this.projectD}, new MavenId[]{this.projectD, this.projectA, this.projectB});
        this.checkClasspath(new MavenId[]{this.projectE}, new MavenId[]{this.projectE, this.projectD, this.projectA, this.projectB});
        this.checkClasspath(new MavenId[]{this.projectF}, new MavenId[]{this.projectF, this.projectE, this.projectC, this.projectD, this.projectA, this.projectB});
        this.checkClasspath(new MavenId[]{this.projectG}, new MavenId[]{this.projectG, this.projectC, this.projectE, this.projectD, this.projectA});
        this.checkClasspath(new MavenId[]{this.projectH}, new MavenId[]{this.projectH, this.projectG, this.projectB, this.projectC, this.projectE, this.projectD, this.projectA});
        this.checkClasspath(new MavenId[]{this.projectI}, new MavenId[]{this.projectI, this.projectH, this.projectF, this.projectG, this.projectB, this.projectC, this.projectE, this.projectD, this.projectA});
    }

    @Test
    public void shouldAdjustClasspathForProjectWhoseDependenciesAreChanged() throws Exception {
        this.startRepository();
        this.loadTestLibraries();
        this.loadTestLibrary("org.jboss.example:ProjectG:1.0", "test/dependency/case1/testProjectG.xml");
        this.checkClasspath(new MavenId[]{this.projectG}, new MavenId[]{this.projectG, this.projectC, this.projectE, this.projectD, this.projectA});
        this.loadTestLibrary("org.jboss.example:ProjectG:1.0", "test/dependency/case1/testProjectG-withNoExclusions.xml");
        this.maven.notifyUpdatedPom(this.projectG);
        this.checkClasspath(new MavenId[]{this.projectG}, new MavenId[]{this.projectG, this.projectC, this.projectE, this.projectD, this.projectA, this.projectB});
    }

    protected void checkClasspath(MavenId[] projectIds, MavenId[] classpathProjects) {
        ArrayList<MavenId> idsExpectedOnClasspath = new ArrayList<MavenId>();
        for (int i = 0; i != classpathProjects.length; ++i) {
            idsExpectedOnClasspath.add(classpathProjects[i]);
        }
        MavenClassLoaders.ProjectClassLoader loader = (MavenClassLoaders.ProjectClassLoader)this.maven.getClassLoader(null, projectIds);
        Assert.assertThat((Object)loader, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        ArrayList debugSearchPath = new ArrayList();
        URL result = loader.findResource("non/existant/resource/name", debugSearchPath);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(debugSearchPath, (Matcher)Is.is(idsExpectedOnClasspath));
        for (int i = 0; i != 1000; ++i) {
            loader.findResource("non/existant/resource/name/" + i);
        }
    }
}

