/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven;

import javax.jcr.Node;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.maven.AbstractJcrRepositoryTest;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractJcrRepositoryTest
extends AbstractJcrRepositoryTest {
    @Test
    public void shouldBeAbleToStartAndShutdownRepository() throws Exception {
        for (int i = 0; i != 3; ++i) {
            this.startRepository();
            Session session = this.getRepository().login(this.getTestCredentials());
            Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)session.getRootNode(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Node node = session.getRootNode().addNode("testnode", "nt:unstructured");
            Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"testnode"));
            Assert.assertThat((Object)node.getPath(), (Matcher)Is.is((Object)"/testnode"));
            session.save();
            session.logout();
            this.shutdownRepository();
        }
    }

    @Test
    public void shouldAllowDataPersistedInOneSessionBeAccessibleInOtherSessions() throws Exception {
        this.startRepository();
        Session session = this.getRepository().login(this.getTestCredentials());
        Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)session.getRootNode(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node node = session.getRootNode().addNode("testnode", "nt:unstructured");
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"testnode"));
        Assert.assertThat((Object)node.getPath(), (Matcher)Is.is((Object)"/testnode"));
        session.save();
        session.logout();
        for (int i = 0; i != 3; ++i) {
            session = this.getRepository().login(this.getTestCredentials());
            Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)session.getRootNode(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            node = session.getRootNode().getNode("testnode");
            Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"testnode"));
            Assert.assertThat((Object)node.getPath(), (Matcher)Is.is((Object)"/testnode"));
            session.logout();
        }
    }
}

