/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.provider;

import java.util.Properties;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.provider.DataSourceDatabaseMetadataProvider;
import org.jboss.dna.common.jdbc.provider.DefaultDataSourceDatabaseMetadataProvider;

public class DataSourceDatabaseMetadataProviderTest
extends TestCase {
    private static final String PROVIDER_NAME = "TestProvider";
    private static final String DATA_SOURCE_NAME = "java:comp/env/jdbc/TestDataSource";
    private static final String INITIAL_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
    private static final String PROVIDER_URL = "jnp://localhost:1099/";
    private static final String EMPTY_STRING_NOTATION = "<EMPTY>";
    private static final String NULL_STRING_NOTATION = "<NULL>";
    private DataSourceDatabaseMetadataProvider dataSourceProvider;

    protected void setUp() throws Exception {
        super.setUp();
        this.dataSourceProvider = new DefaultDataSourceDatabaseMetadataProvider();
    }

    protected void tearDown() throws Exception {
        this.dataSourceProvider = null;
        super.tearDown();
    }

    public void testGetDataSource() throws Exception {
        this.dataSourceProvider.setName(PROVIDER_NAME);
        this.dataSourceProvider.setDataSourceName(DATA_SOURCE_NAME);
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        properties.put("java.naming.provider.url", PROVIDER_URL);
        this.dataSourceProvider.setProperties(properties);
        try {
            this.dataSourceProvider.getDataSource();
            DataSourceDatabaseMetadataProviderTest.fail((String)"DataSource provider should raise an exception when app server is not running");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSetDataSourceName() {
        this.dataSourceProvider.setDataSourceName(DATA_SOURCE_NAME);
        DataSourceDatabaseMetadataProviderTest.assertEquals((String)"Unable to set the data source name", (String)DATA_SOURCE_NAME, (String)this.dataSourceProvider.getDataSourceName());
    }

    public void testRelease() {
        this.dataSourceProvider.release(true);
    }

    public void testGetDatabaseMetaData() {
        this.dataSourceProvider.setName(PROVIDER_NAME);
        this.dataSourceProvider.setDataSourceName(DATA_SOURCE_NAME);
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        properties.put("java.naming.provider.url", PROVIDER_URL);
        this.dataSourceProvider.setProperties(properties);
        try {
            this.dataSourceProvider.getDatabaseMetaData();
            DataSourceDatabaseMetadataProviderTest.fail((String)"DataSource provider should raise an exception when app server is not running");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetConnection() throws Exception {
        this.dataSourceProvider.setName(PROVIDER_NAME);
        this.dataSourceProvider.setDataSourceName(DATA_SOURCE_NAME);
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        properties.put("java.naming.provider.url", PROVIDER_URL);
        this.dataSourceProvider.setProperties(properties);
        try {
            this.dataSourceProvider.getConnection();
            DataSourceDatabaseMetadataProviderTest.fail((String)"DataSource provider should raise an exception when app server is not running");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSetName() {
        this.dataSourceProvider.setName(PROVIDER_NAME);
        DataSourceDatabaseMetadataProviderTest.assertEquals((String)"Unable to set the data source provider name", (String)PROVIDER_NAME, (String)this.dataSourceProvider.getName());
    }

    public void testSetProperties() {
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        properties.put("java.naming.provider.url", PROVIDER_URL);
        this.dataSourceProvider.setProperties(properties);
        DataSourceDatabaseMetadataProviderTest.assertSame((String)"Unable to set the data source provider properties", (Object)properties, (Object)this.dataSourceProvider.getProperties());
    }

    public void testSetEmptyStringNotation() {
        this.dataSourceProvider.setEmptyStringNotation(EMPTY_STRING_NOTATION);
        DataSourceDatabaseMetadataProviderTest.assertSame((String)"Unable to set the empty string notation", (Object)EMPTY_STRING_NOTATION, (Object)this.dataSourceProvider.getEmptyStringNotation());
    }

    public void testSetNullStringNotation() {
        this.dataSourceProvider.setNullStringNotation(NULL_STRING_NOTATION);
        DataSourceDatabaseMetadataProviderTest.assertSame((String)"Unable to set the NULL string notation", (Object)NULL_STRING_NOTATION, (Object)this.dataSourceProvider.getNullStringNotation());
    }
}

