/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.dna.common.jdbc.model.api.Catalog;
import org.jboss.dna.common.jdbc.model.api.Database;
import org.jboss.dna.common.jdbc.model.api.DatabaseMetaDataMethodException;
import org.jboss.dna.common.jdbc.model.api.ResultSetConcurrencyType;
import org.jboss.dna.common.jdbc.model.api.ResultSetHoldabilityType;
import org.jboss.dna.common.jdbc.model.api.ResultSetType;
import org.jboss.dna.common.jdbc.model.api.SQLStateType;
import org.jboss.dna.common.jdbc.model.api.Schema;
import org.jboss.dna.common.jdbc.model.api.SqlTypeConversionPair;
import org.jboss.dna.common.jdbc.model.api.SqlTypeInfo;
import org.jboss.dna.common.jdbc.model.api.StoredProcedure;
import org.jboss.dna.common.jdbc.model.api.Table;
import org.jboss.dna.common.jdbc.model.api.TableType;
import org.jboss.dna.common.jdbc.model.api.TransactionIsolationLevelType;
import org.jboss.dna.common.jdbc.model.api.UserDefinedType;
import org.jboss.dna.common.jdbc.model.spi.CoreMetaDataBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseBean
extends CoreMetaDataBean
implements Database {
    private static final long serialVersionUID = 6634428066138252064L;
    private List<DatabaseMetaDataMethodException> exceptionList = new ArrayList<DatabaseMetaDataMethodException>();
    private String name;
    private Boolean allProceduresAreCallable;
    private Boolean allTablesAreSelectable;
    private String url;
    private String userName;
    private Boolean readOnly;
    private Boolean nullsAreSortedHigh;
    private Boolean nullsAreSortedLow;
    private Boolean nullsAreSortedAtStart;
    private Boolean nullsAreSortedAtEnd;
    private String databaseProductName;
    private String databaseProductVersion;
    private String driverName;
    private String driverVersion;
    private Integer driverMajorVersion;
    private Integer driverMinorVersion;
    private Boolean usesLocalFiles;
    private Boolean usesLocalFilePerTable;
    private Boolean supportsMixedCaseIdentifiers;
    private Boolean storesUpperCaseIdentifiers;
    private Boolean storesLowerCaseIdentifiers;
    private Boolean storesMixedCaseIdentifiers;
    private Boolean supportsMixedCaseQuotedIdentifiers;
    private Boolean storesUpperCaseQuotedIdentifiers;
    private Boolean storesLowerCaseQuotedIdentifiers;
    private Boolean storesMixedCaseQuotedIdentifiers;
    private String identifierQuoteString;
    private Set<String> sqlKeywords = new HashSet<String>();
    private Set<String> numericFunctions = new HashSet<String>();
    private Set<String> stringFunctions = new HashSet<String>();
    private Set<String> systemFunctions = new HashSet<String>();
    private Set<String> timeDateFunctions = new HashSet<String>();
    private String searchStringEscape;
    private String extraNameCharacters;
    private Boolean supportsAlterTableWithAddColumn;
    private Boolean supportsAlterTableWithDropColumn;
    private Boolean supportsColumnAliasing;
    private Boolean nullPlusNonNullIsNull;
    private Boolean supportsConvert;
    private Boolean supportsTableCorrelationNames;
    private Boolean supportsDifferentTableCorrelationNames;
    private Boolean supportsExpressionsInOrderBy;
    private Boolean supportsOrderByUnrelated;
    private Boolean supportsGroupBy;
    private Boolean supportsGroupByUnrelated;
    private Boolean supportsGroupByBeyondSelect;
    private Boolean supportsLikeEscapeClause;
    private Boolean supportsMultipleResultSets;
    private Boolean supportsMultipleTransactions;
    private Boolean supportsNonNullableColumns;
    private Boolean supportsMinimumSQLGrammar;
    private Boolean supportsCoreSQLGrammar;
    private Boolean supportsExtendedSQLGrammar;
    private Boolean supportsANSI92EntryLevelSQL;
    private Boolean supportsANSI92IntermediateSQL;
    private Boolean supportsANSI92FullSQL;
    private Boolean supportsIntegrityEnhancementFacility;
    private Boolean supportsOuterJoins;
    private Boolean supportsFullOuterJoins;
    private Boolean supportsLimitedOuterJoins;
    private String schemaTerm;
    private String procedureTerm;
    private String catalogTerm;
    private Boolean catalogAtStart;
    private String catalogSeparator;
    private Boolean supportsSchemasInDataManipulation;
    private Boolean supportsSchemasInProcedureCalls;
    private Boolean supportsSchemasInTableDefinitions;
    private Boolean supportsSchemasInIndexDefinitions;
    private Boolean supportsSchemasInPrivilegeDefinitions;
    private Boolean supportsCatalogsInDataManipulation;
    private Boolean supportsCatalogsInProcedureCalls;
    private Boolean supportsCatalogsInTableDefinitions;
    private Boolean supportsCatalogsInIndexDefinitions;
    private Boolean supportsCatalogsInPrivilegeDefinitions;
    private Boolean supportsPositionedDelete;
    private Boolean supportsPositionedUpdate;
    private Boolean supportsSelectForUpdate;
    private Boolean supportsStoredProcedures;
    private Boolean supportsSubqueriesInComparisons;
    private Boolean supportsSubqueriesInExists;
    private Boolean supportsSubqueriesInIns;
    private Boolean supportsSubqueriesInQuantifieds;
    private Boolean supportsCorrelatedSubqueries;
    private Boolean supportsUnion;
    private Boolean supportsUnionAll;
    private Boolean supportsOpenCursorsAcrossCommit;
    private Boolean supportsOpenCursorsAcrossRollback;
    private Boolean supportsOpenStatementsAcrossCommit;
    private Boolean supportsOpenStatementsAcrossRollback;
    private Integer maxBinaryLiteralLength;
    private Integer maxCharLiteralLength;
    private Integer maxColumnNameLength;
    private Integer maxColumnsInGroupBy;
    private Integer maxColumnsInIndex;
    private Integer maxColumnsInOrderBy;
    private Integer maxColumnsInSelect;
    private Integer maxColumnsInTable;
    private Integer maxConnections;
    private Integer maxCursorNameLength;
    private Integer maxIndexLength;
    private Integer maxSchemaNameLength;
    private Integer maxProcedureNameLength;
    private Integer maxCatalogNameLength;
    private Integer maxRowSize;
    private Boolean maxRowSizeIncludeBlobs;
    private Integer maxStatementLength;
    private Integer maxStatements;
    private Integer maxTableNameLength;
    private Integer maxTablesInSelect;
    private Integer maxUserNameLength;
    private Integer defaultTransactionIsolation;
    private Boolean supportsTransactions;
    private Set<TransactionIsolationLevelType> supportedTransactionIsolationLevels = new HashSet<TransactionIsolationLevelType>();
    private Boolean supportsDataDefinitionAndDataManipulationTransactions;
    private Boolean supportsDataManipulationTransactionsOnly;
    private Boolean dataDefinitionCausesTransactionCommit;
    private Boolean dataDefinitionIgnoredInTransactions;
    private Set<StoredProcedure> storedProcedures = new HashSet<StoredProcedure>();
    private Set<Table> tables = new HashSet<Table>();
    private Set<Schema> schemas = new HashSet<Schema>();
    private Set<Catalog> catalogs = new HashSet<Catalog>();
    private Set<TableType> tableTypes = new HashSet<TableType>();
    private Set<SqlTypeInfo> sqlTypeInfos = new HashSet<SqlTypeInfo>();
    private Set<ResultSetType> supportedResultSetTypes = new HashSet<ResultSetType>();
    private Set<UserDefinedType> userDefinedTypes = new HashSet<UserDefinedType>();
    private Set<SqlTypeConversionPair> supportedConversions = new HashSet<SqlTypeConversionPair>();
    private Set<ResultSetConcurrencyType> supportedForwardOnlyResultSetConcurrencies = new HashSet<ResultSetConcurrencyType>();
    private Set<ResultSetConcurrencyType> supportedScrollInsensitiveResultSetConcurrencies = new HashSet<ResultSetConcurrencyType>();
    private Set<ResultSetConcurrencyType> supportedScrollSensitiveResultSetConcurrencies = new HashSet<ResultSetConcurrencyType>();
    private Boolean forwardOnlyResultSetOwnUpdatesAreVisible;
    private Boolean scrollInsensitiveResultSetOwnUpdatesAreVisible;
    private Boolean scrollSensitiveResultSetOwnUpdatesAreVisible;
    private Boolean forwardOnlyResultSetOwnDeletesAreVisible;
    private Boolean scrollInsensitiveResultSetOwnDeletesAreVisible;
    private Boolean scrollSensitiveResultSetOwnDeletesAreVisible;
    private Boolean forwardOnlyResultSetOwnInsertsAreVisible;
    private Boolean scrollInsensitiveResultSetOwnInsertsAreVisible;
    private Boolean scrollSensitiveResultSetOwnInsertsAreVisible;
    private Boolean forwardOnlyResultSetOthersUpdatesAreVisible;
    private Boolean scrollInsensitiveResultSetOthersUpdatesAreVisible;
    private Boolean scrollSensitiveResultSetOthersUpdatesAreVisible;
    private Boolean forwardOnlyResultSetOthersDeletesAreVisible;
    private Boolean scrollInsensitiveResultSetOthersDeletesAreVisible;
    private Boolean scrollSensitiveResultSetOthersDeletesAreVisible;
    private Boolean forwardOnlyResultSetOthersInsertsAreVisible;
    private Boolean scrollInsensitiveResultSetOthersInsertsAreVisible;
    private Boolean scrollSensitiveResultSetOthersInsertsAreVisible;
    private Boolean forwardOnlyResultSetUpdatesAreDetected;
    private Boolean scrollInsensitiveResultSetUpdatesAreDetected;
    private Boolean scrollSensitiveResultSetUpdatesAreDetected;
    private Boolean forwardOnlyResultSetDeletesAreDetected;
    private Boolean scrollInsensitiveResultSetDeletesAreDetected;
    private Boolean scrollSensitiveResultSetDeletesAreDetected;
    private Boolean forwardOnlyResultInsertsAreDetected;
    private Boolean scrollInsensitiveResultInsertsAreDetected;
    private Boolean scrollSensitiveResultInsertsAreDetected;
    private Boolean supportsBatchUpdates;
    private Boolean supportsSavepoints;
    private Boolean supportsNamedParameters;
    private Boolean supportsMultipleOpenResults;
    private Boolean supportsGetGeneratedKeys;
    private Boolean supportsResultSetHoldCurrorsOverCommitHoldability;
    private Boolean supportsResultSetCloseCurrorsAtCommitHoldability;
    private ResultSetHoldabilityType resultSetHoldabilityType;
    private Integer databaseMajorVersion;
    private Integer databaseMinorVersion;
    private Integer jdbcMajorVersion;
    private Integer jdbcMinorVersion;
    private SQLStateType sqlStateType;
    private Boolean locatorsUpdateCopy;
    private Boolean supportsStatementPooling;

    @Override
    public List<DatabaseMetaDataMethodException> getExceptionList() {
        return this.exceptionList;
    }

    @Override
    public void addException(DatabaseMetaDataMethodException exception) {
        this.exceptionList.add(exception);
    }

    @Override
    public DatabaseMetaDataMethodException findException(String methodName) {
        for (DatabaseMetaDataMethodException exception : this.exceptionList) {
            if (!exception.getMethodName().equals(methodName)) continue;
            return exception;
        }
        return null;
    }

    @Override
    public boolean isDatabaseMetaDataMethodFailed(String methodName) {
        return this.findException(methodName) != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Boolean isAllProceduresAreCallable() {
        return this.allProceduresAreCallable;
    }

    @Override
    public void setAllProceduresAreCallable(Boolean allProceduresAreCallable) {
        this.allProceduresAreCallable = allProceduresAreCallable;
    }

    @Override
    public Boolean isAllTablesAreSelectable() {
        return this.allTablesAreSelectable;
    }

    @Override
    public void setAllTablesAreSelectable(Boolean allTablesAreSelectable) {
        this.allTablesAreSelectable = allTablesAreSelectable;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Boolean isNullsAreSortedHigh() {
        return this.nullsAreSortedHigh;
    }

    @Override
    public void setNullsAreSortedHigh(Boolean nullsAreSortedHigh) {
        this.nullsAreSortedHigh = nullsAreSortedHigh;
    }

    @Override
    public Boolean isNullsAreSortedLow() {
        return this.nullsAreSortedLow;
    }

    @Override
    public void setNullsAreSortedLow(Boolean nullsAreSortedLow) {
        this.nullsAreSortedLow = nullsAreSortedLow;
    }

    @Override
    public Boolean isNullsAreSortedAtStart() {
        return this.nullsAreSortedAtStart;
    }

    @Override
    public void setNullsAreSortedAtStart(Boolean nullsAreSortedAtStart) {
        this.nullsAreSortedAtStart = nullsAreSortedAtStart;
    }

    @Override
    public Boolean isNullsAreSortedAtEnd() {
        return this.nullsAreSortedAtEnd;
    }

    @Override
    public void setNullsAreSortedAtEnd(Boolean nullsAreSortedAtEnd) {
        this.nullsAreSortedAtEnd = nullsAreSortedAtEnd;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    @Override
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    @Override
    public Integer getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public void setDriverMajorVersion(Integer driverMajorVersion) {
        this.driverMajorVersion = driverMajorVersion;
    }

    @Override
    public Integer getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public void setDriverMinorVersion(Integer driverMinorVersion) {
        this.driverMinorVersion = driverMinorVersion;
    }

    @Override
    public Boolean isUsesLocalFiles() {
        return this.usesLocalFiles;
    }

    @Override
    public void setUsesLocalFiles(Boolean usesLocalFiles) {
        this.usesLocalFiles = usesLocalFiles;
    }

    @Override
    public Boolean isUsesLocalFilePerTable() {
        return this.usesLocalFilePerTable;
    }

    @Override
    public void setUsesLocalFilePerTable(Boolean usesLocalFilePerTable) {
        this.usesLocalFilePerTable = usesLocalFilePerTable;
    }

    @Override
    public Boolean isSupportsMixedCaseIdentifiers() {
        return this.supportsMixedCaseIdentifiers;
    }

    @Override
    public void setSupportsMixedCaseIdentifiers(Boolean supportsMixedCaseIdentifiers) {
        this.supportsMixedCaseIdentifiers = supportsMixedCaseIdentifiers;
    }

    @Override
    public Boolean isStoresUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    @Override
    public void setStoresUpperCaseIdentifiers(Boolean storesUpperCaseIdentifiers) {
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
    }

    @Override
    public Boolean isStoresLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    @Override
    public void setStoresLowerCaseIdentifiers(Boolean storesLowerCaseIdentifiers) {
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
    }

    @Override
    public Boolean isStoresMixedCaseIdentifiers() {
        return this.storesMixedCaseIdentifiers;
    }

    @Override
    public void setStoresMixedCaseIdentifiers(Boolean storesMixedCaseIdentifiers) {
        this.storesMixedCaseIdentifiers = storesMixedCaseIdentifiers;
    }

    @Override
    public Boolean isSupportsMixedCaseQuotedIdentifiers() {
        return this.supportsMixedCaseQuotedIdentifiers;
    }

    @Override
    public void setSupportsMixedCaseQuotedIdentifiers(Boolean supportsMixedCaseQuotedIdentifiers) {
        this.supportsMixedCaseQuotedIdentifiers = supportsMixedCaseQuotedIdentifiers;
    }

    @Override
    public Boolean isStoresUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    @Override
    public void setStoresUpperCaseQuotedIdentifiers(Boolean storesUpperCaseQuotedIdentifiers) {
        this.storesUpperCaseQuotedIdentifiers = storesUpperCaseQuotedIdentifiers;
    }

    @Override
    public Boolean isStoresLowerCaseQuotedIdentifiers() {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    @Override
    public void setStoresLowerCaseQuotedIdentifiers(Boolean storesLowerCaseQuotedIdentifiers) {
        this.storesLowerCaseQuotedIdentifiers = storesLowerCaseQuotedIdentifiers;
    }

    @Override
    public Boolean isStoresMixedCaseQuotedIdentifiers() {
        return this.storesMixedCaseQuotedIdentifiers;
    }

    @Override
    public void setStoresMixedCaseQuotedIdentifiers(Boolean storesMixedCaseQuotedIdentifiers) {
        this.storesMixedCaseQuotedIdentifiers = storesMixedCaseQuotedIdentifiers;
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public void setIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
    }

    @Override
    public Set<String> getSQLKeywords() {
        return this.sqlKeywords;
    }

    @Override
    public void addSQLKeyword(String sqlKeyword) {
        this.sqlKeywords.add(sqlKeyword);
    }

    @Override
    public void deleteSQLKeyword(String sqlKeyword) {
        this.sqlKeywords.remove(sqlKeyword);
    }

    @Override
    public Boolean isSQLKeywordSupported(String sqlKeyword) {
        for (String s : this.sqlKeywords) {
            if (!s.equals(sqlKeyword)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Set<String> getNumericFunctions() {
        return this.numericFunctions;
    }

    @Override
    public void addNumericFunction(String functionName) {
        this.numericFunctions.add(functionName);
    }

    @Override
    public void deleteNumericFunction(String functionName) {
        this.numericFunctions.remove(functionName);
    }

    @Override
    public Boolean isNumericFunctionSupported(String functionName) {
        for (String s : this.numericFunctions) {
            if (!s.equals(functionName)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Set<String> getStringFunctions() {
        return this.stringFunctions;
    }

    @Override
    public void addStringFunction(String functionName) {
        this.stringFunctions.add(functionName);
    }

    @Override
    public void deleteStringFunction(String functionName) {
        this.stringFunctions.remove(functionName);
    }

    @Override
    public Boolean isStringFunctionSupported(String functionName) {
        for (String s : this.stringFunctions) {
            if (!s.equals(functionName)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Set<String> getSystemFunctions() {
        return this.systemFunctions;
    }

    @Override
    public void addSystemFunction(String functionName) {
        this.systemFunctions.add(functionName);
    }

    @Override
    public void deleteSystemFunction(String functionName) {
        this.systemFunctions.remove(functionName);
    }

    @Override
    public Boolean isSystemFunctionSupported(String functionName) {
        for (String s : this.systemFunctions) {
            if (!s.equals(functionName)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Set<String> getTimeDateFunctions() {
        return this.timeDateFunctions;
    }

    @Override
    public void addTimeDateFunction(String functionName) {
        this.timeDateFunctions.add(functionName);
    }

    @Override
    public void deleteTimeDateFunction(String functionName) {
        this.timeDateFunctions.remove(functionName);
    }

    @Override
    public Boolean isTimeDateFunctionSupported(String functionName) {
        for (String s : this.timeDateFunctions) {
            if (!s.equals(functionName)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    @Override
    public void setSearchStringEscape(String searchStringEscape) {
        this.searchStringEscape = searchStringEscape;
    }

    @Override
    public String getExtraNameCharacters() {
        return this.extraNameCharacters;
    }

    @Override
    public void setExtraNameCharacters(String extraNameCharacters) {
        this.extraNameCharacters = extraNameCharacters;
    }

    @Override
    public Boolean isSupportsAlterTableWithAddColumn() {
        return this.supportsAlterTableWithAddColumn;
    }

    @Override
    public void setSupportsAlterTableWithAddColumn(Boolean supportsAlterTableWithAddColumn) {
        this.supportsAlterTableWithAddColumn = supportsAlterTableWithAddColumn;
    }

    @Override
    public Boolean isSupportsAlterTableWithDropColumn() {
        return this.supportsAlterTableWithDropColumn;
    }

    @Override
    public void setSupportsAlterTableWithDropColumn(Boolean supportsAlterTableWithDropColumn) {
        this.supportsAlterTableWithDropColumn = supportsAlterTableWithDropColumn;
    }

    @Override
    public Boolean isSupportsColumnAliasing() {
        return this.supportsColumnAliasing;
    }

    @Override
    public void setSupportsColumnAliasing(Boolean supportsColumnAliasing) {
        this.supportsColumnAliasing = supportsColumnAliasing;
    }

    @Override
    public Boolean isNullPlusNonNullIsNull() {
        return this.nullPlusNonNullIsNull;
    }

    @Override
    public void setNullPlusNonNullIsNull(Boolean nullPlusNonNullIsNull) {
        this.nullPlusNonNullIsNull = nullPlusNonNullIsNull;
    }

    @Override
    public Boolean isSupportsConvert() {
        return this.supportsConvert;
    }

    @Override
    public void setSupportsConvert(Boolean supportsConvert) {
        this.supportsConvert = supportsConvert;
    }

    @Override
    public Set<SqlTypeConversionPair> getSupportedConversions() {
        return this.supportedConversions;
    }

    @Override
    public void addSqlTypeConversionPair(SqlTypeConversionPair sqlTypeConversionPair) {
        this.supportedConversions.add(sqlTypeConversionPair);
    }

    @Override
    public void deleteSqlTypeConversionPair(SqlTypeConversionPair sqlTypeConversionPair) {
        this.supportedConversions.remove(sqlTypeConversionPair);
    }

    @Override
    public Set<SqlTypeConversionPair> findSqlTypeConversionPairBySrcType(String srcType) {
        HashSet<SqlTypeConversionPair> set = new HashSet<SqlTypeConversionPair>();
        for (SqlTypeConversionPair c : this.supportedConversions) {
            if (!c.getSrcType().toString().equals(srcType)) continue;
            set.add(c);
        }
        return set;
    }

    @Override
    public Boolean isSupportsTableCorrelationNames() {
        return this.supportsTableCorrelationNames;
    }

    @Override
    public void setSupportsTableCorrelationNames(Boolean supportsTableCorrelationNames) {
        this.supportsTableCorrelationNames = supportsTableCorrelationNames;
    }

    @Override
    public Boolean isSupportsDifferentTableCorrelationNames() {
        return this.supportsDifferentTableCorrelationNames;
    }

    @Override
    public void setSupportsDifferentTableCorrelationNames(Boolean supportsDifferentTableCorrelationNames) {
        this.supportsDifferentTableCorrelationNames = supportsDifferentTableCorrelationNames;
    }

    @Override
    public Boolean isSupportsExpressionsInOrderBy() {
        return this.supportsExpressionsInOrderBy;
    }

    @Override
    public void setSupportsExpressionsInOrderBy(Boolean supportsExpressionsInOrderBy) {
        this.supportsExpressionsInOrderBy = supportsExpressionsInOrderBy;
    }

    @Override
    public Boolean isSupportsOrderByUnrelated() {
        return this.supportsOrderByUnrelated;
    }

    @Override
    public void setSupportsOrderByUnrelated(Boolean supportsOrderByUnrelated) {
        this.supportsOrderByUnrelated = supportsOrderByUnrelated;
    }

    @Override
    public Boolean isSupportsGroupBy() {
        return this.supportsGroupBy;
    }

    @Override
    public void setSupportsGroupBy(Boolean supportsGroupBy) {
        this.supportsGroupBy = supportsGroupBy;
    }

    @Override
    public Boolean isSupportsGroupByUnrelated() {
        return this.supportsGroupByUnrelated;
    }

    @Override
    public void setSupportsGroupByUnrelated(Boolean supportsGroupByUnrelated) {
        this.supportsGroupByUnrelated = supportsGroupByUnrelated;
    }

    @Override
    public Boolean isSupportsGroupByBeyondSelect() {
        return this.supportsGroupByBeyondSelect;
    }

    @Override
    public void setSupportsGroupByBeyondSelect(Boolean supportsGroupByBeyondSelect) {
        this.supportsGroupByBeyondSelect = supportsGroupByBeyondSelect;
    }

    @Override
    public Boolean isSupportsLikeEscapeClause() {
        return this.supportsLikeEscapeClause;
    }

    @Override
    public void setSupportsLikeEscapeClause(Boolean supportsLikeEscapeClause) {
        this.supportsLikeEscapeClause = supportsLikeEscapeClause;
    }

    @Override
    public Boolean isSupportsMultipleResultSets() {
        return this.supportsMultipleResultSets;
    }

    @Override
    public void setSupportsMultipleResultSets(Boolean supportsMultipleResultSets) {
        this.supportsMultipleResultSets = supportsMultipleResultSets;
    }

    @Override
    public Boolean isSupportsMultipleTransactions() {
        return this.supportsMultipleTransactions;
    }

    @Override
    public void setSupportsMultipleTransactions(Boolean supportsMultipleTransactions) {
        this.supportsMultipleTransactions = supportsMultipleTransactions;
    }

    @Override
    public Boolean isSupportsNonNullableColumns() {
        return this.supportsNonNullableColumns;
    }

    @Override
    public void setSupportsNonNullableColumns(Boolean supportsNonNullableColumns) {
        this.supportsNonNullableColumns = supportsNonNullableColumns;
    }

    @Override
    public Boolean isSupportsMinimumSQLGrammar() {
        return this.supportsMinimumSQLGrammar;
    }

    @Override
    public void setSupportsMinimumSQLGrammar(Boolean supportsMinimumSQLGrammar) {
        this.supportsMinimumSQLGrammar = supportsMinimumSQLGrammar;
    }

    @Override
    public Boolean isSupportsCoreSQLGrammar() {
        return this.supportsCoreSQLGrammar;
    }

    @Override
    public void setSupportsCoreSQLGrammar(Boolean supportsCoreSQLGrammar) {
        this.supportsCoreSQLGrammar = supportsCoreSQLGrammar;
    }

    @Override
    public Boolean isSupportsExtendedSQLGrammar() {
        return this.supportsExtendedSQLGrammar;
    }

    @Override
    public void setSupportsExtendedSQLGrammar(Boolean supportsExtendedSQLGrammar) {
        this.supportsExtendedSQLGrammar = supportsExtendedSQLGrammar;
    }

    @Override
    public Boolean isSupportsANSI92EntryLevelSQL() {
        return this.supportsANSI92EntryLevelSQL;
    }

    @Override
    public void setSupportsANSI92EntryLevelSQL(Boolean supportsANSI92EntryLevelSQL) {
        this.supportsANSI92EntryLevelSQL = supportsANSI92EntryLevelSQL;
    }

    @Override
    public Boolean isSupportsANSI92IntermediateSQL() {
        return this.supportsANSI92IntermediateSQL;
    }

    @Override
    public void setSupportsANSI92IntermediateSQL(Boolean supportsANSI92IntermediateSQL) {
        this.supportsANSI92IntermediateSQL = supportsANSI92IntermediateSQL;
    }

    @Override
    public Boolean isSupportsANSI92FullSQL() {
        return this.supportsANSI92FullSQL;
    }

    @Override
    public void setSupportsANSI92FullSQL(Boolean supportsANSI92FullSQL) {
        this.supportsANSI92FullSQL = supportsANSI92FullSQL;
    }

    @Override
    public Boolean isSupportsIntegrityEnhancementFacility() {
        return this.supportsIntegrityEnhancementFacility;
    }

    @Override
    public void setSupportsIntegrityEnhancementFacility(Boolean supportsIntegrityEnhancementFacility) {
        this.supportsIntegrityEnhancementFacility = supportsIntegrityEnhancementFacility;
    }

    @Override
    public Boolean isSupportsOuterJoins() {
        return this.supportsOuterJoins;
    }

    @Override
    public void setSupportsOuterJoins(Boolean supportsOuterJoins) {
        this.supportsOuterJoins = supportsOuterJoins;
    }

    @Override
    public Boolean isSupportsFullOuterJoins() {
        return this.supportsFullOuterJoins;
    }

    @Override
    public void setSupportsFullOuterJoins(Boolean supportsFullOuterJoins) {
        this.supportsFullOuterJoins = supportsFullOuterJoins;
    }

    @Override
    public Boolean isSupportsLimitedOuterJoins() {
        return this.supportsLimitedOuterJoins;
    }

    @Override
    public void setSupportsLimitedOuterJoins(Boolean supportsLimitedOuterJoins) {
        this.supportsLimitedOuterJoins = supportsLimitedOuterJoins;
    }

    @Override
    public String getSchemaTerm() {
        return this.schemaTerm;
    }

    @Override
    public void setSchemaTerm(String schemaTerm) {
        this.schemaTerm = schemaTerm;
    }

    @Override
    public String getProcedureTerm() {
        return this.procedureTerm;
    }

    @Override
    public void setProcedureTerm(String procedureTerm) {
        this.procedureTerm = procedureTerm;
    }

    @Override
    public String getCatalogTerm() {
        return this.catalogTerm;
    }

    @Override
    public void setCatalogTerm(String catalogTerm) {
        this.catalogTerm = catalogTerm;
    }

    @Override
    public Boolean isCatalogAtStart() {
        return this.catalogAtStart;
    }

    @Override
    public void setCatalogAtStart(Boolean catalogAtStart) {
        this.catalogAtStart = catalogAtStart;
    }

    @Override
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    @Override
    public void setCatalogSeparator(String catalogSeparator) {
        this.catalogSeparator = catalogSeparator;
    }

    @Override
    public Boolean isSupportsSchemasInDataManipulation() {
        return this.supportsSchemasInDataManipulation;
    }

    @Override
    public void setSupportsSchemasInDataManipulation(Boolean supportsSchemasInDataManipulation) {
        this.supportsSchemasInDataManipulation = supportsSchemasInDataManipulation;
    }

    @Override
    public Boolean isSupportsSchemasInProcedureCalls() {
        return this.supportsSchemasInProcedureCalls;
    }

    @Override
    public void setSupportsSchemasInProcedureCalls(Boolean supportsSchemasInProcedureCalls) {
        this.supportsSchemasInProcedureCalls = supportsSchemasInProcedureCalls;
    }

    @Override
    public Boolean isSupportsSchemasInTableDefinitions() {
        return this.supportsSchemasInTableDefinitions;
    }

    @Override
    public void setSupportsSchemasInTableDefinitions(Boolean supportsSchemasInTableDefinitions) {
        this.supportsSchemasInTableDefinitions = supportsSchemasInTableDefinitions;
    }

    @Override
    public Boolean isSupportsSchemasInIndexDefinitions() {
        return this.supportsSchemasInIndexDefinitions;
    }

    @Override
    public void setSupportsSchemasInIndexDefinitions(Boolean supportsSchemasInIndexDefinitions) {
        this.supportsSchemasInIndexDefinitions = supportsSchemasInIndexDefinitions;
    }

    @Override
    public Boolean isSupportsSchemasInPrivilegeDefinitions() {
        return this.supportsSchemasInPrivilegeDefinitions;
    }

    @Override
    public void setSupportsSchemasInPrivilegeDefinitions(Boolean supportsSchemasInPrivilegeDefinitions) {
        this.supportsSchemasInPrivilegeDefinitions = supportsSchemasInPrivilegeDefinitions;
    }

    @Override
    public Boolean isSupportsCatalogsInDataManipulation() {
        return this.supportsCatalogsInDataManipulation;
    }

    @Override
    public void setSupportsCatalogsInDataManipulation(Boolean supportsCatalogsInDataManipulation) {
        this.supportsCatalogsInDataManipulation = supportsCatalogsInDataManipulation;
    }

    @Override
    public Boolean isSupportsCatalogsInProcedureCalls() {
        return this.supportsCatalogsInProcedureCalls;
    }

    @Override
    public void setSupportsCatalogsInProcedureCalls(Boolean supportsCatalogsInProcedureCalls) {
        this.supportsCatalogsInProcedureCalls = supportsCatalogsInProcedureCalls;
    }

    @Override
    public Boolean isSupportsCatalogsInTableDefinitions() {
        return this.supportsCatalogsInTableDefinitions;
    }

    @Override
    public void setSupportsCatalogsInTableDefinitions(Boolean supportsCatalogsInTableDefinitions) {
        this.supportsCatalogsInTableDefinitions = supportsCatalogsInTableDefinitions;
    }

    @Override
    public Boolean isSupportsCatalogsInIndexDefinitions() {
        return this.supportsCatalogsInIndexDefinitions;
    }

    @Override
    public void setSupportsCatalogsInIndexDefinitions(Boolean supportsCatalogsInIndexDefinitions) {
        this.supportsCatalogsInIndexDefinitions = supportsCatalogsInIndexDefinitions;
    }

    @Override
    public Boolean isSupportsCatalogsInPrivilegeDefinitions() {
        return this.supportsCatalogsInPrivilegeDefinitions;
    }

    @Override
    public void setSupportsCatalogsInPrivilegeDefinitions(Boolean supportsCatalogsInPrivilegeDefinitions) {
        this.supportsCatalogsInPrivilegeDefinitions = supportsCatalogsInPrivilegeDefinitions;
    }

    @Override
    public Boolean isSupportsPositionedDelete() {
        return this.supportsPositionedDelete;
    }

    @Override
    public void setSupportsPositionedDelete(Boolean supportsPositionedDelete) {
        this.supportsPositionedDelete = supportsPositionedDelete;
    }

    @Override
    public Boolean isSupportsPositionedUpdate() {
        return this.supportsPositionedUpdate;
    }

    @Override
    public void setSupportsPositionedUpdate(Boolean supportsPositionedUpdate) {
        this.supportsPositionedUpdate = supportsPositionedUpdate;
    }

    @Override
    public Boolean isSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    @Override
    public void setSupportsSelectForUpdate(Boolean supportsSelectForUpdate) {
        this.supportsSelectForUpdate = supportsSelectForUpdate;
    }

    @Override
    public Boolean isSupportsStoredProcedures() {
        return this.supportsStoredProcedures;
    }

    @Override
    public void setSupportsStoredProcedures(Boolean supportsStoredProcedures) {
        this.supportsStoredProcedures = supportsStoredProcedures;
    }

    @Override
    public Boolean isSupportsSubqueriesInComparisons() {
        return this.supportsSubqueriesInComparisons;
    }

    @Override
    public void setSupportsSubqueriesInComparisons(Boolean supportsSubqueriesInComparisons) {
        this.supportsSubqueriesInComparisons = supportsSubqueriesInComparisons;
    }

    @Override
    public Boolean isSupportsSubqueriesInExists() {
        return this.supportsSubqueriesInExists;
    }

    @Override
    public void setSupportsSubqueriesInExists(Boolean supportsSubqueriesInExists) {
        this.supportsSubqueriesInExists = supportsSubqueriesInExists;
    }

    @Override
    public Boolean isSupportsSubqueriesInIns() {
        return this.supportsSubqueriesInIns;
    }

    @Override
    public void setSupportsSubqueriesInIns(Boolean supportsSubqueriesInIns) {
        this.supportsSubqueriesInIns = supportsSubqueriesInIns;
    }

    @Override
    public Boolean isSupportsSubqueriesInQuantifieds() {
        return this.supportsSubqueriesInQuantifieds;
    }

    @Override
    public void setSupportsSubqueriesInQuantifieds(Boolean supportsSubqueriesInQuantifieds) {
        this.supportsSubqueriesInQuantifieds = supportsSubqueriesInQuantifieds;
    }

    @Override
    public Boolean isSupportsCorrelatedSubqueries() {
        return this.supportsCorrelatedSubqueries;
    }

    @Override
    public void setSupportsCorrelatedSubqueries(Boolean supportsCorrelatedSubqueries) {
        this.supportsCorrelatedSubqueries = supportsCorrelatedSubqueries;
    }

    @Override
    public Boolean isSupportsUnion() {
        return this.supportsUnion;
    }

    @Override
    public void setSupportsUnion(Boolean supportsUnion) {
        this.supportsUnion = supportsUnion;
    }

    @Override
    public Boolean isSupportsUnionAll() {
        return this.supportsUnionAll;
    }

    @Override
    public void setSupportsUnionAll(Boolean supportsUnionAll) {
        this.supportsUnionAll = supportsUnionAll;
    }

    @Override
    public Boolean isSupportsOpenCursorsAcrossCommit() {
        return this.supportsOpenCursorsAcrossCommit;
    }

    @Override
    public void setSupportsOpenCursorsAcrossCommit(Boolean supportsOpenCursorsAcrossCommit) {
        this.supportsOpenCursorsAcrossCommit = supportsOpenCursorsAcrossCommit;
    }

    @Override
    public Boolean isSupportsOpenCursorsAcrossRollback() {
        return this.supportsOpenCursorsAcrossRollback;
    }

    @Override
    public void setSupportsOpenCursorsAcrossRollback(Boolean supportsOpenCursorsAcrossRollback) {
        this.supportsOpenCursorsAcrossRollback = supportsOpenCursorsAcrossRollback;
    }

    @Override
    public Boolean isSupportsOpenStatementsAcrossCommit() {
        return this.supportsOpenStatementsAcrossCommit;
    }

    @Override
    public void setSupportsOpenStatementsAcrossCommit(Boolean supportsOpenStatementsAcrossCommit) {
        this.supportsOpenStatementsAcrossCommit = supportsOpenStatementsAcrossCommit;
    }

    @Override
    public Boolean isSupportsOpenStatementsAcrossRollback() {
        return this.supportsOpenStatementsAcrossRollback;
    }

    @Override
    public void setSupportsOpenStatementsAcrossRollback(Boolean supportsOpenStatementsAcrossRollback) {
        this.supportsOpenStatementsAcrossRollback = supportsOpenStatementsAcrossRollback;
    }

    @Override
    public Integer getMaxBinaryLiteralLength() {
        return this.maxBinaryLiteralLength;
    }

    @Override
    public void setMaxBinaryLiteralLength(Integer maxBinaryLiteralLength) {
        this.maxBinaryLiteralLength = maxBinaryLiteralLength;
    }

    @Override
    public Integer getMaxCharLiteralLength() {
        return this.maxCharLiteralLength;
    }

    @Override
    public void setMaxCharLiteralLength(Integer maxCharLiteralLength) {
        this.maxCharLiteralLength = maxCharLiteralLength;
    }

    @Override
    public Integer getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    @Override
    public void setMaxColumnNameLength(Integer maxColumnNameLength) {
        this.maxColumnNameLength = maxColumnNameLength;
    }

    @Override
    public Integer getMaxColumnsInGroupBy() {
        return this.maxColumnsInGroupBy;
    }

    @Override
    public void setMaxColumnsInGroupBy(Integer maxColumnsInGroupBy) {
        this.maxColumnsInGroupBy = maxColumnsInGroupBy;
    }

    @Override
    public Integer getMaxColumnsInIndex() {
        return this.maxColumnsInIndex;
    }

    @Override
    public void setMaxColumnsInIndex(Integer maxColumnsInIndex) {
        this.maxColumnsInIndex = maxColumnsInIndex;
    }

    @Override
    public Integer getMaxColumnsInOrderBy() {
        return this.maxColumnsInOrderBy;
    }

    @Override
    public void setMaxColumnsInOrderBy(Integer maxColumnsInOrderBy) {
        this.maxColumnsInOrderBy = maxColumnsInOrderBy;
    }

    @Override
    public Integer getMaxColumnsInSelect() {
        return this.maxColumnsInSelect;
    }

    @Override
    public void setMaxColumnsInSelect(Integer maxColumnsInSelect) {
        this.maxColumnsInSelect = maxColumnsInSelect;
    }

    @Override
    public Integer getMaxColumnsInTable() {
        return this.maxColumnsInTable;
    }

    @Override
    public void setMaxColumnsInTable(Integer maxColumnsInTable) {
        this.maxColumnsInTable = maxColumnsInTable;
    }

    @Override
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public Integer getMaxCursorNameLength() {
        return this.maxCursorNameLength;
    }

    @Override
    public void setMaxCursorNameLength(Integer maxCursorNameLength) {
        this.maxCursorNameLength = maxCursorNameLength;
    }

    @Override
    public Integer getMaxIndexLength() {
        return this.maxIndexLength;
    }

    @Override
    public void setMaxIndexLength(Integer maxIndexLength) {
        this.maxIndexLength = maxIndexLength;
    }

    @Override
    public Integer getMaxSchemaNameLength() {
        return this.maxSchemaNameLength;
    }

    @Override
    public void setMaxSchemaNameLength(Integer maxSchemaNameLength) {
        this.maxSchemaNameLength = maxSchemaNameLength;
    }

    @Override
    public Integer getMaxProcedureNameLength() {
        return this.maxProcedureNameLength;
    }

    @Override
    public void setMaxProcedureNameLength(Integer maxProcedureNameLength) {
        this.maxProcedureNameLength = maxProcedureNameLength;
    }

    @Override
    public Integer getMaxCatalogNameLength() {
        return this.maxCatalogNameLength;
    }

    @Override
    public void setMaxCatalogNameLength(Integer maxCatalogNameLength) {
        this.maxCatalogNameLength = maxCatalogNameLength;
    }

    @Override
    public Integer getMaxRowSize() {
        return this.maxRowSize;
    }

    @Override
    public void setMaxRowSize(Integer maxRowSize) {
        this.maxRowSize = maxRowSize;
    }

    @Override
    public Boolean isMaxRowSizeIncludeBlobs() {
        return this.maxRowSizeIncludeBlobs;
    }

    @Override
    public void setMaxRowSizeIncludeBlobs(Boolean maxRowSizeIncludeBlobs) {
        this.maxRowSizeIncludeBlobs = maxRowSizeIncludeBlobs;
    }

    @Override
    public Integer getMaxStatementLength() {
        return this.maxStatementLength;
    }

    @Override
    public void setMaxStatementLength(Integer maxStatementLength) {
        this.maxStatementLength = maxStatementLength;
    }

    @Override
    public Integer getMaxStatements() {
        return this.maxStatements;
    }

    @Override
    public void setMaxStatements(Integer maxStatements) {
        this.maxStatements = maxStatements;
    }

    @Override
    public Integer getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    @Override
    public void setMaxTableNameLength(Integer maxTableNameLength) {
        this.maxTableNameLength = maxTableNameLength;
    }

    @Override
    public Integer getMaxTablesInSelect() {
        return this.maxTablesInSelect;
    }

    @Override
    public void setMaxTablesInSelect(Integer maxTablesInSelect) {
        this.maxTablesInSelect = maxTablesInSelect;
    }

    @Override
    public Integer getMaxUserNameLength() {
        return this.maxUserNameLength;
    }

    @Override
    public void setMaxUserNameLength(Integer maxUserNameLength) {
        this.maxUserNameLength = maxUserNameLength;
    }

    @Override
    public Integer getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @Override
    public void setDefaultTransactionIsolation(Integer defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    @Override
    public Boolean isSupportsTransactions() {
        return this.supportsTransactions;
    }

    @Override
    public void setSupportsTransactions(Boolean supportsTransactions) {
        this.supportsTransactions = supportsTransactions;
    }

    @Override
    public Set<TransactionIsolationLevelType> getSupportedTransactionIsolationLevels() {
        return this.supportedTransactionIsolationLevels;
    }

    @Override
    public void addSupportedTransactionIsolationLevelType(TransactionIsolationLevelType transactionIsolationLevelType) {
        this.supportedTransactionIsolationLevels.add(transactionIsolationLevelType);
    }

    @Override
    public void deleteSupportedTransactionIsolationLevelType(TransactionIsolationLevelType transactionIsolationLevelType) {
        this.supportedTransactionIsolationLevels.remove((Object)transactionIsolationLevelType);
    }

    @Override
    public Boolean isSupportedTransactionIsolationLevelType(TransactionIsolationLevelType transactionIsolationLevelType) {
        for (TransactionIsolationLevelType t : this.supportedTransactionIsolationLevels) {
            if (!t.equals((Object)transactionIsolationLevelType)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isSupportsDataDefinitionAndDataManipulationTransactions() {
        return this.supportsDataDefinitionAndDataManipulationTransactions;
    }

    @Override
    public void setSupportsDataDefinitionAndDataManipulationTransactions(Boolean supportsDataDefinitionAndDataManipulationTransactions) {
        this.supportsDataDefinitionAndDataManipulationTransactions = supportsDataDefinitionAndDataManipulationTransactions;
    }

    @Override
    public Boolean isSupportsDataManipulationTransactionsOnly() {
        return this.supportsDataManipulationTransactionsOnly;
    }

    @Override
    public void setSupportsDataManipulationTransactionsOnly(Boolean supportsDataManipulationTransactionsOnly) {
        this.supportsDataManipulationTransactionsOnly = supportsDataManipulationTransactionsOnly;
    }

    @Override
    public Boolean isDataDefinitionCausesTransactionCommit() {
        return this.dataDefinitionCausesTransactionCommit;
    }

    @Override
    public void setDataDefinitionCausesTransactionCommit(Boolean dataDefinitionCausesTransactionCommit) {
        this.dataDefinitionCausesTransactionCommit = dataDefinitionCausesTransactionCommit;
    }

    @Override
    public Boolean isDataDefinitionIgnoredInTransactions() {
        return this.dataDefinitionIgnoredInTransactions;
    }

    @Override
    public void setDataDefinitionIgnoredInTransactions(Boolean dataDefinitionIgnoredInTransactions) {
        this.dataDefinitionIgnoredInTransactions = dataDefinitionIgnoredInTransactions;
    }

    @Override
    public Set<StoredProcedure> getStoredProcedures() {
        return this.storedProcedures;
    }

    @Override
    public void addStoredProcedure(StoredProcedure storedProcedure) {
        this.storedProcedures.add(storedProcedure);
    }

    @Override
    public void deleteStoredProcedure(StoredProcedure storedProcedure) {
        this.storedProcedures.remove(storedProcedure);
    }

    @Override
    public StoredProcedure findStoredProcedureByName(String catalog, String schema, String procedureName) {
        for (StoredProcedure sp : this.storedProcedures) {
            boolean schemaNameEquals;
            boolean catalogNameEquals;
            if (!sp.getName().equals(procedureName)) continue;
            boolean bl = sp.getCatalog() != null ? sp.getCatalog().getName().equals(catalog) : (catalogNameEquals = catalog == null);
            boolean bl2 = sp.getSchema() != null ? sp.getSchema().getName().equals(schema) : (schemaNameEquals = schema == null);
            if (!catalogNameEquals || !schemaNameEquals) continue;
            return sp;
        }
        return null;
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    @Override
    public void addTable(Table table) {
        this.tables.add(table);
    }

    @Override
    public void deleteTable(Table table) {
        this.tables.remove(table);
    }

    @Override
    public Table findTableByName(String catalog, String schema, String tableName) {
        for (Table t : this.tables) {
            boolean schemaNameEquals;
            boolean catalogNameEquals;
            if (!t.getName().equals(tableName)) continue;
            boolean bl = t.getCatalog() != null ? t.getCatalog().getName().equals(catalog) : (catalogNameEquals = catalog == null);
            boolean bl2 = t.getSchema() != null ? t.getSchema().getName().equals(schema) : (schemaNameEquals = schema == null);
            if (!catalogNameEquals || !schemaNameEquals) continue;
            return t;
        }
        return null;
    }

    @Override
    public Set<Schema> getSchemas() {
        return this.schemas;
    }

    @Override
    public void addSchema(Schema schema) {
        this.schemas.add(schema);
    }

    @Override
    public void deleteSchema(Schema schema) {
        this.schemas.remove(schema);
    }

    @Override
    public Schema findSchemaByName(String catalog, String schemaName) {
        for (Schema s : this.schemas) {
            boolean catalogNameEquals;
            if (!s.getName().equals(schemaName) || !(catalogNameEquals = s.getCatalog() != null ? s.getCatalog().getName().equals(catalog) : catalog == null)) continue;
            return s;
        }
        return null;
    }

    @Override
    public Set<Catalog> getCatalogs() {
        return this.catalogs;
    }

    @Override
    public void addCatalog(Catalog catalog) {
        this.catalogs.add(catalog);
    }

    @Override
    public void deleteCatalog(Catalog catalog) {
        this.catalogs.remove(catalog);
    }

    @Override
    public Catalog findCatalogByName(String catalogName) {
        for (Catalog c : this.catalogs) {
            if (!c.getName().equals(catalogName)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Set<TableType> getTableTypes() {
        return this.tableTypes;
    }

    @Override
    public void addTableType(TableType tableType) {
        this.tableTypes.add(tableType);
    }

    @Override
    public void deleteTableType(TableType tableType) {
        this.tableTypes.remove(tableType);
    }

    @Override
    public TableType findTableTypeByTypeName(String typeName) {
        for (TableType tt : this.tableTypes) {
            if (!tt.getName().equals(typeName)) continue;
            return tt;
        }
        return null;
    }

    @Override
    public Set<SqlTypeInfo> getSqlTypeInfos() {
        return this.sqlTypeInfos;
    }

    @Override
    public void addSqlTypeInfo(SqlTypeInfo sqlTypeInfo) {
        this.sqlTypeInfos.add(sqlTypeInfo);
    }

    @Override
    public void deleteSqlTypeInfo(SqlTypeInfo sqlTypeInfo) {
        this.sqlTypeInfos.remove(sqlTypeInfo);
    }

    @Override
    public SqlTypeInfo findSqlTypeInfoByTypeName(String typeName) {
        for (SqlTypeInfo sti : this.sqlTypeInfos) {
            if (!sti.getName().equals(typeName)) continue;
            return sti;
        }
        return null;
    }

    @Override
    public Set<ResultSetType> getSupportedResultSetTypes() {
        return this.supportedResultSetTypes;
    }

    @Override
    public void addSupportedResultSetType(ResultSetType resultSetType) {
        this.supportedResultSetTypes.add(resultSetType);
    }

    @Override
    public void deleteSupportedResultSetType(ResultSetType resultSetType) {
        this.supportedResultSetTypes.remove((Object)resultSetType);
    }

    @Override
    public Set<ResultSetConcurrencyType> getSupportedForwardOnlyResultSetConcurrencies() {
        return this.supportedForwardOnlyResultSetConcurrencies;
    }

    @Override
    public void addSupportedForwardOnlyResultSetConcurrency(ResultSetConcurrencyType resultSetConcurrencyType) {
        this.supportedForwardOnlyResultSetConcurrencies.add(resultSetConcurrencyType);
    }

    @Override
    public void deleteSupportedForwardOnlyResultSetConcurrency(ResultSetConcurrencyType resultSetConcurrencyType) {
        this.supportedForwardOnlyResultSetConcurrencies.remove((Object)resultSetConcurrencyType);
    }

    @Override
    public Set<ResultSetConcurrencyType> getSupportedScrollInsensitiveResultSetConcurrencies() {
        return this.supportedScrollInsensitiveResultSetConcurrencies;
    }

    @Override
    public void addSupportedScrollInsensitiveResultSetConcurrency(ResultSetConcurrencyType resultSetConcurrencyType) {
        this.supportedScrollInsensitiveResultSetConcurrencies.add(resultSetConcurrencyType);
    }

    @Override
    public void deleteSupportedScrollInsensitiveResultSetConcurrency(ResultSetConcurrencyType resultSetConcurrencyType) {
        this.supportedScrollInsensitiveResultSetConcurrencies.remove((Object)resultSetConcurrencyType);
    }

    @Override
    public Set<ResultSetConcurrencyType> getSupportedScrollSensitiveResultSetConcurrencies() {
        return this.supportedScrollSensitiveResultSetConcurrencies;
    }

    @Override
    public void addSupportedScrollSensitiveResultSetConcurrency(ResultSetConcurrencyType resultSetConcurrencyType) {
        this.supportedScrollSensitiveResultSetConcurrencies.add(resultSetConcurrencyType);
    }

    @Override
    public void deleteSupportedScrollSensitiveResultSetConcurrency(ResultSetConcurrencyType resultSetConcurrencyType) {
        this.supportedScrollSensitiveResultSetConcurrencies.remove((Object)resultSetConcurrencyType);
    }

    @Override
    public Boolean isForwardOnlyResultSetOwnUpdatesAreVisible() {
        return this.forwardOnlyResultSetOwnUpdatesAreVisible;
    }

    @Override
    public void setForwardOnlyResultSetOwnUpdatesAreVisible(Boolean forwardOnlyResultSetOwnUpdatesAreVisible) {
        this.forwardOnlyResultSetOwnUpdatesAreVisible = forwardOnlyResultSetOwnUpdatesAreVisible;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetOwnUpdatesAreVisible() {
        return this.scrollInsensitiveResultSetOwnUpdatesAreVisible;
    }

    @Override
    public void setScrollInsensitiveResultSetOwnUpdatesAreVisible(Boolean scrollInsensitiveResultSetOwnUpdatesAreVisible) {
        this.scrollInsensitiveResultSetOwnUpdatesAreVisible = scrollInsensitiveResultSetOwnUpdatesAreVisible;
    }

    @Override
    public Boolean isScrollSensitiveResultSetOwnUpdatesAreVisible() {
        return this.scrollSensitiveResultSetOwnUpdatesAreVisible;
    }

    @Override
    public void setScrollSensitiveResultSetOwnUpdatesAreVisible(Boolean scrollSensitiveResultSetOwnUpdatesAreVisible) {
        this.scrollSensitiveResultSetOwnUpdatesAreVisible = scrollSensitiveResultSetOwnUpdatesAreVisible;
    }

    @Override
    public Boolean isForwardOnlyResultSetOwnDeletesAreVisible() {
        return this.forwardOnlyResultSetOwnDeletesAreVisible;
    }

    @Override
    public void setForwardOnlyResultSetOwnDeletesAreVisible(Boolean forwardOnlyResultSetOwnDeletesAreVisible) {
        this.forwardOnlyResultSetOwnDeletesAreVisible = forwardOnlyResultSetOwnDeletesAreVisible;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetOwnDeletesAreVisible() {
        return this.scrollInsensitiveResultSetOwnDeletesAreVisible;
    }

    @Override
    public void setScrollInsensitiveResultSetOwnDeletesAreVisible(Boolean scrollInsensitiveResultSetOwnDeletesAreVisible) {
        this.scrollInsensitiveResultSetOwnDeletesAreVisible = scrollInsensitiveResultSetOwnDeletesAreVisible;
    }

    @Override
    public Boolean isScrollSensitiveResultSetOwnDeletesAreVisible() {
        return this.scrollSensitiveResultSetOwnDeletesAreVisible;
    }

    @Override
    public void setScrollSensitiveResultSetOwnDeletesAreVisible(Boolean scrollSensitiveResultSetOwnDeletesAreVisible) {
        this.scrollSensitiveResultSetOwnDeletesAreVisible = scrollSensitiveResultSetOwnDeletesAreVisible;
    }

    @Override
    public Boolean isForwardOnlyResultSetOwnInsertsAreVisible() {
        return this.forwardOnlyResultSetOwnInsertsAreVisible;
    }

    @Override
    public void setForwardOnlyResultSetOwnInsertsAreVisible(Boolean forwardOnlyResultSetOwnInsertsAreVisible) {
        this.forwardOnlyResultSetOwnInsertsAreVisible = forwardOnlyResultSetOwnInsertsAreVisible;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetOwnInsertsAreVisible() {
        return this.scrollInsensitiveResultSetOwnInsertsAreVisible;
    }

    @Override
    public void setScrollInsensitiveResultSetOwnInsertsAreVisible(Boolean scrollInsensitiveResultSetOwnInsertsAreVisible) {
        this.scrollInsensitiveResultSetOwnInsertsAreVisible = scrollInsensitiveResultSetOwnInsertsAreVisible;
    }

    @Override
    public Boolean isScrollSensitiveResultSetOwnInsertsAreVisible() {
        return this.scrollSensitiveResultSetOwnInsertsAreVisible;
    }

    @Override
    public void setScrollSensitiveResultSetOwnInsertsAreVisible(Boolean scrollSensitiveResultSetOwnInsertsAreVisible) {
        this.scrollSensitiveResultSetOwnInsertsAreVisible = scrollSensitiveResultSetOwnInsertsAreVisible;
    }

    @Override
    public Boolean isForwardOnlyResultSetOthersUpdatesAreVisible() {
        return this.forwardOnlyResultSetOthersUpdatesAreVisible;
    }

    @Override
    public void setForwardOnlyResultSetOthersUpdatesAreVisible(Boolean forwardOnlyResultSetOthersUpdatesAreVisible) {
        this.forwardOnlyResultSetOthersUpdatesAreVisible = forwardOnlyResultSetOthersUpdatesAreVisible;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetOthersUpdatesAreVisible() {
        return this.scrollInsensitiveResultSetOthersUpdatesAreVisible;
    }

    @Override
    public void setScrollInsensitiveResultSetOthersUpdatesAreVisible(Boolean scrollInsensitiveResultSetOthersUpdatesAreVisible) {
        this.scrollInsensitiveResultSetOthersUpdatesAreVisible = scrollInsensitiveResultSetOthersUpdatesAreVisible;
    }

    @Override
    public Boolean isScrollSensitiveResultSetOthersUpdatesAreVisible() {
        return this.scrollSensitiveResultSetOthersUpdatesAreVisible;
    }

    @Override
    public void setScrollSensitiveResultSetOthersUpdatesAreVisible(Boolean scrollSensitiveResultSetOthersUpdatesAreVisible) {
        this.scrollSensitiveResultSetOthersUpdatesAreVisible = scrollSensitiveResultSetOthersUpdatesAreVisible;
    }

    @Override
    public Boolean isForwardOnlyResultSetOthersDeletesAreVisible() {
        return this.forwardOnlyResultSetOthersDeletesAreVisible;
    }

    @Override
    public void setForwardOnlyResultSetOthersDeletesAreVisible(Boolean forwardOnlyResultSetOthersDeletesAreVisible) {
        this.forwardOnlyResultSetOthersDeletesAreVisible = forwardOnlyResultSetOthersDeletesAreVisible;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetOthersDeletesAreVisible() {
        return this.scrollInsensitiveResultSetOthersDeletesAreVisible;
    }

    @Override
    public void setScrollInsensitiveResultSetOthersDeletesAreVisible(Boolean scrollInsensitiveResultSetOthersDeletesAreVisible) {
        this.scrollInsensitiveResultSetOthersDeletesAreVisible = scrollInsensitiveResultSetOthersDeletesAreVisible;
    }

    @Override
    public Boolean isScrollSensitiveResultSetOthersDeletesAreVisible() {
        return this.scrollSensitiveResultSetOthersDeletesAreVisible;
    }

    @Override
    public void setScrollSensitiveResultSetOthersDeletesAreVisible(Boolean scrollSensitiveResultSetOthersDeletesAreVisible) {
        this.scrollSensitiveResultSetOthersDeletesAreVisible = scrollSensitiveResultSetOthersDeletesAreVisible;
    }

    @Override
    public Boolean isForwardOnlyResultSetOthersInsertsAreVisible() {
        return this.forwardOnlyResultSetOthersInsertsAreVisible;
    }

    @Override
    public void setForwardOnlyResultSetOthersInsertsAreVisible(Boolean forwardOnlyResultSetOthersInsertsAreVisible) {
        this.forwardOnlyResultSetOthersInsertsAreVisible = forwardOnlyResultSetOthersInsertsAreVisible;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetOthersInsertsAreVisible() {
        return this.scrollInsensitiveResultSetOthersInsertsAreVisible;
    }

    @Override
    public void setScrollInsensitiveResultSetOthersInsertsAreVisible(Boolean scrollInsensitiveResultSetOthersInsertsAreVisible) {
        this.scrollInsensitiveResultSetOthersInsertsAreVisible = scrollInsensitiveResultSetOthersInsertsAreVisible;
    }

    @Override
    public Boolean isScrollSensitiveResultSetOthersInsertsAreVisible() {
        return this.scrollSensitiveResultSetOthersInsertsAreVisible;
    }

    @Override
    public void setScrollSensitiveResultSetOthersInsertsAreVisible(Boolean scrollSensitiveResultSetOthersInsertsAreVisible) {
        this.scrollSensitiveResultSetOthersInsertsAreVisible = scrollSensitiveResultSetOthersInsertsAreVisible;
    }

    @Override
    public Boolean isForwardOnlyResultSetUpdatesAreDetected() {
        return this.forwardOnlyResultSetUpdatesAreDetected;
    }

    @Override
    public void setForwardOnlyResultSetUpdatesAreDetected(Boolean forwardOnlyResultSetUpdatesAreDetected) {
        this.forwardOnlyResultSetUpdatesAreDetected = forwardOnlyResultSetUpdatesAreDetected;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetUpdatesAreDetected() {
        return this.scrollInsensitiveResultSetUpdatesAreDetected;
    }

    @Override
    public void setScrollInsensitiveResultSetUpdatesAreDetected(Boolean scrollInsensitiveResultSetUpdatesAreDetected) {
        this.scrollInsensitiveResultSetUpdatesAreDetected = scrollInsensitiveResultSetUpdatesAreDetected;
    }

    @Override
    public Boolean isScrollSensitiveResultSetUpdatesAreDetected() {
        return this.scrollSensitiveResultSetUpdatesAreDetected;
    }

    @Override
    public void setScrollSensitiveResultSetUpdatesAreDetected(Boolean scrollSensitiveResultSetUpdatesAreDetected) {
        this.scrollSensitiveResultSetUpdatesAreDetected = scrollSensitiveResultSetUpdatesAreDetected;
    }

    @Override
    public Boolean isForwardOnlyResultSetDeletesAreDetected() {
        return this.forwardOnlyResultSetDeletesAreDetected;
    }

    @Override
    public void setForwardOnlyResultSetDeletesAreDetected(Boolean forwardOnlyResultSetDeletesAreDetected) {
        this.forwardOnlyResultSetDeletesAreDetected = forwardOnlyResultSetDeletesAreDetected;
    }

    @Override
    public Boolean isScrollInsensitiveResultSetDeletesAreDetected() {
        return this.scrollInsensitiveResultSetDeletesAreDetected;
    }

    @Override
    public void setScrollInsensitiveResultSetDeletesAreDetected(Boolean scrollInsensitiveResultSetDeletesAreDetected) {
        this.scrollInsensitiveResultSetDeletesAreDetected = scrollInsensitiveResultSetDeletesAreDetected;
    }

    @Override
    public Boolean isScrollSensitiveResultSetDeletesAreDetected() {
        return this.scrollSensitiveResultSetDeletesAreDetected;
    }

    @Override
    public void setScrollSensitiveResultSetDeletesAreDetected(Boolean scrollSensitiveResultSetDeletesAreDetected) {
        this.scrollSensitiveResultSetDeletesAreDetected = scrollSensitiveResultSetDeletesAreDetected;
    }

    @Override
    public Boolean isForwardOnlyResultInsertsAreDetected() {
        return this.forwardOnlyResultInsertsAreDetected;
    }

    @Override
    public void setForwardOnlyResultInsertsAreDetected(Boolean forwardOnlyResultInsertsAreDetected) {
        this.forwardOnlyResultInsertsAreDetected = forwardOnlyResultInsertsAreDetected;
    }

    @Override
    public Boolean isScrollInsensitiveResultInsertsAreDetected() {
        return this.scrollInsensitiveResultInsertsAreDetected;
    }

    @Override
    public void setScrollInsensitiveResultInsertsAreDetected(Boolean scrollInsensitiveResultInsertsAreDetected) {
        this.scrollInsensitiveResultInsertsAreDetected = scrollInsensitiveResultInsertsAreDetected;
    }

    @Override
    public Boolean isScrollSensitiveResultInsertsAreDetected() {
        return this.scrollSensitiveResultInsertsAreDetected;
    }

    @Override
    public void setScrollSensitiveResultInsertsAreDetected(Boolean scrollSensitiveResultInsertsAreDetected) {
        this.scrollSensitiveResultInsertsAreDetected = scrollSensitiveResultInsertsAreDetected;
    }

    @Override
    public Boolean isSupportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    @Override
    public void setSupportsBatchUpdates(Boolean supportsBatchUpdates) {
        this.supportsBatchUpdates = supportsBatchUpdates;
    }

    @Override
    public Set<UserDefinedType> getUserDefinedTypes() {
        return this.userDefinedTypes;
    }

    @Override
    public void addUserDefinedType(UserDefinedType udt) {
        this.userDefinedTypes.add(udt);
    }

    @Override
    public void deleteUserDefinedType(UserDefinedType udt) {
        this.userDefinedTypes.remove(udt);
    }

    @Override
    public UserDefinedType findUserDefinedTypeByName(String catalog, String schema, String tableName) {
        for (UserDefinedType udt : this.userDefinedTypes) {
            boolean schemaNameEquals;
            boolean catalogNameEquals;
            if (!udt.getName().equals(tableName)) continue;
            boolean bl = udt.getCatalog() != null ? udt.getCatalog().getName().equals(catalog) : (catalogNameEquals = catalog == null);
            boolean bl2 = udt.getSchema() != null ? udt.getSchema().getName().equals(schema) : (schemaNameEquals = schema == null);
            if (!catalogNameEquals || !schemaNameEquals) continue;
            return udt;
        }
        return null;
    }

    @Override
    public Boolean isSupportsSavepoints() {
        return this.supportsSavepoints;
    }

    @Override
    public void setSupportsSavepoints(Boolean supportsSavepoints) {
        this.supportsSavepoints = supportsSavepoints;
    }

    @Override
    public Boolean isSupportsNamedParameters() {
        return this.supportsNamedParameters;
    }

    @Override
    public void setSupportsNamedParameters(Boolean supportsNamedParameters) {
        this.supportsNamedParameters = supportsNamedParameters;
    }

    @Override
    public Boolean isSupportsMultipleOpenResults() {
        return this.supportsMultipleOpenResults;
    }

    @Override
    public void setSupportsMultipleOpenResults(Boolean supportsMultipleOpenResults) {
        this.supportsMultipleOpenResults = supportsMultipleOpenResults;
    }

    @Override
    public Boolean isSupportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    @Override
    public void setSupportsGetGeneratedKeys(Boolean supportsGetGeneratedKeys) {
        this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
    }

    @Override
    public Boolean isSupportsResultSetHoldCurrorsOverCommitHoldability() {
        return this.supportsResultSetHoldCurrorsOverCommitHoldability;
    }

    @Override
    public void setSupportsResultSetHoldCurrorsOverCommitHoldability(Boolean supportsResultSetHoldCurrorsOverCommitHoldability) {
        this.supportsResultSetHoldCurrorsOverCommitHoldability = supportsResultSetHoldCurrorsOverCommitHoldability;
    }

    @Override
    public Boolean isSupportsResultSetCloseCurrorsAtCommitHoldability() {
        return this.supportsResultSetCloseCurrorsAtCommitHoldability;
    }

    @Override
    public void setSupportsResultSetCloseCurrorsAtCommitHoldability(Boolean supportsResultSetCloseCurrorsAtCommitHoldability) {
        this.supportsResultSetCloseCurrorsAtCommitHoldability = supportsResultSetCloseCurrorsAtCommitHoldability;
    }

    @Override
    public ResultSetHoldabilityType getResultSetHoldabilityType() {
        return this.resultSetHoldabilityType;
    }

    @Override
    public void setResultSetHoldabilityType(ResultSetHoldabilityType resultSetHoldabilityType) {
        this.resultSetHoldabilityType = resultSetHoldabilityType;
    }

    @Override
    public Integer getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    @Override
    public void setDatabaseMajorVersion(Integer databaseMajorVersion) {
        this.databaseMajorVersion = databaseMajorVersion;
    }

    @Override
    public Integer getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Override
    public void setDatabaseMinorVersion(Integer databaseMinorVersion) {
        this.databaseMinorVersion = databaseMinorVersion;
    }

    @Override
    public Integer getJDBCMajorVersion() {
        return this.jdbcMajorVersion;
    }

    @Override
    public void setJDBCMajorVersion(Integer jdbcMajorVersion) {
        this.jdbcMajorVersion = jdbcMajorVersion;
    }

    @Override
    public Integer getJDBCMinorVersion() {
        return this.jdbcMinorVersion;
    }

    @Override
    public void setJDBCMinorVersion(Integer jdbcMinorVersion) {
        this.jdbcMinorVersion = jdbcMinorVersion;
    }

    @Override
    public SQLStateType getSQLStateType() {
        return this.sqlStateType;
    }

    @Override
    public void setSQLStateType(SQLStateType sqlStateType) {
        this.sqlStateType = sqlStateType;
    }

    @Override
    public Boolean isLocatorsUpdateCopy() {
        return this.locatorsUpdateCopy;
    }

    @Override
    public void setLocatorsUpdateCopy(Boolean locatorsUpdateCopy) {
        this.locatorsUpdateCopy = locatorsUpdateCopy;
    }

    @Override
    public Boolean isSupportsStatementPooling() {
        return this.supportsStatementPooling;
    }

    @Override
    public void setSupportsStatementPooling(Boolean supportsStatementPooling) {
        this.supportsStatementPooling = supportsStatementPooling;
    }
}

