/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.provider;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.dna.common.jdbc.provider.DataSourceDatabaseMetadataProvider;
import org.jboss.dna.common.jdbc.provider.DefaultDatabaseMetadataProvider;

public class DefaultDataSourceDatabaseMetadataProvider
extends DefaultDatabaseMetadataProvider
implements DataSourceDatabaseMetadataProvider {
    private static final long serialVersionUID = -405855619877872933L;
    private String dataSourceName;
    private DataSource dataSource;

    public DefaultDataSourceDatabaseMetadataProvider() {
    }

    public DefaultDataSourceDatabaseMetadataProvider(String name) {
        super(name);
    }

    protected Connection openConnection() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Opening database connection from data source " + this.getDataSourceName(), new Object[0]);
        }
        return this.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource() throws Exception {
        if (this.dataSource == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creating JNDI initial context with following properties: " + this.getProperties(), new Object[0]);
            }
            InitialContext initialContext = new InitialContext(this.getProperties());
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Performing JNDI lookup for data source " + this.getDataSourceName(), new Object[0]);
                }
                this.dataSource = (DataSource)initialContext.lookup(this.getDataSourceName());
            }
            finally {
                initialContext.close();
            }
        }
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

