/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.DefaultModelFactory;
import org.jboss.dna.common.jdbc.model.ModelFactory;
import org.jboss.dna.common.jdbc.model.api.Catalog;
import org.jboss.dna.common.jdbc.model.api.Database;
import org.jboss.dna.common.jdbc.model.api.DatabaseMetaDataMethodException;
import org.jboss.dna.common.jdbc.model.api.ResultSetConcurrencyType;
import org.jboss.dna.common.jdbc.model.api.ResultSetHoldabilityType;
import org.jboss.dna.common.jdbc.model.api.ResultSetType;
import org.jboss.dna.common.jdbc.model.api.SQLStateType;
import org.jboss.dna.common.jdbc.model.api.Schema;
import org.jboss.dna.common.jdbc.model.api.SqlType;
import org.jboss.dna.common.jdbc.model.api.SqlTypeConversionPair;
import org.jboss.dna.common.jdbc.model.api.SqlTypeInfo;
import org.jboss.dna.common.jdbc.model.api.StoredProcedure;
import org.jboss.dna.common.jdbc.model.api.Table;
import org.jboss.dna.common.jdbc.model.api.TableType;
import org.jboss.dna.common.jdbc.model.api.TransactionIsolationLevelType;
import org.jboss.dna.common.jdbc.model.api.UserDefinedType;
import org.jboss.dna.common.jdbc.model.spi.DatabaseBean;

public class DatabaseBeanTest
extends TestCase {
    private Database bean;
    private ModelFactory factory;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new DatabaseBean();
        this.factory = new DefaultModelFactory();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        this.factory = null;
        super.tearDown();
    }

    public void testModelFactoryIsNotNull() {
        DatabaseBeanTest.assertNotNull((String)"Default model factory shall be set", (Object)this.factory);
    }

    public void testGetExceptions() {
        List exceptionList = this.bean.getExceptionList();
        DatabaseBeanTest.assertNotNull((String)"Database Metadata Method Exception List should not be null", (Object)exceptionList);
        DatabaseBeanTest.assertTrue((String)"Database Metadata Method Exception List should be empty", (boolean)exceptionList.isEmpty());
    }

    public void testAddException() {
        String MESSAGE = "Database MetaData Method Exception";
        String METHOD_NAME = "myMethod";
        DatabaseMetaDataMethodException exception = new DatabaseMetaDataMethodException(MESSAGE, METHOD_NAME, null);
        this.bean.addException(exception);
        List exceptionList = this.bean.getExceptionList();
        DatabaseBeanTest.assertTrue((String)"Unable to add DatabaseMetaDataMethodException to the error list for provider ", (boolean)exceptionList.contains(exception));
    }

    public void testFindException() {
        String MESSAGE = "Database MetaData Method Exception";
        String METHOD_NAME = "myMethod";
        DatabaseMetaDataMethodException exception = new DatabaseMetaDataMethodException(MESSAGE, METHOD_NAME, null);
        this.bean.addException(exception);
        DatabaseBeanTest.assertSame((String)"Unable to find database metadata method exception", (Object)exception, (Object)this.bean.findException(METHOD_NAME));
    }

    public void testDatabaseMetaDataMethodFailed() {
        String MESSAGE = "Database MetaData Method Exception";
        String METHOD_NAME = "myMethod";
        DatabaseMetaDataMethodException exception = new DatabaseMetaDataMethodException(MESSAGE, METHOD_NAME, null);
        this.bean.addException(exception);
        DatabaseBeanTest.assertTrue((String)("The database metadata method " + METHOD_NAME + " should be failed"), (boolean)this.bean.isDatabaseMetaDataMethodFailed(METHOD_NAME));
    }

    public void testSetName() {
        String VALUE = "My name";
        this.bean.setName(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getName());
    }

    public void testSetAllProceduresAreCallable() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setAllProceduresAreCallable(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isAllProceduresAreCallable());
    }

    public void testSetAllTablesAreSelectable() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setAllTablesAreSelectable(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isAllTablesAreSelectable());
    }

    public void testSetURL() {
        String VALUE = "My URL";
        this.bean.setURL(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getURL());
    }

    public void testSetUserName() {
        String VALUE = "My name";
        this.bean.setUserName(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getUserName());
    }

    public void testSetReadOnly() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setReadOnly(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isReadOnly());
    }

    public void testSetNullsAreSortedHigh() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setNullsAreSortedHigh(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isNullsAreSortedHigh());
    }

    public void testSetNullsAreSortedLow() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setNullsAreSortedLow(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isNullsAreSortedLow());
    }

    public void testSetNullsAreSortedAtStart() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setNullsAreSortedAtStart(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isNullsAreSortedAtStart());
    }

    public void testSetNullsAreSortedAtEnd() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setNullsAreSortedAtEnd(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isNullsAreSortedAtEnd());
    }

    public void testSetDatabaseProductName() {
        String VALUE = "My product name";
        this.bean.setDatabaseProductName(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDatabaseProductName());
    }

    public void testSetDatabaseProductVersion() {
        String VALUE = "My version";
        this.bean.setDatabaseProductVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDatabaseProductVersion());
    }

    public void testSetDriverName() {
        String VALUE = "My driver name";
        this.bean.setDriverName(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDriverName());
    }

    public void testSetDriverVersion() {
        String VALUE = "My driver version";
        this.bean.setDriverVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDriverVersion());
    }

    public void testSetDriverMajorVersion() {
        Integer VALUE = new Integer(1);
        this.bean.setDriverMajorVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDriverMajorVersion());
    }

    public void testSetDriverMinorVersion() {
        Integer VALUE = new Integer(1);
        this.bean.setDriverMinorVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDriverMinorVersion());
    }

    public void testSetUsesLocalFiles() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setUsesLocalFiles(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isUsesLocalFiles());
    }

    public void testSetUsesLocalFilePerTable() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setUsesLocalFilePerTable(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isUsesLocalFilePerTable());
    }

    public void testSetSupportsMixedCaseIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsMixedCaseIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsMixedCaseIdentifiers());
    }

    public void testSetStoresUpperCaseIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setStoresUpperCaseIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isStoresUpperCaseIdentifiers());
    }

    public void testSetStoresLowerCaseIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setStoresLowerCaseIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isStoresLowerCaseIdentifiers());
    }

    public void testSetStoresMixedCaseIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setStoresMixedCaseIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isStoresMixedCaseIdentifiers());
    }

    public void testSetSupportsMixedCaseQuotedIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsMixedCaseQuotedIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsMixedCaseQuotedIdentifiers());
    }

    public void testSetStoresUpperCaseQuotedIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setStoresUpperCaseQuotedIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isStoresUpperCaseQuotedIdentifiers());
    }

    public void testSetStoresLowerCaseQuotedIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setStoresLowerCaseQuotedIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isStoresLowerCaseQuotedIdentifiers());
    }

    public void testSetStoresMixedCaseQuotedIdentifiers() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setStoresMixedCaseQuotedIdentifiers(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isStoresMixedCaseQuotedIdentifiers());
    }

    public void testSetIdentifierQuoteString() {
        String VALUE = "My id";
        this.bean.setIdentifierQuoteString(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getIdentifierQuoteString());
    }

    public void testGetSQLKeywords() {
        Set set = this.bean.getSQLKeywords();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSQLKeyword() {
        String NAME = "My name";
        this.bean.addSQLKeyword(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSQLKeywords().isEmpty());
    }

    public void testDeleteSQLKeyword() {
        String NAME = "My name";
        this.bean.addSQLKeyword(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSQLKeywords().isEmpty());
        this.bean.deleteSQLKeyword(NAME);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSQLKeywords().isEmpty());
    }

    public void testIsSQLKeywordSupported() {
        String NAME = "My name";
        this.bean.addSQLKeyword(NAME);
        DatabaseBeanTest.assertSame((Object)Boolean.TRUE, (Object)this.bean.isSQLKeywordSupported(NAME));
    }

    public void testGetNumericFunctions() {
        Set set = this.bean.getNumericFunctions();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddNumericFunction() {
        String NAME = "My name";
        this.bean.addNumericFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getNumericFunctions().isEmpty());
    }

    public void testDeleteNumericFunction() {
        String NAME = "My name";
        this.bean.addNumericFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getNumericFunctions().isEmpty());
        this.bean.deleteNumericFunction(NAME);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getNumericFunctions().isEmpty());
    }

    public void testIsNumericFunctionSupported() {
        String NAME = "My name";
        this.bean.addNumericFunction(NAME);
        DatabaseBeanTest.assertSame((Object)Boolean.TRUE, (Object)this.bean.isNumericFunctionSupported(NAME));
    }

    public void testGetStringFunctions() {
        Set set = this.bean.getStringFunctions();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddStringFunction() {
        String NAME = "My name";
        this.bean.addStringFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getStringFunctions().isEmpty());
    }

    public void testDeleteStringFunction() {
        String NAME = "My name";
        this.bean.addStringFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getStringFunctions().isEmpty());
        this.bean.deleteStringFunction(NAME);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getStringFunctions().isEmpty());
    }

    public void testIsStringFunctionSupported() {
        String NAME = "My name";
        this.bean.addStringFunction(NAME);
        DatabaseBeanTest.assertSame((Object)Boolean.TRUE, (Object)this.bean.isStringFunctionSupported(NAME));
    }

    public void testGetSystemFunctions() {
        Set set = this.bean.getSystemFunctions();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSystemFunction() {
        String NAME = "My name";
        this.bean.addSystemFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSystemFunctions().isEmpty());
    }

    public void testDeleteSystemFunction() {
        String NAME = "My name";
        this.bean.addSystemFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSystemFunctions().isEmpty());
        this.bean.deleteSystemFunction(NAME);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSystemFunctions().isEmpty());
    }

    public void testIsSystemFunctionSupported() {
        String NAME = "My name";
        this.bean.addSystemFunction(NAME);
        DatabaseBeanTest.assertSame((Object)Boolean.TRUE, (Object)this.bean.isSystemFunctionSupported(NAME));
    }

    public void testGetTimeDateFunctions() {
        Set set = this.bean.getTimeDateFunctions();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddTimeDateFunction() {
        String NAME = "My name";
        this.bean.addTimeDateFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getTimeDateFunctions().isEmpty());
    }

    public void testDeleteTimeDateFunction() {
        String NAME = "My name";
        this.bean.addTimeDateFunction(NAME);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getTimeDateFunctions().isEmpty());
        this.bean.deleteTimeDateFunction(NAME);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getTimeDateFunctions().isEmpty());
    }

    public void testIsTimeDateFunctionSupported() {
        String NAME = "My name";
        this.bean.addTimeDateFunction(NAME);
        DatabaseBeanTest.assertSame((Object)Boolean.TRUE, (Object)this.bean.isTimeDateFunctionSupported(NAME));
    }

    public void testSetSearchStringEscape() {
        String VALUE = "My search";
        this.bean.setSearchStringEscape(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getSearchStringEscape());
    }

    public void testSetExtraNameCharacters() {
        String VALUE = "My characters";
        this.bean.setExtraNameCharacters(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getExtraNameCharacters());
    }

    public void testSetSupportsAlterTableWithAddColumn() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsAlterTableWithAddColumn(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsAlterTableWithAddColumn());
    }

    public void testSetSupportsAlterTableWithDropColumn() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsAlterTableWithDropColumn(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsAlterTableWithDropColumn());
    }

    public void testSetSupportsColumnAliasing() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsColumnAliasing(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsColumnAliasing());
    }

    public void testSetNullPlusNonNullIsNull() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setNullPlusNonNullIsNull(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isNullPlusNonNullIsNull());
    }

    public void testSetSupportsConvert() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsConvert(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsConvert());
    }

    public void testGetSupportedConversions() {
        Set set = this.bean.getSupportedConversions();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSqlTypeConversionPair() {
        SqlTypeConversionPair object = new DefaultModelFactory().createSqlTypeConversionPair();
        object.setSrcType(SqlType.INTEGER);
        object.setDestType(SqlType.VARCHAR);
        this.bean.addSqlTypeConversionPair(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedConversions().isEmpty());
    }

    public void testDeleteSqlTypeConversionPair() {
        SqlTypeConversionPair object = new DefaultModelFactory().createSqlTypeConversionPair();
        object.setSrcType(SqlType.INTEGER);
        object.setDestType(SqlType.VARCHAR);
        this.bean.addSqlTypeConversionPair(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedConversions().isEmpty());
        this.bean.deleteSqlTypeConversionPair(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSupportedConversions().isEmpty());
    }

    public void testFindSqlTypeConversionPair() {
        SqlTypeConversionPair object = new DefaultModelFactory().createSqlTypeConversionPair();
        object.setSrcType(SqlType.INTEGER);
        object.setDestType(SqlType.VARCHAR);
        this.bean.addSqlTypeConversionPair(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.findSqlTypeConversionPairBySrcType(object.getSrcType().toString()).isEmpty());
    }

    public void testSetSupportsTableCorrelationNames() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsTableCorrelationNames(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsTableCorrelationNames());
    }

    public void testSetSupportsDifferentTableCorrelationNames() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsDifferentTableCorrelationNames(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsDifferentTableCorrelationNames());
    }

    public void testSetSupportsExpressionsInOrderBy() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsExpressionsInOrderBy(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsExpressionsInOrderBy());
    }

    public void testSetSupportsOrderByUnrelated() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsOrderByUnrelated(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsOrderByUnrelated());
    }

    public void testSetSupportsGroupBy() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsGroupBy(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsGroupBy());
    }

    public void testSetSupportsGroupByUnrelated() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsGroupByUnrelated(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsGroupByUnrelated());
    }

    public void testSetSupportsGroupByBeyondSelect() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsGroupByBeyondSelect(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsGroupByBeyondSelect());
    }

    public void testSetSupportsLikeEscapeClause() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsLikeEscapeClause(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsLikeEscapeClause());
    }

    public void testSetSupportsMultipleResultSets() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsMultipleResultSets(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsMultipleResultSets());
    }

    public void testSetSupportsMultipleTransactions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsMultipleTransactions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsMultipleTransactions());
    }

    public void testSetSupportsNonNullableColumns() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsNonNullableColumns(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsNonNullableColumns());
    }

    public void testSetSupportsMinimumSQLGrammar() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsMinimumSQLGrammar(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsMinimumSQLGrammar());
    }

    public void testSetSupportsCoreSQLGrammar() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsCoreSQLGrammar(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsCoreSQLGrammar());
    }

    public void testSetSupportsExtendedSQLGrammar() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsExtendedSQLGrammar(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsExtendedSQLGrammar());
    }

    public void testSetSupportsANSI92EntryLevelSQL() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsANSI92EntryLevelSQL(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsANSI92EntryLevelSQL());
    }

    public void testSetSupportsANSI92IntermediateSQL() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsANSI92IntermediateSQL(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsANSI92IntermediateSQL());
    }

    public void testSetSupportsANSI92FullSQL() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsANSI92FullSQL(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsANSI92FullSQL());
    }

    public void testSetSupportsIntegrityEnhancementFacility() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsIntegrityEnhancementFacility(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsIntegrityEnhancementFacility());
    }

    public void testSetSupportsOuterJoins() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsOuterJoins(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsOuterJoins());
    }

    public void testSetSupportsFullOuterJoins() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsFullOuterJoins(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsFullOuterJoins());
    }

    public void testSetSupportsLimitedOuterJoins() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsLimitedOuterJoins(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsLimitedOuterJoins());
    }

    public void testSetSchemaTerm() {
        String VALUE = "My value";
        this.bean.setSchemaTerm(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getSchemaTerm());
    }

    public void testSetProcedureTerm() {
        String VALUE = "My value";
        this.bean.setProcedureTerm(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getProcedureTerm());
    }

    public void testSetCatalogTerm() {
        String VALUE = "My value";
        this.bean.setCatalogTerm(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getCatalogTerm());
    }

    public void testSetCatalogAtStart() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setCatalogAtStart(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isCatalogAtStart());
    }

    public void testSetCatalogSeparator() {
        String VALUE = "My value";
        this.bean.setCatalogSeparator(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getCatalogSeparator());
    }

    public void testSetSupportsSchemasInDataManipulation() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSchemasInDataManipulation(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSchemasInDataManipulation());
    }

    public void testSetSupportsSchemasInProcedureCalls() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSchemasInProcedureCalls(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSchemasInProcedureCalls());
    }

    public void testSetSupportsSchemasInTableDefinitions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSchemasInTableDefinitions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSchemasInTableDefinitions());
    }

    public void testSetSupportsSchemasInIndexDefinitions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSchemasInIndexDefinitions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSchemasInIndexDefinitions());
    }

    public void testSetSupportsSchemasInPrivilegeDefinitions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSchemasInPrivilegeDefinitions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSchemasInPrivilegeDefinitions());
    }

    public void testSetSupportsCatalogsInDataManipulation() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsCatalogsInDataManipulation(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsCatalogsInDataManipulation());
    }

    public void testSetSupportsCatalogsInProcedureCalls() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsCatalogsInProcedureCalls(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsCatalogsInProcedureCalls());
    }

    public void testSetSupportsCatalogsInTableDefinitions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsCatalogsInTableDefinitions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsCatalogsInTableDefinitions());
    }

    public void testSetSupportsCatalogsInIndexDefinitions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsCatalogsInIndexDefinitions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsCatalogsInIndexDefinitions());
    }

    public void testSetSupportsCatalogsInPrivilegeDefinitions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsCatalogsInPrivilegeDefinitions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsCatalogsInPrivilegeDefinitions());
    }

    public void testSetSupportsPositionedDelete() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsPositionedDelete(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsPositionedDelete());
    }

    public void testSetSupportsPositionedUpdate() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsPositionedUpdate(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsPositionedUpdate());
    }

    public void testSetSupportsSelectForUpdate() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSelectForUpdate(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSelectForUpdate());
    }

    public void testSetSupportsStoredProcedures() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsStoredProcedures(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsStoredProcedures());
    }

    public void testSetSupportsSubqueriesInComparisons() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSubqueriesInComparisons(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSubqueriesInComparisons());
    }

    public void testSetSupportsSubqueriesInExists() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSubqueriesInExists(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSubqueriesInExists());
    }

    public void testSetSupportsSubqueriesInIns() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSubqueriesInIns(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSubqueriesInIns());
    }

    public void testSetSupportsSubqueriesInQuantifieds() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSubqueriesInQuantifieds(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSubqueriesInQuantifieds());
    }

    public void testSetSupportsCorrelatedSubqueries() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsCorrelatedSubqueries(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsCorrelatedSubqueries());
    }

    public void testSetSupportsUnion() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsUnion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsUnion());
    }

    public void testSetSupportsUnionAll() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsUnionAll(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsUnionAll());
    }

    public void testSetSupportsOpenCursorsAcrossCommit() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsOpenCursorsAcrossCommit(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsOpenCursorsAcrossCommit());
    }

    public void testSetSupportsOpenCursorsAcrossRollback() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsOpenCursorsAcrossRollback(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsOpenCursorsAcrossRollback());
    }

    public void testSetSupportsOpenStatementsAcrossCommit() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsOpenStatementsAcrossCommit(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsOpenStatementsAcrossCommit());
    }

    public void testSetSupportsOpenStatementsAcrossRollback() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsOpenStatementsAcrossRollback(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsOpenStatementsAcrossRollback());
    }

    public void testSetMaxBinaryLiteralLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxBinaryLiteralLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxBinaryLiteralLength());
    }

    public void testSetMaxCharLiteralLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxCharLiteralLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxCharLiteralLength());
    }

    public void testSetMaxColumnNameLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxColumnNameLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxColumnNameLength());
    }

    public void testSetMaxColumnsInGroupBy() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxColumnsInGroupBy(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxColumnsInGroupBy());
    }

    public void testSetMaxColumnsInIndex() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxColumnsInIndex(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxColumnsInIndex());
    }

    public void testSetMaxColumnsInOrderBy() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxColumnsInOrderBy(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxColumnsInOrderBy());
    }

    public void testSetMaxColumnsInSelect() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxColumnsInSelect(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxColumnsInSelect());
    }

    public void testSetMaxColumnsInTable() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxColumnsInTable(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxColumnsInTable());
    }

    public void testSetMaxConnections() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxConnections(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxConnections());
    }

    public void testSetMaxCursorNameLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxCursorNameLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxCursorNameLength());
    }

    public void testSetMaxIndexLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxIndexLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxIndexLength());
    }

    public void testSetMaxSchemaNameLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxSchemaNameLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxSchemaNameLength());
    }

    public void testSetMaxProcedureNameLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxProcedureNameLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxProcedureNameLength());
    }

    public void testSetMaxCatalogNameLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxCatalogNameLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxCatalogNameLength());
    }

    public void testSetMaxRowSize() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxRowSize(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxRowSize());
    }

    public void testSetMaxRowSizeIncludeBlobs() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setMaxRowSizeIncludeBlobs(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isMaxRowSizeIncludeBlobs());
    }

    public void testSetMaxStatementLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxStatementLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxStatementLength());
    }

    public void testSetMaxStatements() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxStatements(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxStatements());
    }

    public void testSetMaxTableNameLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxTableNameLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxTableNameLength());
    }

    public void testSetMaxTablesInSelect() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxTablesInSelect(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxTablesInSelect());
    }

    public void testSetMaxUserNameLength() {
        Integer VALUE = new Integer(1);
        this.bean.setMaxUserNameLength(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getMaxUserNameLength());
    }

    public void testSetDefaultTransactionIsolation() {
        Integer VALUE = new Integer(1);
        this.bean.setDefaultTransactionIsolation(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDefaultTransactionIsolation());
    }

    public void testSetSupportsTransactions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsTransactions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsTransactions());
    }

    public void testGetSupportedTransactionIsolationLevels() {
        Set set = this.bean.getSupportedTransactionIsolationLevels();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSupportedTransactionIsolationLevelType() {
        TransactionIsolationLevelType object = TransactionIsolationLevelType.READ_COMMITTED;
        this.bean.addSupportedTransactionIsolationLevelType(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedTransactionIsolationLevels().isEmpty());
    }

    public void testDeleteSupportedTransactionIsolationLevelType() {
        TransactionIsolationLevelType object = TransactionIsolationLevelType.READ_COMMITTED;
        this.bean.addSupportedTransactionIsolationLevelType(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedTransactionIsolationLevels().isEmpty());
        this.bean.deleteSupportedTransactionIsolationLevelType(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSupportedTransactionIsolationLevels().isEmpty());
    }

    public void testIsSupportedTransactionIsolationLevelType() {
        TransactionIsolationLevelType object = TransactionIsolationLevelType.READ_COMMITTED;
        this.bean.addSupportedTransactionIsolationLevelType(object);
        DatabaseBeanTest.assertSame((Object)Boolean.TRUE, (Object)this.bean.isSupportedTransactionIsolationLevelType(object));
    }

    public void testSetSupportsDataDefinitionAndDataManipulationTransactions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsDataDefinitionAndDataManipulationTransactions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsDataDefinitionAndDataManipulationTransactions());
    }

    public void testSetSupportsDataManipulationTransactionsOnly() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsDataManipulationTransactionsOnly(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsDataManipulationTransactionsOnly());
    }

    public void testSetDataDefinitionCausesTransactionCommit() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setDataDefinitionCausesTransactionCommit(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isDataDefinitionCausesTransactionCommit());
    }

    public void testSetDataDefinitionIgnoredInTransactions() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setDataDefinitionIgnoredInTransactions(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isDataDefinitionIgnoredInTransactions());
    }

    public void testGetStoredProcedures() {
        Set set = this.bean.getStoredProcedures();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddStoredProcedure() {
        String NAME = "My Name";
        StoredProcedure object = new DefaultModelFactory().createStoredProcedure();
        object.setName(NAME);
        this.bean.addStoredProcedure(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getStoredProcedures().isEmpty());
    }

    public void testDeleteStoredProcedure() {
        String NAME = "My Name";
        StoredProcedure object = new DefaultModelFactory().createStoredProcedure();
        object.setName(NAME);
        this.bean.addStoredProcedure(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getStoredProcedures().isEmpty());
        this.bean.deleteStoredProcedure(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getStoredProcedures().isEmpty());
    }

    public void testFindStoredProcedureByName() {
        String NAME = "My Name";
        StoredProcedure object = new DefaultModelFactory().createStoredProcedure();
        object.setName(NAME);
        this.bean.addStoredProcedure(object);
        DatabaseBeanTest.assertSame((Object)object, (Object)this.bean.findStoredProcedureByName(null, null, object.getName()));
    }

    public void testGetTables() {
        Set set = this.bean.getTables();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddTable() {
        String NAME = "My Name";
        Table object = new DefaultModelFactory().createTable();
        object.setName(NAME);
        this.bean.addTable(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getTables().isEmpty());
    }

    public void testDeleteTable() {
        String NAME = "My Name";
        Table object = new DefaultModelFactory().createTable();
        object.setName(NAME);
        this.bean.addTable(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getTables().isEmpty());
        this.bean.deleteTable(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getTables().isEmpty());
    }

    public void testFindTableByName() {
        String NAME = "My Name";
        Table object = new DefaultModelFactory().createTable();
        object.setName(NAME);
        this.bean.addTable(object);
        DatabaseBeanTest.assertSame((Object)object, (Object)this.bean.findTableByName(null, null, object.getName()));
    }

    public void testGetSchemas() {
        Set set = this.bean.getSchemas();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSchema() {
        String NAME = "My Name";
        Schema object = new DefaultModelFactory().createSchema();
        object.setName(NAME);
        this.bean.addSchema(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSchemas().isEmpty());
    }

    public void testDeleteSchema() {
        String NAME = "My Name";
        Schema object = new DefaultModelFactory().createSchema();
        object.setName(NAME);
        this.bean.addSchema(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSchemas().isEmpty());
        this.bean.deleteSchema(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSchemas().isEmpty());
    }

    public void testFindSchemaByName() {
        String NAME = "My Name";
        Schema object = new DefaultModelFactory().createSchema();
        object.setName(NAME);
        this.bean.addSchema(object);
        DatabaseBeanTest.assertSame((Object)object, (Object)this.bean.findSchemaByName(null, object.getName()));
    }

    public void testGetCatalogs() {
        Set set = this.bean.getCatalogs();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddCatalog() {
        String NAME = "My Name";
        Catalog object = new DefaultModelFactory().createCatalog();
        object.setName(NAME);
        this.bean.addCatalog(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getCatalogs().isEmpty());
    }

    public void testDeleteCatalog() {
        String NAME = "My Name";
        Catalog object = new DefaultModelFactory().createCatalog();
        object.setName(NAME);
        this.bean.addCatalog(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getCatalogs().isEmpty());
        this.bean.deleteCatalog(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getCatalogs().isEmpty());
    }

    public void testFindCatalogByName() {
        String NAME = "My Name";
        Catalog object = new DefaultModelFactory().createCatalog();
        object.setName(NAME);
        this.bean.addCatalog(object);
        DatabaseBeanTest.assertSame((Object)object, (Object)this.bean.findCatalogByName(object.getName()));
    }

    public void testGetTableTypes() {
        Set set = this.bean.getTableTypes();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddTableType() {
        String NAME = "My Name";
        TableType object = new DefaultModelFactory().createTableType();
        object.setName(NAME);
        this.bean.addTableType(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getTableTypes().isEmpty());
    }

    public void testDeleteTableType() {
        String NAME = "My Name";
        TableType object = new DefaultModelFactory().createTableType();
        object.setName(NAME);
        this.bean.addTableType(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getTableTypes().isEmpty());
        this.bean.deleteTableType(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getTableTypes().isEmpty());
    }

    public void testFindTableTypeByTypeName() {
        String NAME = "My Name";
        TableType object = new DefaultModelFactory().createTableType();
        object.setName(NAME);
        this.bean.addTableType(object);
        DatabaseBeanTest.assertSame((Object)object, (Object)this.bean.findTableTypeByTypeName(object.getName()));
    }

    public void testGetSqlTypeInfos() {
        Set set = this.bean.getSqlTypeInfos();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSqlTypeInfo() {
        String NAME = "My Name";
        SqlTypeInfo object = new DefaultModelFactory().createSqlTypeInfo();
        object.setName(NAME);
        this.bean.addSqlTypeInfo(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSqlTypeInfos().isEmpty());
    }

    public void testDeleteSqlTypeInfo() {
        String NAME = "My Name";
        SqlTypeInfo object = new DefaultModelFactory().createSqlTypeInfo();
        object.setName(NAME);
        this.bean.addSqlTypeInfo(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSqlTypeInfos().isEmpty());
        this.bean.deleteSqlTypeInfo(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSqlTypeInfos().isEmpty());
    }

    public void testFindSqlTypeInfoByTypeName() {
        String NAME = "My Name";
        SqlTypeInfo object = new DefaultModelFactory().createSqlTypeInfo();
        object.setName(NAME);
        this.bean.addSqlTypeInfo(object);
        DatabaseBeanTest.assertSame((Object)object, (Object)this.bean.findSqlTypeInfoByTypeName(object.getName()));
    }

    public void testGetSupportedResultSetTypes() {
        Set set = this.bean.getSupportedResultSetTypes();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSupportedResultSetType() {
        this.bean.addSupportedResultSetType(ResultSetType.SCROLL_INSENSITIVE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedResultSetTypes().isEmpty());
    }

    public void testDeleteSupportedResultSetType() {
        this.bean.addSupportedResultSetType(ResultSetType.SCROLL_INSENSITIVE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedResultSetTypes().isEmpty());
        this.bean.deleteSupportedResultSetType(ResultSetType.SCROLL_INSENSITIVE);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSupportedResultSetTypes().isEmpty());
    }

    public void testGetSupportedForwardOnlyResultSetConcurrencies() {
        Set set = this.bean.getSupportedForwardOnlyResultSetConcurrencies();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSupportedForwardOnlyResultSetConcurrency() {
        this.bean.addSupportedForwardOnlyResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedForwardOnlyResultSetConcurrencies().isEmpty());
    }

    public void testDeleteSupportedForwardOnlyResultSetConcurrency() {
        this.bean.addSupportedForwardOnlyResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedForwardOnlyResultSetConcurrencies().isEmpty());
        this.bean.deleteSupportedForwardOnlyResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSupportedForwardOnlyResultSetConcurrencies().isEmpty());
    }

    public void testGetSupportedScrollInsensitiveResultSetConcurrencies() {
        Set set = this.bean.getSupportedScrollInsensitiveResultSetConcurrencies();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSupportedScrollInsensitiveResultSetConcurrency() {
        this.bean.addSupportedScrollInsensitiveResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedScrollInsensitiveResultSetConcurrencies().isEmpty());
    }

    public void testDeleteSupportedScrollInsensitiveResultSetConcurrency() {
        this.bean.addSupportedScrollInsensitiveResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedScrollInsensitiveResultSetConcurrencies().isEmpty());
        this.bean.deleteSupportedScrollInsensitiveResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSupportedScrollInsensitiveResultSetConcurrencies().isEmpty());
    }

    public void testGetSupportedScrollSensitiveResultSetConcurrencies() {
        Set set = this.bean.getSupportedScrollSensitiveResultSetConcurrencies();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddSupportedScrollSensitiveResultSetConcurrency() {
        this.bean.addSupportedScrollSensitiveResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedScrollSensitiveResultSetConcurrencies().isEmpty());
    }

    public void testDeleteSupportedScrollSensitiveResultSetConcurrency() {
        this.bean.addSupportedScrollSensitiveResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getSupportedScrollSensitiveResultSetConcurrencies().isEmpty());
        this.bean.deleteSupportedScrollSensitiveResultSetConcurrency(ResultSetConcurrencyType.UPDATABLE);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getSupportedScrollSensitiveResultSetConcurrencies().isEmpty());
    }

    public void testSetForwardOnlyResultSetOwnUpdatesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultSetOwnUpdatesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultSetOwnUpdatesAreVisible());
    }

    public void testSetScrollInsensitiveResultSetOwnUpdatesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetOwnUpdatesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetOwnUpdatesAreVisible());
    }

    public void testSetScrollSensitiveResultSetOwnUpdatesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetOwnUpdatesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetOwnUpdatesAreVisible());
    }

    public void testSetForwardOnlyResultSetOwnDeletesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultSetOwnDeletesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultSetOwnDeletesAreVisible());
    }

    public void testSetScrollInsensitiveResultSetOwnDeletesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetOwnDeletesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetOwnDeletesAreVisible());
    }

    public void testSetScrollSensitiveResultSetOwnDeletesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetOwnDeletesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetOwnDeletesAreVisible());
    }

    public void testSetScrollInsensitiveResultSetOwnInsertsAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetOwnInsertsAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetOwnInsertsAreVisible());
    }

    public void testSetScrollSensitiveResultSetOwnInsertsAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetOwnInsertsAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetOwnInsertsAreVisible());
    }

    public void testSetForwardOnlyResultSetOthersUpdatesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultSetOthersUpdatesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultSetOthersUpdatesAreVisible());
    }

    public void testSetScrollInsensitiveResultSetOthersUpdatesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetOthersUpdatesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetOthersUpdatesAreVisible());
    }

    public void testSetScrollSensitiveResultSetOthersUpdatesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetOthersUpdatesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetOthersUpdatesAreVisible());
    }

    public void testSetForwardOnlyResultSetOthersDeletesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultSetOthersDeletesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultSetOthersDeletesAreVisible());
    }

    public void testSetScrollInsensitiveResultSetOthersDeletesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetOthersDeletesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetOthersDeletesAreVisible());
    }

    public void testSetScrollSensitiveResultSetOthersDeletesAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetOthersDeletesAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetOthersDeletesAreVisible());
    }

    public void testSetForwardOnlyResultSetOthersInsertsAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultSetOthersInsertsAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultSetOthersInsertsAreVisible());
    }

    public void testSetScrollInsensitiveResultSetOthersInsertsAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetOthersInsertsAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetOthersInsertsAreVisible());
    }

    public void testSetScrollSensitiveResultSetOthersInsertsAreVisible() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetOthersInsertsAreVisible(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetOthersInsertsAreVisible());
    }

    public void testSetForwardOnlyResultSetUpdatesAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultSetUpdatesAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultSetUpdatesAreDetected());
    }

    public void testSetScrollInsensitiveResultSetUpdatesAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetUpdatesAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetUpdatesAreDetected());
    }

    public void testSetScrollSensitiveResultSetUpdatesAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetUpdatesAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetUpdatesAreDetected());
    }

    public void testSetForwardOnlyResultSetDeletesAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultSetDeletesAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultSetDeletesAreDetected());
    }

    public void testSetScrollInsensitiveResultSetDeletesAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultSetDeletesAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultSetDeletesAreDetected());
    }

    public void testSetScrollSensitiveResultSetDeletesAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultSetDeletesAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultSetDeletesAreDetected());
    }

    public void testSetForwardOnlyResultInsertsAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setForwardOnlyResultInsertsAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isForwardOnlyResultInsertsAreDetected());
    }

    public void testSetScrollInsensitiveResultInsertsAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollInsensitiveResultInsertsAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollInsensitiveResultInsertsAreDetected());
    }

    public void testSetScrollSensitiveResultInsertsAreDetected() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setScrollSensitiveResultInsertsAreDetected(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isScrollSensitiveResultInsertsAreDetected());
    }

    public void testSetSupportsBatchUpdates() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsBatchUpdates(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsBatchUpdates());
    }

    public void testGetUserDefinedTypes() {
        Set set = this.bean.getUserDefinedTypes();
        DatabaseBeanTest.assertNotNull((Object)set);
        DatabaseBeanTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAddUserDefinedType() {
        String NAME = "My name";
        UserDefinedType object = new DefaultModelFactory().createUserDefinedType();
        object.setName(NAME);
        this.bean.addUserDefinedType(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getUserDefinedTypes().isEmpty());
    }

    public void testDeleteUserDefinedType() {
        String NAME = "My name";
        UserDefinedType object = new DefaultModelFactory().createUserDefinedType();
        object.setName(NAME);
        this.bean.addUserDefinedType(object);
        DatabaseBeanTest.assertFalse((boolean)this.bean.getUserDefinedTypes().isEmpty());
        this.bean.deleteUserDefinedType(object);
        DatabaseBeanTest.assertTrue((boolean)this.bean.getUserDefinedTypes().isEmpty());
    }

    public void testFindUserDefinedTypeByName() {
        String NAME = "My name";
        UserDefinedType object = new DefaultModelFactory().createUserDefinedType();
        object.setName(NAME);
        this.bean.addUserDefinedType(object);
        DatabaseBeanTest.assertSame((Object)object, (Object)this.bean.findUserDefinedTypeByName(null, null, object.getName()));
    }

    public void testSetSupportsSavepoints() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsSavepoints(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsSavepoints());
    }

    public void testSetSupportsNamedParameters() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsNamedParameters(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsNamedParameters());
    }

    public void testSetSupportsMultipleOpenResults() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsMultipleOpenResults(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsMultipleOpenResults());
    }

    public void testSetSupportsGetGeneratedKeys() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsGetGeneratedKeys(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsGetGeneratedKeys());
    }

    public void testSetSupportsResultSetHoldCurrorsOverCommitHoldability() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsResultSetHoldCurrorsOverCommitHoldability(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsResultSetHoldCurrorsOverCommitHoldability());
    }

    public void testSetSupportsResultSetCloseCurrorsAtCommitHoldability() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsResultSetCloseCurrorsAtCommitHoldability(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsResultSetCloseCurrorsAtCommitHoldability());
    }

    public void testSetResultSetHoldabilityType() {
        this.bean.setResultSetHoldabilityType(ResultSetHoldabilityType.HOLD_CURSORS_OVER_COMMIT);
        DatabaseBeanTest.assertSame((Object)ResultSetHoldabilityType.HOLD_CURSORS_OVER_COMMIT, (Object)this.bean.getResultSetHoldabilityType());
    }

    public void testSetDatabaseMajorVersion() {
        Integer VALUE = new Integer(1);
        this.bean.setDatabaseMajorVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDatabaseMajorVersion());
    }

    public void testSetDatabaseMinorVersion() {
        Integer VALUE = new Integer(1);
        this.bean.setDatabaseMinorVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getDatabaseMinorVersion());
    }

    public void testSetJDBCMajorVersion() {
        Integer VALUE = new Integer(1);
        this.bean.setJDBCMajorVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getJDBCMajorVersion());
    }

    public void testSetJDBCMinorVersion() {
        Integer VALUE = new Integer(1);
        this.bean.setJDBCMinorVersion(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.getJDBCMinorVersion());
    }

    public void testSetSQLStateType() {
        this.bean.setSQLStateType(SQLStateType.SQL99);
        DatabaseBeanTest.assertSame((Object)SQLStateType.SQL99, (Object)this.bean.getSQLStateType());
    }

    public void testSetLocatorsUpdateCopy() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setLocatorsUpdateCopy(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isLocatorsUpdateCopy());
    }

    public void testSetSupportsStatementPooling() {
        Boolean VALUE = Boolean.TRUE;
        this.bean.setSupportsStatementPooling(VALUE);
        DatabaseBeanTest.assertSame((Object)VALUE, (Object)this.bean.isSupportsStatementPooling());
    }
}

