/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.jdbc.model.spi;

import junit.framework.TestCase;
import org.jboss.dna.common.jdbc.model.api.NullabilityType;
import org.jboss.dna.common.jdbc.model.api.SearchabilityType;
import org.jboss.dna.common.jdbc.model.api.SqlType;
import org.jboss.dna.common.jdbc.model.api.SqlTypeInfo;
import org.jboss.dna.common.jdbc.model.spi.SqlTypeInfoBean;

public class SqlTypeInfoBeanTest
extends TestCase {
    private SqlTypeInfo bean;

    protected void setUp() throws Exception {
        super.setUp();
        this.bean = new SqlTypeInfoBean();
    }

    protected void tearDown() throws Exception {
        this.bean = null;
        super.tearDown();
    }

    public void testSetLocalizedTypeName() {
        String localizedTypeName = "Localized";
        this.bean.setLocalizedTypeName(localizedTypeName);
        SqlTypeInfoBeanTest.assertEquals((String)"Unable to set localized Type Name", (String)localizedTypeName, (String)this.bean.getLocalizedTypeName());
    }

    public void testSetNullabilityType() {
        this.bean.setNullabilityType(NullabilityType.NULLABLE);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set nullability type", (Object)NullabilityType.NULLABLE, (Object)this.bean.getNullabilityType());
    }

    public void testSetSqlType() {
        this.bean.setSqlType(SqlType.VARCHAR);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set SQL type", (Object)SqlType.VARCHAR, (Object)this.bean.getSqlType());
    }

    public void testSetPrecision() {
        Long precision = new Long(5L);
        this.bean.setPrecision(precision);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set precision", (Object)precision, (Object)this.bean.getPrecision());
    }

    public void testSetFixedPrecisionScale() {
        Boolean fixedPrecisionScale = Boolean.TRUE;
        this.bean.setFixedPrecisionScale(fixedPrecisionScale);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set fixed precision scale", (Object)fixedPrecisionScale, (Object)this.bean.isFixedPrecisionScale());
    }

    public void testSetNumberPrecisionRadix() {
        Integer numberPrecisionRadix = new Integer(10);
        this.bean.setNumberPrecisionRadix(numberPrecisionRadix);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set number precision radix", (Object)numberPrecisionRadix, (Object)this.bean.getNumberPrecisionRadix());
    }

    public void testSetMinScale() {
        Integer minScale = new Integer(1);
        this.bean.setMinScale(minScale);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set min scale", (Object)minScale, (Object)this.bean.getMinScale());
    }

    public void testSetMaxScale() {
        Integer maxScale = new Integer(10);
        this.bean.setMaxScale(maxScale);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set max scale", (Object)maxScale, (Object)this.bean.getMaxScale());
    }

    public void testSetLiteralPrefix() {
        String literalPrefix = "Prefix";
        this.bean.setLiteralPrefix(literalPrefix);
        SqlTypeInfoBeanTest.assertEquals((String)"Unable to set literal prefix", (String)literalPrefix, (String)this.bean.getLiteralPrefix());
    }

    public void testSetLiteralSuffix() {
        String literalSuffix = "Suffix";
        this.bean.setLiteralSuffix(literalSuffix);
        SqlTypeInfoBeanTest.assertEquals((String)"Unable to set literal suffix", (String)literalSuffix, (String)this.bean.getLiteralSuffix());
    }

    public void testSetCreateParams() {
        String createParams = "My params";
        this.bean.setCreateParams(createParams);
        SqlTypeInfoBeanTest.assertEquals((String)"Unable to set create params", (String)createParams, (String)this.bean.getCreateParams());
    }

    public void testSetCaseSensitive() {
        Boolean caseSensitive = Boolean.TRUE;
        this.bean.setCaseSensitive(caseSensitive);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set case sensitive", (Object)caseSensitive, (Object)this.bean.isCaseSensitive());
    }

    public void testSetSearchabilityType() {
        this.bean.setSearchabilityType(SearchabilityType.BASIC);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set searchability type", (Object)SearchabilityType.BASIC, (Object)this.bean.getSearchabilityType());
    }

    public void testSetUnsigned() {
        Boolean unsigned = Boolean.TRUE;
        this.bean.setUnsigned(unsigned);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set unsigned", (Object)unsigned, (Object)this.bean.isUnsigned());
    }

    public void testSetAutoIncrement() {
        Boolean autoIncrement = Boolean.TRUE;
        this.bean.setAutoIncrement(autoIncrement);
        SqlTypeInfoBeanTest.assertSame((String)"Unable to set auto increment", (Object)autoIncrement, (Object)this.bean.isAutoIncrement());
    }
}

