/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.dna.connector.jbosscache.JBossCacheConnection;
import org.jboss.dna.connector.jbosscache.JBossCacheSource;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.commands.GraphCommand;
import org.jboss.dna.graph.commands.basic.BasicCreateNodeCommand;
import org.jboss.dna.graph.commands.basic.BasicGetNodeCommand;
import org.jboss.dna.graph.connectors.BasicExecutionContext;
import org.jboss.dna.graph.connectors.RepositorySourceListener;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.properties.PathNotFoundException;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class JBossCacheConnectionTest {
    private JBossCacheConnection connection;
    private CacheFactory<Name, Object> cacheFactory;
    private Cache<Name, Object> cache;
    private ExecutionContext context;
    private PathFactory pathFactory;
    private NameFactory nameFactory;
    private PropertyFactory propertyFactory;
    @MockitoAnnotations.Mock
    private JBossCacheSource source;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new BasicExecutionContext();
        this.context.getNamespaceRegistry().register("dna", "http://www.jboss.org/dna");
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.propertyFactory = this.context.getPropertyFactory();
        this.nameFactory = this.context.getValueFactories().getNameFactory();
        this.cacheFactory = new DefaultCacheFactory();
        this.cache = this.cacheFactory.createCache();
        this.connection = new JBossCacheConnection(this.source, this.cache);
        Mockito.stub((Object)this.source.getUuidPropertyName()).toReturn((Object)DnaLexicon.UUID.getString(this.context.getNamespaceRegistry()));
        Mockito.stub((Object)this.source.getName()).toReturn((Object)"the source name");
    }

    @Test(expected=AssertionError.class)
    public void shouldFailToInstantiateIfCacheReferenceIsNull() {
        this.cache = null;
        this.connection = new JBossCacheConnection(this.source, this.cache);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailToInstantiateIfSourceReferenceIsNull() {
        this.source = null;
        this.connection = new JBossCacheConnection(this.source, this.cache);
    }

    @Test
    public void shouldInstantiateWithValidSourceAndCacheReferences() {
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldDelegateToTheSourceForTheConnectionsSourceName() {
        Mockito.stub((Object)this.source.getName()).toReturn((Object)"the source name");
        Assert.assertThat((Object)this.connection.getSourceName(), (Matcher)Is.is((Object)"the source name"));
        ((JBossCacheSource)Mockito.verify((Object)this.source)).getName();
    }

    @Test
    public void shouldDelegateToTheSourceForTheConnectionsDefaultCachePolicy() {
        CachePolicy policy = (CachePolicy)Mockito.mock(CachePolicy.class);
        Mockito.stub((Object)this.source.getDefaultCachePolicy()).toReturn((Object)policy);
        Assert.assertThat((Object)this.connection.getDefaultCachePolicy(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)policy)));
        ((JBossCacheSource)Mockito.verify((Object)this.source)).getDefaultCachePolicy();
    }

    @Test
    public void shouldGetTheRootFromTheCacheWhenPinged() {
        this.cache = (Cache)Mockito.mock(Cache.class);
        this.connection = new JBossCacheConnection(this.source, this.cache);
        Mockito.stub((Object)this.cache.getRoot()).toReturn(null);
        Assert.assertThat((Object)this.connection.ping(1L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        ((Cache)Mockito.verify(this.cache)).getRoot();
    }

    @Test
    public void shouldHaveNoOpListenerWhenCreated() {
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)JBossCacheConnection.NO_OP_LISTENER)));
    }

    @Test
    public void shouldUseNoOpListenerWhenSettingListenerToNull() {
        this.connection.setListener(null);
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)JBossCacheConnection.NO_OP_LISTENER)));
    }

    @Test
    public void shouldSetListenerToNonNullValue() {
        RepositorySourceListener listener = (RepositorySourceListener)Mockito.mock(RepositorySourceListener.class);
        this.connection.setListener(listener);
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)listener)));
        this.connection.setListener(null);
        Assert.assertThat((Object)this.connection.getListener(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)JBossCacheConnection.NO_OP_LISTENER)));
    }

    @Test
    public void shouldGetUuidPropertyNameFromSouceAndShouldNotChangeDuringLifetimeOfConnection() {
        Mockito.stub((Object)this.source.getUuidPropertyName()).toReturn((Object)DnaLexicon.UUID.getString(this.context.getNamespaceRegistry()));
        Name name = this.connection.getUuidPropertyName(this.context);
        ((JBossCacheSource)Mockito.verify((Object)this.source)).getUuidPropertyName();
        Assert.assertThat((Object)name.getLocalName(), (Matcher)Is.is((Object)"uuid"));
        Assert.assertThat((Object)name.getNamespaceUri(), (Matcher)Is.is((Object)"http://www.jboss.org/dna"));
        Mockito.stub((Object)this.source.getUuidPropertyName()).toReturn((Object)"something else");
        for (int i = 0; i != 10; ++i) {
            Name name2 = this.connection.getUuidPropertyName(this.context);
            Assert.assertThat((Object)name2, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)name)));
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.source});
    }

    @Test
    public void shouldGenerateUuid() {
        for (int i = 0; i != 100; ++i) {
            Assert.assertThat((Object)this.connection.generateUuid(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        }
    }

    @Test
    public void shouldCreateFullyQualifiedNodeOfPathSegmentsFromPath() {
        Path path = (Path)this.pathFactory.create("/a/b/c/d");
        Fqn fqn = this.connection.getFullyQualifiedName(path);
        Assert.assertThat((Object)fqn.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)fqn.isRoot(), (Matcher)Is.is((Object)false));
        for (int i = 0; i != path.size(); ++i) {
            Assert.assertThat((Object)((Path.Segment)fqn.get(i)), (Matcher)Is.is((Object)path.getSegment(i)));
        }
    }

    @Test
    public void shouldCreateFullyQualifiedNodeOfPathSegmentsFromRootPath() {
        Path path = this.pathFactory.createRootPath();
        Fqn fqn = this.connection.getFullyQualifiedName(path);
        Assert.assertThat((Object)fqn.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)fqn.isRoot(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailToCreateFullyQualifiedNodeFromNullPath() {
        this.connection.getFullyQualifiedName((Path)null);
    }

    @Test
    public void shouldCreateFullyQualifiedNodeFromPathSegment() {
        Path.Segment segment = this.pathFactory.createSegment("a");
        Fqn fqn = this.connection.getFullyQualifiedName(segment);
        Assert.assertThat((Object)fqn.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)fqn.isRoot(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)((Path.Segment)fqn.get(0)), (Matcher)Is.is((Object)segment));
    }

    @Test(expected=AssertionError.class)
    public void shouldFailToCreateFullyQualifiedNodeFromNullPathSegment() {
        this.connection.getFullyQualifiedName((Path.Segment)null);
    }

    @Test
    public void shouldCreatePathFromFullyQualifiedNode() {
        Path path = (Path)this.pathFactory.create("/a/b/c/d");
        Fqn fqn = this.connection.getFullyQualifiedName(path);
        Assert.assertThat((Object)this.connection.getPath(this.pathFactory, fqn), (Matcher)Is.is((Object)path));
    }

    @Test
    public void shouldCreateRootPathFromRootFullyQualifiedNode() {
        Path path = this.pathFactory.createRootPath();
        Fqn fqn = this.connection.getFullyQualifiedName(path);
        Assert.assertThat((Object)this.connection.getPath(this.pathFactory, fqn), (Matcher)Is.is((Object)path));
    }

    @Test
    public void shouldGetNodeIfItExistsInCache() {
        Name uuidProperty = this.connection.getUuidPropertyName(this.context);
        Path[] paths = new Path[]{(Path)this.pathFactory.create("/a"), (Path)this.pathFactory.create("/a/b"), (Path)this.pathFactory.create("/a/b/c")};
        Path nonExistantPath = (Path)this.pathFactory.create("/a/d");
        UUID[] uuids = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
        this.cache.put(Fqn.fromList((List)paths[0].getSegmentsList()), (Object)uuidProperty, (Object)uuids[0]);
        this.cache.put(Fqn.fromList((List)paths[1].getSegmentsList()), (Object)uuidProperty, (Object)uuids[1]);
        this.cache.put(Fqn.fromList((List)paths[2].getSegmentsList()), (Object)uuidProperty, (Object)uuids[2]);
        Node nodeA = this.cache.getNode(Fqn.fromList((List)paths[0].getSegmentsList()));
        Node nodeB = this.cache.getNode(Fqn.fromList((List)paths[1].getSegmentsList()));
        Node nodeC = this.cache.getNode(Fqn.fromList((List)paths[2].getSegmentsList()));
        Node nodeD = this.cache.getNode(Fqn.fromList((List)nonExistantPath.getSegmentsList()));
        Assert.assertThat((Object)nodeA, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeB, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeD, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.connection.getNode(this.context, paths[0]), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)nodeA)));
        Assert.assertThat((Object)this.connection.getNode(this.context, paths[1]), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)nodeB)));
        Assert.assertThat((Object)this.connection.getNode(this.context, paths[2]), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)nodeC)));
    }

    @Test
    public void shouldThrowExceptionWithLowestExistingNodeFromGetNodeIfTheNodeDoesNotExist() {
        Name uuidProperty = this.connection.getUuidPropertyName(this.context);
        Path[] paths = new Path[]{(Path)this.pathFactory.create("/a"), (Path)this.pathFactory.create("/a/b"), (Path)this.pathFactory.create("/a/b/c")};
        Path nonExistantPath = (Path)this.pathFactory.create("/a/d");
        UUID[] uuids = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
        this.cache.put(Fqn.fromList((List)paths[0].getSegmentsList()), (Object)uuidProperty, (Object)uuids[0]);
        this.cache.put(Fqn.fromList((List)paths[1].getSegmentsList()), (Object)uuidProperty, (Object)uuids[1]);
        this.cache.put(Fqn.fromList((List)paths[2].getSegmentsList()), (Object)uuidProperty, (Object)uuids[2]);
        Node nodeA = this.cache.getNode(Fqn.fromList((List)paths[0].getSegmentsList()));
        Node nodeB = this.cache.getNode(Fqn.fromList((List)paths[1].getSegmentsList()));
        Node nodeC = this.cache.getNode(Fqn.fromList((List)paths[2].getSegmentsList()));
        Node nodeD = this.cache.getNode(Fqn.fromList((List)nonExistantPath.getSegmentsList()));
        Assert.assertThat((Object)nodeA, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeB, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeD, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        try {
            this.connection.getNode(this.context, nonExistantPath);
            Assert.fail();
        }
        catch (PathNotFoundException e) {
            Assert.assertThat((Object)e.getLowestAncestorThatDoesExist(), (Matcher)Is.is((Object)paths[0]));
        }
    }

    @Test
    public void shouldCopyNode() {
        Name uuidProperty = this.connection.getUuidPropertyName(this.context);
        Path[] paths = new Path[]{(Path)this.pathFactory.create("/a"), (Path)this.pathFactory.create("/a/b"), (Path)this.pathFactory.create("/a/b/c"), (Path)this.pathFactory.create("/a/d")};
        UUID[] uuids = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
        this.cache.put(Fqn.fromList((List)paths[0].getSegmentsList()), (Object)uuidProperty, (Object)uuids[0]);
        this.cache.put(Fqn.fromList((List)paths[1].getSegmentsList()), (Object)uuidProperty, (Object)uuids[1]);
        this.cache.put(Fqn.fromList((List)paths[2].getSegmentsList()), (Object)uuidProperty, (Object)uuids[2]);
        this.cache.put(Fqn.fromList((List)paths[3].getSegmentsList()), (Object)uuidProperty, (Object)uuids[3]);
        Node nodeA = this.cache.getNode(Fqn.fromList((List)paths[0].getSegmentsList()));
        Node nodeB = this.cache.getNode(Fqn.fromList((List)paths[1].getSegmentsList()));
        Node nodeC = this.cache.getNode(Fqn.fromList((List)paths[2].getSegmentsList()));
        Node nodeD = this.cache.getNode(Fqn.fromList((List)paths[3].getSegmentsList()));
        Assert.assertThat((Object)nodeA, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeB, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeD, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeA.get((Object)uuidProperty), (Matcher)Is.is((Object)uuids[0]));
        Assert.assertThat((Object)nodeB.get((Object)uuidProperty), (Matcher)Is.is((Object)uuids[1]));
        Assert.assertThat((Object)nodeC.get((Object)uuidProperty), (Matcher)Is.is((Object)uuids[2]));
        Assert.assertThat((Object)nodeD.get((Object)uuidProperty), (Matcher)Is.is((Object)uuids[3]));
        Path newPathB = (Path)this.pathFactory.create("/a/d/b");
        Path newPathC = (Path)this.pathFactory.create("/a/d/b/c");
        Node newNodeB = this.cache.getNode(Fqn.fromList((List)newPathB.getSegmentsList()));
        Node newNodeC = this.cache.getNode(Fqn.fromList((List)newPathC.getSegmentsList()));
        Assert.assertThat((Object)newNodeB, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)newNodeC, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.connection.copyNode(nodeB, nodeD, true, uuidProperty, this.context), (Matcher)Is.is((Object)2));
        newNodeB = this.cache.getNode(Fqn.fromList((List)newPathB.getSegmentsList()));
        newNodeC = this.cache.getNode(Fqn.fromList((List)newPathC.getSegmentsList()));
        Assert.assertThat((Object)newNodeB, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)newNodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)newNodeB.get((Object)uuidProperty), (Matcher)Is.is((Matcher)IsNot.not((Object)nodeB.get((Object)uuidProperty))));
        Assert.assertThat((Object)newNodeC.get((Object)uuidProperty), (Matcher)Is.is((Matcher)IsNot.not((Object)nodeC.get((Object)uuidProperty))));
    }

    @Test
    public void shouldCreateSameNameSiblingsAndAutomaticallyManageSiblingIndexes() throws Exception {
        Property prop1 = this.propertyFactory.create((Name)this.nameFactory.create("dna:prop1"), new Object[]{"value1"});
        Property prop2 = this.propertyFactory.create((Name)this.nameFactory.create("dna:prop2"), new Object[]{"value1"});
        Path pathA = (Path)this.pathFactory.create("/a");
        BasicCreateNodeCommand createNode = new BasicCreateNodeCommand(pathA);
        createNode.setProperties(new Property[]{prop1, prop2});
        this.connection.execute(this.context, new GraphCommand[]{createNode});
        for (int i = 0; i != 20; ++i) {
            createNode = new BasicCreateNodeCommand((Path)this.pathFactory.create("/a/b"));
            createNode.setProperties(new Property[]{prop1, prop2});
            this.connection.execute(this.context, new GraphCommand[]{createNode});
        }
        Name nameB = this.pathFactory.createSegment("b").getName();
        Assert.assertThat((Object)nameB.getLocalName(), (Matcher)Is.is((Object)"b"));
        BasicGetNodeCommand getNode = new BasicGetNodeCommand(pathA);
        this.connection.execute(this.context, new GraphCommand[]{getNode});
        int index = 1;
        for (Path.Segment segment : getNode.getChildren()) {
            Assert.assertThat((Object)segment.getName(), (Matcher)Is.is((Object)nameB));
            Assert.assertThat((Object)segment.hasIndex(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)segment.getIndex(), (Matcher)Is.is((Object)index));
            ++index;
        }
    }

    @Test
    public void shouldCreateSameNameSiblingsAndAutomaticallyManageSiblingIndexesInterspersedWithSiblingsWithOtherNames() throws Exception {
        Property prop1 = this.propertyFactory.create((Name)this.nameFactory.create("dna:prop1"), new Object[]{"value1"});
        Property prop2 = this.propertyFactory.create((Name)this.nameFactory.create("dna:prop2"), new Object[]{"value1"});
        Path pathA = (Path)this.pathFactory.create("/a");
        BasicCreateNodeCommand createNode = new BasicCreateNodeCommand(pathA);
        createNode.setProperties(new Property[]{prop1, prop2});
        this.connection.execute(this.context, new GraphCommand[]{createNode});
        for (int i = 0; i != 20; ++i) {
            String path = i % 5 == 0 ? "/a/b" : "/a/c" + i;
            createNode = new BasicCreateNodeCommand((Path)this.pathFactory.create(path));
            createNode.setProperties(new Property[]{prop1, prop2});
            this.connection.execute(this.context, new GraphCommand[]{createNode});
        }
        Name nameB = this.pathFactory.createSegment("b").getName();
        Assert.assertThat((Object)nameB.getLocalName(), (Matcher)Is.is((Object)"b"));
        BasicGetNodeCommand getNode = new BasicGetNodeCommand(pathA);
        this.connection.execute(this.context, new GraphCommand[]{getNode});
        int index = 1;
        for (Path.Segment segment : getNode.getChildren()) {
            if (segment.getName().getLocalName().equals("b")) {
                Assert.assertThat((Object)segment.getName(), (Matcher)Is.is((Object)nameB));
                Assert.assertThat((Object)segment.hasIndex(), (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)segment.getIndex(), (Matcher)Is.is((Object)index));
                ++index;
                continue;
            }
            Assert.assertThat((Object)segment.hasIndex(), (Matcher)Is.is((Object)false));
        }
    }
}

