/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jbosscache;

import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.dna.connector.jbosscache.JBossCacheRequestProcessor;
import org.jboss.dna.connector.jbosscache.JBossCacheWorkspaces;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;

public class JBossCacheRequestProcessorTest {
    private JBossCacheRequestProcessor processor;
    private JBossCacheWorkspaces workspaces;
    private Set<String> initialWorkspaceNames;
    private String defaultWorkspaceName;
    private String defaultConfigName;
    private CacheFactory<Name, Object> cacheFactory;
    private ExecutionContext context;
    private PathFactory pathFactory;
    @MockitoAnnotations.Mock
    private Context jndi;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("dna", "http://www.jboss.org/dna/1.0");
        this.context.getNamespaceRegistry().register("dnajbcc", "http://www.jboss.org/dna/connector/jbosscache");
        this.cacheFactory = new DefaultCacheFactory();
        this.defaultConfigName = null;
        this.initialWorkspaceNames = new HashSet<String>();
        this.initialWorkspaceNames.add("workspace1");
        this.initialWorkspaceNames.add("workspace2");
        this.defaultWorkspaceName = this.initialWorkspaceNames.iterator().next();
        this.workspaces = new JBossCacheWorkspaces("source", this.cacheFactory, this.defaultConfigName, this.initialWorkspaceNames, this.jndi);
        this.processor = new JBossCacheRequestProcessor("source", this.context, null, this.workspaces, this.defaultWorkspaceName, true);
        this.pathFactory = this.context.getValueFactories().getPathFactory();
    }

    @Test
    public void shouldCreateFullyQualifiedNodeOfPathSegmentsFromPath() {
        Path path = (Path)this.pathFactory.create("/a/b/c/d");
        Fqn fqn = this.processor.getFullyQualifiedName(path);
        Assert.assertThat((Object)fqn.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)fqn.isRoot(), (Matcher)Is.is((Object)false));
        for (int i = 0; i != path.size(); ++i) {
            Assert.assertThat((Object)((Path.Segment)fqn.get(i)), (Matcher)Is.is((Object)path.getSegment(i)));
        }
    }

    @Test
    public void shouldCreateFullyQualifiedNodeOfPathSegmentsFromRootPath() {
        Path path = this.pathFactory.createRootPath();
        Fqn fqn = this.processor.getFullyQualifiedName(path);
        Assert.assertThat((Object)fqn.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)fqn.isRoot(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateFullyQualifiedNodeFromPathSegment() {
        Path.Segment segment = this.pathFactory.createSegment("a");
        Fqn fqn = this.processor.getFullyQualifiedName(segment);
        Assert.assertThat((Object)fqn.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)fqn.isRoot(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)((Path.Segment)fqn.get(0)), (Matcher)Is.is((Object)segment));
    }

    @Test
    public void shouldCreatePathFromFullyQualifiedNode() {
        Path path = (Path)this.pathFactory.create("/a/b/c/d");
        Fqn fqn = this.processor.getFullyQualifiedName(path);
        Assert.assertThat((Object)this.processor.getPath(this.pathFactory, fqn), (Matcher)Is.is((Object)path));
    }

    @Test
    public void shouldCreateRootPathFromRootFullyQualifiedNode() {
        Path path = this.pathFactory.createRootPath();
        Fqn fqn = this.processor.getFullyQualifiedName(path);
        Assert.assertThat((Object)this.processor.getPath(this.pathFactory, fqn), (Matcher)Is.is((Object)path));
    }
}

