/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.jdbc.provider.DataSourceDatabaseMetadataProvider;
import org.jboss.dna.common.jdbc.provider.DefaultDataSourceDatabaseMetadataProvider;
import org.jboss.dna.common.jdbc.provider.DefaultDriverDatabaseMetadataProvider;
import org.jboss.dna.common.jdbc.provider.DriverDatabaseMetadataProvider;
import org.jboss.dna.connector.jdbc.JdbcConnection;
import org.jboss.dna.connector.jdbc.JdbcMetadataI18n;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.RepositorySourceCapabilities;
import org.jboss.dna.graph.connector.RepositorySourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcRepositorySource
implements RepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 3380130639143030018L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final boolean DEFAULT_SUPPORTS_UPDATES = true;
    public static final String DEFAULT_ROOT_NODE_UUID = "9f9a52c8-0a4d-40d0-ac58-7c77b24b3155";
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = false;
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    protected String name;
    protected final Capabilities capabilities = new Capabilities();
    protected transient RepositoryContext repositoryContext;
    protected CachePolicy defaultCachePolicy;
    protected transient DriverDatabaseMetadataProvider driverProvider;
    protected transient DataSourceDatabaseMetadataProvider dataSourceProvider;
    protected transient UUID rootUuid = UUID.fromString("9f9a52c8-0a4d-40d0-ac58-7c77b24b3155");
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String ROOT_NODE_UUID = "rootNodeUuid";
    protected static final String DEFAULT_CACHE_POLICY = "defaultCachePolicy";
    protected static final String DATA_SOURCE_JNDI_NAME = "dataSourceJndiName";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    protected static final String URL = "url";
    protected static final String DRIVER_CLASS_NAME = "driverClassName";
    protected static final String RETRY_LIMIT = "retryLimit";

    protected DriverDatabaseMetadataProvider getDriverProvider(boolean create) {
        if (this.driverProvider == null) {
            this.driverProvider = new DefaultDriverDatabaseMetadataProvider();
        }
        return this.driverProvider;
    }

    protected DataSourceDatabaseMetadataProvider getDataSourceProvider(boolean create) {
        if (this.dataSourceProvider == null && create) {
            this.dataSourceProvider = new DefaultDataSourceDatabaseMetadataProvider();
        }
        return this.dataSourceProvider;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        String errMsg = null;
        if (this.getName() == null) {
            errMsg = JdbcMetadataI18n.propertyIsRequired.text(new Object[]{"name"});
            throw new RepositorySourceException(errMsg);
        }
        try {
            if (this.dataSourceProvider != null) {
                return new JdbcConnection(this.getName(), this.getDefaultCachePolicy(), this.dataSourceProvider.getConnection(), this.rootUuid);
            }
        }
        catch (Exception e) {
            errMsg = JdbcMetadataI18n.unableToGetConnectionUsingDriver.text(new Object[]{this.getName(), this.getDriverClassName(), this.getDatabaseUrl()});
            throw new RepositorySourceException(errMsg, (Throwable)e);
        }
        try {
            if (this.driverProvider != null) {
                return new JdbcConnection(this.getName(), this.getDefaultCachePolicy(), this.driverProvider.getConnection(), this.rootUuid);
            }
        }
        catch (Exception e) {
            errMsg = JdbcMetadataI18n.unableToGetConnectionUsingDataSource.text(new Object[]{this.getName(), this.getDataSourceName()});
            throw new RepositorySourceException(errMsg, (Throwable)e);
        }
        errMsg = JdbcMetadataI18n.oneOfPropertiesIsRequired.text(new Object[]{this.getName()});
        throw new RepositorySourceException(errMsg);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public boolean getSupportsUpdates() {
        return this.capabilities.supportsUpdates();
    }

    public synchronized void setSupportsUpdates(boolean supportsUpdates) {
        this.capabilities.setSupportsUpdates(supportsUpdates);
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public synchronized void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public String getRootNodeUuid() {
        return this.rootUuid != null ? this.rootUuid.toString() : null;
    }

    public void setRootNodeUuid(String rootNodeUuid) {
        if (rootNodeUuid != null && rootNodeUuid.trim().length() == 0) {
            rootNodeUuid = DEFAULT_ROOT_NODE_UUID;
        }
        this.rootUuid = UUID.fromString(rootNodeUuid);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JdbcRepositorySource) {
            JdbcRepositorySource that = (JdbcRepositorySource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public String getDriverClassName() {
        DriverDatabaseMetadataProvider provider = this.getDriverProvider(false);
        return provider != null ? provider.getDriverClassName() : null;
    }

    public void setDriverClassName(String driverClassName) {
        if (driverClassName == null) {
            this.driverProvider = null;
        } else {
            DriverDatabaseMetadataProvider provider = this.getDriverProvider(true);
            provider.setDriverClassName(driverClassName);
        }
    }

    public String getDatabaseUrl() {
        DriverDatabaseMetadataProvider provider = this.getDriverProvider(false);
        return provider != null ? provider.getDatabaseUrl() : null;
    }

    public void setDatabaseUrl(String databaseUrl) {
        if (databaseUrl == null) {
            this.driverProvider = null;
        } else {
            DriverDatabaseMetadataProvider provider = this.getDriverProvider(true);
            provider.setDatabaseUrl(databaseUrl);
        }
    }

    public String getUserName() {
        DriverDatabaseMetadataProvider provider = this.getDriverProvider(false);
        return provider != null ? provider.getUserName() : null;
    }

    public void setUserName(String userName) {
        if (userName == null) {
            this.driverProvider = null;
        } else {
            DriverDatabaseMetadataProvider provider = this.getDriverProvider(true);
            provider.setUserName(userName);
        }
    }

    public String getPassword() {
        DriverDatabaseMetadataProvider provider = this.getDriverProvider(false);
        return provider != null ? provider.getPassword() : null;
    }

    public void setPassword(String password) {
        if (password == null) {
            this.driverProvider = null;
        } else {
            DriverDatabaseMetadataProvider provider = this.getDriverProvider(true);
            provider.setPassword(password);
        }
    }

    public String getDataSourceName() {
        DataSourceDatabaseMetadataProvider provider = this.getDataSourceProvider(false);
        return provider != null ? provider.getDataSourceName() : null;
    }

    public void setDataSourceName(String dataSourceName) {
        if (dataSourceName == null) {
            this.dataSourceProvider = null;
        } else {
            DataSourceDatabaseMetadataProvider provider = this.getDataSourceProvider(true);
            provider.setDataSourceName(dataSourceName);
        }
    }

    public Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        if (this.getRootNodeUuid() != null) {
            ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuid()));
        }
        if (this.getDataSourceName() != null) {
            ref.add(new StringRefAddr(DATA_SOURCE_JNDI_NAME, this.getDataSourceName()));
        }
        if (this.getUserName() != null) {
            ref.add(new StringRefAddr(USERNAME, this.getUserName()));
        }
        if (this.getPassword() != null) {
            ref.add(new StringRefAddr(PASSWORD, this.getPassword()));
        }
        if (this.getDatabaseUrl() != null) {
            ref.add(new StringRefAddr(URL, this.getDatabaseUrl()));
        }
        if (this.getDriverClassName() != null) {
            ref.add(new StringRefAddr(DRIVER_CLASS_NAME, this.getDriverClassName()));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = JdbcMetadataI18n.errorSerializingCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String rootNodeUuid = (String)values.get(ROOT_NODE_UUID);
            String dataSourceJndiName = (String)values.get(DATA_SOURCE_JNDI_NAME);
            String userName = (String)values.get(USERNAME);
            String password = (String)values.get(PASSWORD);
            String url = (String)values.get(URL);
            String driverClassName = (String)values.get(DRIVER_CLASS_NAME);
            Object defaultCachePolicy = values.get(DEFAULT_CACHE_POLICY);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            JdbcRepositorySource source = new JdbcRepositorySource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuid != null) {
                source.setRootNodeUuid(rootNodeUuid);
            }
            if (dataSourceJndiName != null) {
                source.setDataSourceName(dataSourceJndiName);
            }
            if (userName != null) {
                source.setUserName(userName);
            }
            if (password != null) {
                source.setPassword(password);
            }
            if (url != null) {
                source.setDatabaseUrl(url);
            }
            if (driverClassName != null) {
                source.setDriverClassName(driverClassName);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            return source;
        }
        return null;
    }

    @ThreadSafe
    protected class Capabilities
    extends RepositorySourceCapabilities {
        private final AtomicBoolean supportsUpdates;

        Capabilities() {
            super(true, true);
            this.supportsUpdates = new AtomicBoolean(true);
        }

        void setSupportsUpdates(boolean supportsUpdates) {
            this.supportsUpdates.set(supportsUpdates);
        }

        public boolean supportsUpdates() {
            return this.supportsUpdates.get();
        }
    }
}

