/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.connector.meta.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.connector.meta.jdbc.JdbcMetadataCollector;
import org.jboss.dna.connector.meta.jdbc.JdbcMetadataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlServerMetadataCollector
extends JdbcMetadataCollector {
    @Override
    public List<String> getSchemaNames(Connection conn, String catalogName) throws JdbcMetadataException {
        Statement stmt = null;
        ResultSet rs = null;
        LinkedList<String> schemaNames = new LinkedList<String>();
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT name AS TABLE_SCHEM FROM sys.schemas ORDER BY TABLE_SCHEM");
            while (rs.next()) {
                schemaNames.add(rs.getString("TABLE_SCHEM"));
            }
            LinkedList<String> linkedList = schemaNames;
            return linkedList;
        }
        catch (SQLException se) {
            throw new JdbcMetadataException(se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignore) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ignore) {}
        }
    }
}

