/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.observation;

import java.util.HashSet;
import java.util.Set;
import org.jboss.dna.repository.observation.NodeChange;
import org.junit.Before;
import org.junit.Test;

public class NodeChangeTest {
    private String validRepositoryWorkspaceName;
    private String validAbsolutePath;
    private int validEventTypes;
    private Set<String> validModifiedProperties;
    private Set<String> validRemovedProperties;
    private NodeChange nodeChange;

    @Before
    public void beforeEach() throws Exception {
        this.validRepositoryWorkspaceName = "repositoryX";
        this.validAbsolutePath = "/a/b/c/d";
        this.validEventTypes = 29;
        this.validModifiedProperties = new HashSet<String>();
        this.validRemovedProperties = new HashSet<String>();
        this.validModifiedProperties.add("jcr:name");
        this.validModifiedProperties.add("jcr:title");
        this.validRemovedProperties.add("jcr:mime");
        this.nodeChange = new NodeChange(this.validRepositoryWorkspaceName, this.validAbsolutePath, this.validEventTypes, this.validModifiedProperties, this.validRemovedProperties);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldHaveUnmodifiableSetOfModifiedPropertyNames() {
        this.nodeChange.getModifiedProperties().clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldHaveUnmodifiableSetOfRemovedPropertyNames() {
        this.nodeChange.getRemovedProperties().clear();
    }
}

