/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.rules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.ComponentConfig;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.repository.rules.InvalidRuleSetException;
import org.jboss.dna.repository.rules.RuleInput;
import org.jboss.dna.repository.rules.RuleResult;
import org.jboss.dna.repository.rules.RuleService;
import org.jboss.dna.repository.rules.RuleSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleServiceTest {
    protected static final String DROOLS_PROVIDER_CLASSNAME = "org.drools.jsr94.rules.RuleServiceProviderImpl";
    protected static final String DROOLS_PROVIDER_URI = "http://drools.org/";
    private RuleService ruleService;
    private ClassLoaderFactory classLoaderFactory;

    protected RuleSet createDroolsRuleSet(String desc) throws IOException {
        String name = "SampleRuleSet";
        String description = desc != null ? desc : "This is a sample rule set that uses Drools";
        String providerClassname = DROOLS_PROVIDER_CLASSNAME;
        String providerUri = DROOLS_PROVIDER_URI;
        String[] providerClasspath = new String[]{};
        String ruleSetUri = null;
        URL ruleFile = this.getClass().getResource("/rule_test.dslr");
        URL dslFile = this.getClass().getResource("/rule_test.dsl");
        String rules = IoUtil.read((InputStream)ruleFile.openStream());
        byte[] dslBytes = IoUtil.readBytes((InputStream)dslFile.openStream());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.rules.admin.RuleExecutionSet.source", "drl");
        properties.put("javax.rules.admin.RuleExecutionSet.dsl", dslBytes);
        return new RuleSet(name, description, providerClassname, providerClasspath, providerUri, ruleSetUri, rules, properties);
    }

    protected RuleSet createRuleSetWithInvalidProvider() throws IOException {
        String name = "SampleRuleSet";
        String description = "This is a sample rule set that uses Drools";
        String providerClassname = DROOLS_PROVIDER_CLASSNAME;
        String providerUri = "http://drools.org/this/is/incorrect";
        String[] providerClasspath = new String[]{};
        String ruleSetUri = null;
        URL ruleFile = this.getClass().getResource("/rule_test.dslr");
        URL dslFile = this.getClass().getResource("/rule_test.dsl");
        String rules = IoUtil.read((InputStream)ruleFile.openStream());
        byte[] dslBytes = IoUtil.readBytes((InputStream)dslFile.openStream());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.rules.admin.RuleExecutionSet.source", "drl");
        properties.put("javax.rules.admin.RuleExecutionSet.dsl", dslBytes);
        return new RuleSet(name, description, providerClassname, providerClasspath, providerUri, ruleSetUri, rules, properties);
    }

    @Before
    public void beforeEach() throws Exception {
        this.ruleService = new RuleService();
        this.classLoaderFactory = new StandardClassLoaderFactory();
    }

    @After
    public void afterEach() throws Exception {
        this.ruleService.getAdministrator().shutdown();
    }

    @Test
    public void shouldHaveDefaultClasspathFactoryUponConstruction() {
        Assert.assertThat((Object)this.ruleService.getClassLoaderFactory(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.ruleService.getClassLoaderFactory(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)RuleService.DEFAULT_CLASSLOADER_FACTORY)));
    }

    @Test
    public void shouldHaveLoggerUponConstruction() {
        Assert.assertThat((Object)this.ruleService.getLogger(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveEmptyRuleSetCollectionUponConstruction() {
        Assert.assertThat((Object)this.ruleService.getRuleSets(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.ruleService.getRuleSets().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnUnmodifiableCollectionOfRuleSets() {
        this.ruleService.getRuleSets().add(null);
    }

    @Test
    public void shouldSetClassLoaderFactoryToDefaultWhenPassedNull() {
        Assert.assertThat((Object)this.ruleService.getClassLoaderFactory(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)RuleService.DEFAULT_CLASSLOADER_FACTORY)));
        this.ruleService.setClassLoaderFactory(this.classLoaderFactory);
        Assert.assertThat((Object)this.ruleService.getClassLoaderFactory(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.classLoaderFactory)));
        this.ruleService.setClassLoaderFactory(null);
        Assert.assertThat((Object)this.ruleService.getClassLoaderFactory(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)RuleService.DEFAULT_CLASSLOADER_FACTORY)));
    }

    @Test
    public void shouldSetLoggerToDefaultWhenPassedNull() {
        Logger defaultLogger = this.ruleService.getLogger();
        Assert.assertThat((Object)this.ruleService.getLogger(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Logger orgLogger = Logger.getLogger((String)"org");
        this.ruleService.setLogger(orgLogger);
        Assert.assertThat((Object)this.ruleService.getLogger().getName(), (Matcher)Is.is((Object)orgLogger.getName()));
        Assert.assertThat((Object)this.ruleService.getLogger(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)orgLogger)));
        this.ruleService.setLogger(null);
        Assert.assertThat((Object)this.ruleService.getLogger().getName(), (Matcher)Is.is((Object)defaultLogger.getName()));
        Assert.assertThat((Object)this.ruleService.getLogger(), (Matcher)Is.is((Matcher)IsNot.not((Object)orgLogger)));
    }

    @Test(expected=InvalidRuleSetException.class)
    public void shouldNotAddInvalidRuleSet() throws Exception {
        this.ruleService.addRuleSet(this.createRuleSetWithInvalidProvider());
    }

    @Test
    public void shouldAddValidRuleSet() throws Exception {
        int numRuleSetsBefore = this.ruleService.getRuleSets().size();
        RuleSet validRuleSet = this.createDroolsRuleSet(null);
        Assert.assertThat((Object)this.ruleService.addRuleSet(validRuleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ruleService.getRuleSets().size(), (Matcher)Is.is((Object)(numRuleSetsBefore + 1)));
    }

    @Test
    public void shouldNotUpdateValidRuleSetWithInvalidRuleSet() throws Exception {
        RuleSet validRuleSet = this.createDroolsRuleSet(null);
        String ruleSetName = validRuleSet.getName();
        Assert.assertThat((Object)this.ruleService.addRuleSet(validRuleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ruleService.getRuleSets().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(this.ruleService.getRuleSets().iterator().next(), (Matcher)Is.is((Object)validRuleSet));
        this.executeRuleSet(ruleSetName);
        RuleSet invalidRuleSet = this.createRuleSetWithInvalidProvider();
        Assert.assertThat((Object)invalidRuleSet.getName(), (Matcher)Is.is((Object)ruleSetName));
        Assert.assertThat((Object)invalidRuleSet.getName(), (Matcher)Is.is((Object)validRuleSet.getName()));
        try {
            this.ruleService.addRuleSet(invalidRuleSet);
            Assert.fail((String)"Should not get here");
        }
        catch (InvalidRuleSetException e) {
            // empty catch block
        }
        Assert.assertThat((Object)this.ruleService.getRuleSets().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(this.ruleService.getRuleSets().iterator().next(), (Matcher)Is.is((Object)validRuleSet));
        this.executeRuleSet(ruleSetName);
    }

    @Test
    public void shouldModifyExistingRuleSetWhenAddedOnlyWhenChanged() throws Exception {
        int numRuleSetsBefore = this.ruleService.getRuleSets().size();
        RuleSet validRuleSet = this.createDroolsRuleSet(null);
        Assert.assertThat((Object)this.ruleService.addRuleSet(validRuleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ruleService.getRuleSets().size(), (Matcher)Is.is((Object)(numRuleSetsBefore + 1)));
        RuleSet validRuleSet2 = this.createDroolsRuleSet(null);
        Assert.assertThat((Object)validRuleSet2.hasChanged((ComponentConfig)validRuleSet), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.ruleService.addRuleSet(validRuleSet2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.ruleService.getRuleSets().size(), (Matcher)Is.is((Object)(numRuleSetsBefore + 1)));
        RuleSet validRuleSet3 = this.createDroolsRuleSet("This is an alternative description that causes it to be changed");
        Assert.assertThat((Object)validRuleSet3.hasChanged((ComponentConfig)validRuleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ruleService.addRuleSet(validRuleSet3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.ruleService.getRuleSets().size(), (Matcher)Is.is((Object)(numRuleSetsBefore + 1)));
    }

    @Test
    public void shouldExecuteRuleSet() throws Exception {
        RuleSet validRuleSet = this.createDroolsRuleSet(null);
        Assert.assertThat((Object)this.ruleService.addRuleSet(validRuleSet), (Matcher)Is.is((Object)true));
        this.executeRuleSet(validRuleSet.getName());
    }

    protected void executeRuleSet(String ruleSetName) {
        RuleInput info = new RuleInput();
        info.setFileName("someOtherInput.dsl");
        info.setHeader("This is the sequencer header");
        info.setMimeType("text");
        LinkedHashSet output = new LinkedHashSet();
        HashMap globals = new HashMap();
        globals.put("output", output);
        List results = this.ruleService.executeRules(ruleSetName, globals, new Object[]{info});
        Assert.assertThat((Object)results, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)results.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)2));
        Assert.assertTrue((results.get(0) instanceof RuleResult || results.get(1) instanceof RuleResult ? 1 : 0) != 0);
        Assert.assertThat((Object)output.isEmpty(), (Matcher)Is.is((Object)false));
        Object sequencer = output.iterator().next();
        Assert.assertThat(sequencer, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(String.class)));
        Assert.assertThat((Object)((String)sequencer), (Matcher)Is.is((Object)"A"));
    }
}

