/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.rules;

import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.jboss.dna.common.component.ComponentConfig;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.repository.rules.RuleSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleSetTest {
    private RuleSet ruleSet;
    private String validName;
    private String validDescription;
    private String validClassname;
    private String[] validClasspath;
    private String validProviderUri;
    private String validRuleSetUri;
    private String validRules;
    private Map<String, Object> validProperties;

    @Before
    public void beforeEach() throws Exception {
        this.validName = "This is a valid name";
        this.validDescription = "This is a valid description";
        this.validClassname = "com.acme.SuperDuper";
        this.validClasspath = new String[]{"classpath1", "classpath2"};
        this.validProviderUri = "http://www.acme.com/super/duper/rules_engine";
        this.validRuleSetUri = "com.something.whatever doesn't really need to be a URI";
        this.validRules = "when something is true then cheer";
        this.validProperties = new HashMap<String, Object>();
        this.validProperties.put("key1", "value1");
        this.validProperties.put("key2", null);
        this.validProperties.put("key3", "value3".getBytes());
        this.ruleSet = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullName() {
        new RuleSet(null, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyName() {
        new RuleSet("", this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankName() {
        new RuleSet("  \t ", this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test
    public void shouldTrimName() {
        this.validName = "  this is a valid name with leading and trailing whitespace  ";
        this.ruleSet = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getName(), (Matcher)Is.is((Object)this.validName.trim()));
    }

    @Test
    public void shouldAllowNullOrEmptyOrBlankDescriptionAndShouldReplaceWithEmptyString() {
        this.ruleSet = new RuleSet(this.validName, null, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getDescription(), (Matcher)Is.is((Object)""));
        this.ruleSet = new RuleSet(this.validName, "", this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getDescription(), (Matcher)Is.is((Object)""));
        this.ruleSet = new RuleSet(this.validName, "  \t ", this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getDescription(), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldTrimDescription() {
        this.ruleSet = new RuleSet(this.validName, "  valid ", this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getDescription(), (Matcher)Is.is((Object)"valid"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullClassname() {
        new RuleSet(this.validName, this.validDescription, null, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyClassname() {
        new RuleSet(this.validName, this.validDescription, "", this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankClassname() {
        new RuleSet(this.validName, this.validDescription, "   ", this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowClassnameThatDoesNotFollowJavaNamingRules() {
        new RuleSet(this.validName, this.validDescription, "not a valid classname", this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test
    public void shouldAllowNullOrEmptyClasspath() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, null, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test
    public void shouldRemoveNullOrBlankClasspathItems() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, new String[0], this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test
    public void shouldRemoveDuplicateClasspathItemsInCaseSensitiveManner() {
        this.validClasspath = new String[]{"path1", "path2", "path1", "path3", "path2"};
        this.ruleSet = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getComponentClasspathArray(), (Matcher)Is.is((Object)new String[]{"path1", "path2", "path3"}));
        this.validClasspath = new String[]{"path1", "path2", "path1", "path3", "Path2"};
        this.ruleSet = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getComponentClasspathArray(), (Matcher)Is.is((Object)new String[]{"path1", "path2", "path3", "Path2"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullProviderUri() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, null, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyProviderUri() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, "", this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankProviderUri() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, "  \t  ", this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test
    public void shouldUseNameInPlaceOfNullRuleSetUri() {
        this.ruleSet = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, null, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getRuleSetUri(), (Matcher)Is.is((Object)this.ruleSet.getName()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyRuleSetUri() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, "", this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankRuleSetUri() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, "  \t  ", this.validRules, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullRules() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, null, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyRules() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, "", this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowBlankRules() {
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, "   \t  ", this.validProperties);
    }

    @Test
    public void shouldAllowNullOrEmptyProperties() {
        this.validProperties = null;
        this.ruleSet = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)this.ruleSet.getProperties(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldWrapByteArrayPropertyValuesWithInputStreamInExecutionSetProperties() throws Exception {
        Map executionSetProps = this.ruleSet.getExecutionSetProperties();
        Assert.assertThat((Object)executionSetProps.size(), (Matcher)Is.is((Object)this.ruleSet.getProperties().size()));
        Assert.assertThat(executionSetProps.keySet(), (Matcher)Is.is(new HashSet(this.ruleSet.getProperties().keySet())));
        Iterator executionSetPropIter = executionSetProps.entrySet().iterator();
        Iterator propIter = this.ruleSet.getProperties().entrySet().iterator();
        while (executionSetPropIter.hasNext() && propIter.hasNext()) {
            Map.Entry execSetEntry = executionSetPropIter.next();
            Object execSetKey = execSetEntry.getKey();
            Object execSetValue = execSetEntry.getValue();
            Map.Entry propertyEntry = propIter.next();
            String propertyKey = (String)propertyEntry.getKey();
            Object propertyValue = propertyEntry.getValue();
            Assert.assertThat(execSetKey, (Matcher)Is.is((Object)propertyKey));
            if (propertyValue instanceof byte[]) {
                Assert.assertThat(execSetValue, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Reader.class)));
                String streamValueAsString = IoUtil.read((Reader)((Reader)execSetValue));
                String propertyValueAsString = new String((byte[])propertyValue);
                Assert.assertThat((Object)streamValueAsString, (Matcher)Is.is((Object)propertyValueAsString));
                continue;
            }
            Assert.assertThat(execSetValue, (Matcher)Is.is(propertyValue));
        }
        Assert.assertThat((Object)executionSetPropIter.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)propIter.hasNext(), (Matcher)Is.is((Object)false));
        new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
    }

    @Test
    public void shouldConsiderAnyAttributeDifferencesAsChange() {
        RuleSet copy = this.ruleSet.clone();
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
        copy = new RuleSet(this.validName + "x", this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
        copy = new RuleSet(this.validName, this.validDescription + "x", this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname + "x", this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri + "x", this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
        this.validClasspath = new String[]{"classpath1", "classpath2x"};
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri + "x", this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules + "x", this.validProperties);
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
        this.validProperties.remove("key1");
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)this.ruleSet), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.hasChanged((ComponentConfig)copy), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderOnlyNameWhenDeterminingIfSame() {
        RuleSet copy = this.ruleSet.clone();
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)true));
        copy = new RuleSet(this.validName + "x", this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)false));
        copy = new RuleSet(this.validName, this.validDescription + "x", this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)true));
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname + "x", this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)true));
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri + "x", this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)true));
        this.validClasspath = new String[]{"classpath1", "classpath2x"};
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri + "x", this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)true));
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules + "x", this.validProperties);
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)true));
        this.validProperties.remove("key1");
        copy = new RuleSet(this.validName, this.validDescription, this.validClassname, this.validClasspath, this.validProviderUri, this.validRuleSetUri, this.validRules, this.validProperties);
        Assert.assertThat((Object)copy.equals((Object)this.ruleSet), (Matcher)Is.is((Object)true));
    }
}

