/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.i18n.MockI18n;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.repository.observation.NodeChange;
import org.jboss.dna.repository.sequencers.Sequencer;
import org.jboss.dna.repository.sequencers.SequencerConfig;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.repository.util.RepositoryNodePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class MockSequencerA
implements Sequencer {
    private SequencerConfig config;
    private AtomicInteger counter = new AtomicInteger();
    private volatile CountDownLatch latch = new CountDownLatch(0);

    public void setExpectedCount(int numExpected) {
        this.latch = new CountDownLatch(numExpected);
    }

    public boolean awaitExecution(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public void setConfiguration(SequencerConfig sequencerConfiguration) {
        this.config = sequencerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Node input, String sequencedPropertyName, NodeChange changes, Set<RepositoryNodePath> outputPaths, ExecutionContext context, ProgressMonitor progress) {
        try {
            progress.beginTask(1.0, MockI18n.passthrough, new Object[]{"Incrementing counter"});
            this.counter.incrementAndGet();
            this.latch.countDown();
            progress.worked(1.0);
        }
        finally {
            progress.done();
        }
    }

    public int getCounter() {
        return this.counter.get();
    }

    public boolean isConfigured() {
        return this.config != null;
    }

    public SequencerConfig getConfiguration() {
        return this.config;
    }

    public String toString() {
        return (this.config != null ? this.config.getName() : "SampleSequencer") + " [" + this.getCounter() + "]";
    }
}

