/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.common.jcr.AbstractJcrRepositoryTest;
import org.jboss.dna.repository.observation.NodeChangeListener;
import org.jboss.dna.repository.observation.ObservationService;
import org.jboss.dna.repository.sequencers.MockSequencerA;
import org.jboss.dna.repository.sequencers.SequencerConfig;
import org.jboss.dna.repository.sequencers.SequencingService;
import org.jboss.dna.repository.services.ServiceAdministrator;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.repository.util.MockExecutionContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public class SequencingServiceTest
extends AbstractJcrRepositoryTest {
    public static final int ALL_EVENT_TYPES = 31;
    public static final String REPOSITORY_WORKSPACE_NAME = "testRepository-Workspace";
    private ObservationService observationService;
    private SequencingService sequencingService;
    private ExecutionContext executionContext;

    @Before
    public void beforeEach() throws Exception {
        this.executionContext = new MockExecutionContext(this, REPOSITORY_WORKSPACE_NAME);
        this.sequencingService = new SequencingService();
        this.sequencingService.setExecutionContext(this.executionContext);
        this.observationService = new ObservationService(this.executionContext.getSessionFactory());
        this.observationService.addListener((NodeChangeListener)this.sequencingService);
    }

    @After
    public void afterEach() throws Exception {
        this.observationService.getAdministrator().shutdown();
        this.observationService.getAdministrator().awaitTermination(5L, TimeUnit.SECONDS);
        this.sequencingService.getAdministrator().shutdown();
        this.sequencingService.getAdministrator().awaitTermination(5L, TimeUnit.SECONDS);
        super.shutdownRepository();
    }

    @Test
    public void shouldHaveTheDefaultSelectorUponConstruction() {
        Assert.assertThat((Object)this.sequencingService.getSequencerSelector(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)SequencingService.DEFAULT_SEQUENCER_SELECTOR)));
    }

    @Test
    public void shouldHaveNoExecutorServiceUponConstruction() {
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCreateDefaultExecutorServiceWhenStartedIfNoExecutorServiceHasBeenSet() {
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.sequencingService.getAdministrator().start();
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCreateExecutorServiceWhenStarted() {
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.sequencingService.getAdministrator().start();
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToSetStateToUnknownString() {
        this.sequencingService.getAdministrator().setState("asdf");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToSetStateToNullString() {
        this.sequencingService.getAdministrator().setState((String)null);
    }

    @Test
    public void shouldSetStateUsingLowercaseString() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("started").isStarted(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("paused").isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("shutdown").isShutdown(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetStateUsingMixedCaseString() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("StarTeD").isStarted(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("PauSed").isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("ShuTDowN").isShutdown(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetStateUsingUppercasString() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("STARTED").isStarted(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("PAUSED").isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("SHUTDOWN").isShutdown(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBePausedUponConstruction() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.PAUSED));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeAbleToShutdownWhenNotStarted() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        for (int i = 0; i != 3; ++i) {
            Assert.assertThat((Object)this.sequencingService.getAdministrator().shutdown().isShutdown(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.SHUTDOWN));
        }
    }

    @Test
    public void shouldBeAbleToBePauseAndRestarted() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        for (int i = 0; i != 3; ++i) {
            Assert.assertThat((Object)this.sequencingService.getAdministrator().pause().isPaused(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.PAUSED));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().start().isStarted(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.STARTED));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToBeRestartedAfterBeingShutdown() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().shutdown().isShutdown(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.SHUTDOWN));
        this.sequencingService.getAdministrator().start();
    }

    @Test
    public void shouldBeAbleToMonitorWorkspaceWhenPausedOrStarted() throws Exception {
        this.startRepository();
        Session session = this.getRepository().login(this.getTestCredentials());
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.observationService.getAdministrator().pause().isPaused(), (Matcher)Is.is((Object)true));
        ObservationService.WorkspaceListener listener = this.observationService.monitor(REPOSITORY_WORKSPACE_NAME, 1, new String[0]);
        Assert.assertThat((Object)listener, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)listener.getAbsolutePath(), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)listener.getEventTypes(), (Matcher)Is.is((Object)1));
        session.getRootNode().addNode("testnodeA", "nt:unstructured");
        session.save();
        Thread.sleep(100L);
        Assert.assertThat((Object)this.observationService.getStatistics().getNumberOfEventsIgnored(), (Matcher)Is.is((Object)1L));
        this.sequencingService.getStatistics().reset();
        this.observationService.getStatistics().reset();
        Assert.assertThat((Object)listener.isRegistered(), (Matcher)Is.is((Object)true));
        listener.unregister();
        Assert.assertThat((Object)listener.isRegistered(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().start().isStarted(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.observationService.getAdministrator().start().isStarted(), (Matcher)Is.is((Object)true));
        ObservationService.WorkspaceListener listener2 = this.observationService.monitor(REPOSITORY_WORKSPACE_NAME, 1, new String[0]);
        Assert.assertThat((Object)listener2.isRegistered(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)listener2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)listener2.getAbsolutePath(), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)listener2.getEventTypes(), (Matcher)Is.is((Object)1));
        session.getRootNode().addNode("testnodeB", "nt:unstructured");
        session.save();
        Thread.sleep(100L);
        Assert.assertThat((Object)this.observationService.getStatistics().getNumberOfEventsIgnored(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.sequencingService.getStatistics().getNumberOfNodesSkipped(), (Matcher)Is.is((Object)1L));
        this.sequencingService.getAdministrator().shutdown();
        this.sequencingService.getStatistics().reset();
        this.observationService.getAdministrator().shutdown();
        this.observationService.getStatistics().reset();
        session.getRootNode().addNode("testnodeC", "nt:unstructured");
        session.save();
        Thread.sleep(100L);
        Assert.assertThat((Object)listener2.isRegistered(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.observationService.getStatistics().getNumberOfEventsIgnored(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)this.sequencingService.getStatistics().getNumberOfNodesSkipped(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void shouldUnregisterAllWorkspaceListenersWhenSystemIsShutdownAndNotWhenPaused() throws Exception {
        this.startRepository();
        Session session = this.getRepository().login(this.getTestCredentials());
        Assert.assertThat((Object)this.sequencingService.getAdministrator().start().isStarted(), (Matcher)Is.is((Object)true));
        ObservationService.WorkspaceListener listener = this.observationService.monitor(REPOSITORY_WORKSPACE_NAME, 1, new String[0]);
        Assert.assertThat((Object)listener.isRegistered(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)listener, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)listener.getAbsolutePath(), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)listener.getEventTypes(), (Matcher)Is.is((Object)1));
        session.getRootNode().addNode("testnodeB", "nt:unstructured");
        session.save();
        Assert.assertThat((Object)listener.isRegistered(), (Matcher)Is.is((Object)true));
        this.sequencingService.getAdministrator().pause();
        session.getRootNode().addNode("testnodeB", "nt:unstructured");
        session.save();
        Assert.assertThat((Object)listener.isRegistered(), (Matcher)Is.is((Object)true));
        this.sequencingService.getAdministrator().shutdown();
        this.observationService.getAdministrator().shutdown();
        this.sequencingService.getAdministrator().awaitTermination(2L, TimeUnit.SECONDS);
        this.observationService.getAdministrator().awaitTermination(2L, TimeUnit.SECONDS);
        session.getRootNode().addNode("testnodeC", "nt:unstructured");
        session.save();
        Assert.assertThat((Object)listener.isRegistered(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldExecuteSequencersUponChangesToRepositoryThatMatchSequencerPathExpressions() throws Exception {
        String name = "MockSequencerA";
        String desc = "A mock sequencer that accumulates the number of times it's called";
        String classname = MockSequencerA.class.getName();
        String[] classpath = null;
        String[] pathExpressions = new String[]{"/testnodeC/testnodeD/@description => ."};
        SequencerConfig configA = new SequencerConfig(name, desc, classname, classpath, pathExpressions);
        this.sequencingService.addSequencer(configA);
        this.startRepository();
        Session session = this.getRepository().login(this.getTestCredentials());
        Assert.assertThat((Object)this.sequencingService.getAdministrator().start().isStarted(), (Matcher)Is.is((Object)true));
        ObservationService.WorkspaceListener listener = this.observationService.monitor(REPOSITORY_WORKSPACE_NAME, 31, new String[0]);
        Assert.assertThat((Object)listener.isRegistered(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)listener, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)listener.getAbsolutePath(), (Matcher)Is.is((Object)"/"));
        Assert.assertThat((Object)listener.getEventTypes(), (Matcher)Is.is((Object)31));
        MockSequencerA sequencerA = (MockSequencerA)this.sequencingService.getSequencerLibrary().getInstances().get(0);
        Assert.assertThat((Object)sequencerA, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)0));
        sequencerA.setExpectedCount(1);
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
        Node nodeC = session.getRootNode().addNode("testnodeC", "nt:unstructured");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        session.save();
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
        Node nodeD = nodeC.addNode("testnodeD", "nt:unstructured");
        Assert.assertThat((Object)nodeD, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        session.save();
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
        nodeD.setProperty("description", "This is the value");
        session.save();
        sequencerA.awaitExecution(4L, TimeUnit.SECONDS);
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
    }
}

