/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.common.jcr.AbstractJcrRepositoryTest;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.monitor.RecordingProgressMonitor;
import org.jboss.dna.repository.observation.NodeChange;
import org.jboss.dna.repository.sequencers.SequencerConfig;
import org.jboss.dna.repository.sequencers.SequencerException;
import org.jboss.dna.repository.sequencers.SequencerOutputMap;
import org.jboss.dna.repository.sequencers.StreamSequencerAdapter;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.repository.util.JcrTools;
import org.jboss.dna.repository.util.RepositoryNodePath;
import org.jboss.dna.repository.util.SessionFactory;
import org.jboss.dna.spi.sequencers.SequencerOutput;
import org.jboss.dna.spi.sequencers.StreamSequencer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamSequencerAdapterTest
extends AbstractJcrRepositoryTest {
    private StreamSequencer streamSequencer;
    private StreamSequencerAdapter sequencer;
    private String[] validExpressions = new String[]{"/a/* => /output"};
    private SequencerConfig validConfig = new SequencerConfig("name", "desc", "something.class", null, this.validExpressions);
    private JcrTools tools;
    private Session session;
    private SequencerOutputMap sequencerOutput;
    private String sampleData = "The little brown fox didn't something bad.";
    private ExecutionContext context;
    private RecordingProgressMonitor progressMonitor;
    private String repositoryWorkspaceName = "something";

    @Before
    public void beforeEach() throws Exception {
        JcrTools tools;
        this.tools = tools = new JcrTools();
        this.sequencerOutput = new SequencerOutputMap();
        this.progressMonitor = new RecordingProgressMonitor(StreamSequencerAdapterTest.class.getName());
        final SessionFactory sessionFactory = new SessionFactory(){

            public Session createSession(String name) {
                return StreamSequencerAdapterTest.this.createTestSession();
            }
        };
        this.context = new ExecutionContext(){

            public SessionFactory getSessionFactory() {
                return sessionFactory;
            }

            public JcrTools getTools() {
                return tools;
            }
        };
        final SequencerOutputMap finalOutput = this.sequencerOutput;
        this.streamSequencer = new StreamSequencer(){

            public void sequence(InputStream stream, SequencerOutput output, ProgressMonitor progressMonitor) {
                for (SequencerOutputMap.Entry entry : finalOutput) {
                    String nodePath = entry.getPath().getString();
                    for (SequencerOutputMap.PropertyValue property : entry.getPropertyValues()) {
                        output.setProperty(nodePath, property.getName(), new Object[]{property.getValue()});
                    }
                }
            }
        };
        this.sequencer = new StreamSequencerAdapter(this.streamSequencer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            finally {
                this.session = null;
            }
        }
    }

    protected Session createTestSession() {
        try {
            return this.getRepository().login(this.getTestCredentials());
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to create repository session: " + e.getMessage()));
            return null;
        }
    }

    @Test
    public void shouldNotHaveSequencerUponInstantiation() {
        Assert.assertThat((Object)this.sequencer.getConfiguration(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.sequencer.setConfiguration(this.validConfig);
        Assert.assertThat((Object)this.sequencer.getConfiguration(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validConfig)));
    }

    @Test
    public void shouldExtractNullMixinTypesFromNullValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes(null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldExtractMixinTypesFromStringValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)"value"), (Matcher)Is.is((Object)new String[]{"value"}));
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)""), (Matcher)Is.is((Object)new String[]{""}));
    }

    @Test
    public void shouldExtractMixinTypesFromStringArrayValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)new String[]{"value1"}), (Matcher)Is.is((Object)new String[]{"value1"}));
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)new String[]{"value1", "value2"}), (Matcher)Is.is((Object)new String[]{"value1", "value2"}));
    }

    @Test
    public void shouldExtractMixinTypesFromStringArrayWithNullValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)new String[]{"value1", null, "value2"}), (Matcher)Is.is((Object)new String[]{"value1", null, "value2"}));
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToExistingNode() throws Exception {
        this.startRepository();
        this.session = this.getRepository().login(this.getTestCredentials());
        Node nodeC = this.tools.findOrCreateNode(this.session, "/a/b/c");
        Node nodeE = this.tools.findOrCreateNode(this.session, "/d/e");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)nodeE.getProperties().getSize(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)nodeE.getProperty("jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:unstructured"));
        nodeC.setProperty("sequencedProperty", (InputStream)new ByteArrayInputStream(this.sampleData.getBytes()));
        NodeChange nodeChange = new NodeChange(this.repositoryWorkspaceName, nodeC.getPath(), 16, Collections.singleton("sequencedProperty"), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, nodeE.getPath()));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.context, (ProgressMonitor)this.progressMonitor);
    }

    @Test(expected=SequencerException.class)
    public void shouldExecuteSequencerOnExistingNodeWithMissingSequencedPropertyAndOutputToExistingNode() throws Exception {
        this.startRepository();
        this.session = this.getRepository().login(this.getTestCredentials());
        Node nodeC = this.tools.findOrCreateNode(this.session, "/a/b/c");
        Node nodeE = this.tools.findOrCreateNode(this.session, "/d/e");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)nodeE.getProperties().getSize(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)nodeE.getProperty("jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:unstructured"));
        nodeC.setProperty("sequencedProperty", (InputStream)null);
        NodeChange nodeChange = new NodeChange(this.repositoryWorkspaceName, nodeC.getPath(), 16, Collections.singleton("sequencedProperty"), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, nodeE.getPath()));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.context, (ProgressMonitor)this.progressMonitor);
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToMultipleExistingNodes() throws Exception {
        this.startRepository();
        this.session = this.getRepository().login(this.getTestCredentials());
        Node nodeC = this.tools.findOrCreateNode(this.session, "/a/b/c");
        Node nodeE = this.tools.findOrCreateNode(this.session, "/d/e");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)nodeE.getProperties().getSize(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)nodeE.getProperty("jcr:primaryType").getString(), (Matcher)Is.is((Object)"nt:unstructured"));
        nodeC.setProperty("sequencedProperty", (InputStream)new ByteArrayInputStream(this.sampleData.getBytes()));
        NodeChange nodeChange = new NodeChange(this.repositoryWorkspaceName, nodeC.getPath(), 16, Collections.singleton("sequencedProperty"), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, "/d/e"));
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, "/x/y/z"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.context, (ProgressMonitor)this.progressMonitor);
        Assert.assertThat((Object)this.session.getRootNode().hasNode("d/e"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getRootNode().hasNode("x/y/z"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToNonExistingNode() throws Exception {
        this.startRepository();
        this.session = this.getRepository().login(this.getTestCredentials());
        Node nodeC = this.tools.findOrCreateNode(this.session, "/a/b/c");
        Assert.assertThat((Object)this.session.getRootNode().hasNode("d"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        nodeC.setProperty("sequencedProperty", (InputStream)new ByteArrayInputStream(this.sampleData.getBytes()));
        NodeChange nodeChange = new NodeChange(this.repositoryWorkspaceName, nodeC.getPath(), 16, Collections.singleton("sequencedProperty"), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, "/d/e"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.context, (ProgressMonitor)this.progressMonitor);
        Assert.assertThat((Object)this.session.getRootNode().hasNode("d/e"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToMultipleNonExistingNodes() throws Exception {
        this.startRepository();
        this.session = this.getRepository().login(this.getTestCredentials());
        Node nodeC = this.tools.findOrCreateNode(this.session, "/a/b/c");
        Assert.assertThat((Object)this.session.getRootNode().hasNode("d"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.session.getRootNode().hasNode("x"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        nodeC.setProperty("sequencedProperty", (InputStream)new ByteArrayInputStream(this.sampleData.getBytes()));
        NodeChange nodeChange = new NodeChange(this.repositoryWorkspaceName, nodeC.getPath(), 16, Collections.singleton("sequencedProperty"), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, "/d/e"));
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, "/x/y/z"));
        outputPaths.add(new RepositoryNodePath(this.repositoryWorkspaceName, "/x/z"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.context, (ProgressMonitor)this.progressMonitor);
        Assert.assertThat((Object)this.session.getRootNode().hasNode("d/e"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getRootNode().hasNode("x/y/z"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getRootNode().hasNode("x/z"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getRootNode().getNode("d/e/alpha/beta").getProperty("isSomething").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getRootNode().getNode("x/y/z/alpha/beta").getProperty("isSomething").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getRootNode().getNode("x/z/alpha/beta").getProperty("isSomething").getBoolean(), (Matcher)Is.is((Object)true));
    }
}

