/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import javax.jcr.Repository;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.common.SystemFailureException;
import org.jboss.dna.common.jcr.AbstractJcrRepositoryTest;
import org.jboss.dna.common.naming.MockInitialContext;
import org.jboss.dna.repository.util.JndiSessionFactory;
import org.jmock.Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JndiSessionFactoryTest
extends AbstractJcrRepositoryTest {
    public static final String MOCK_REPOSITORY_NAME = "java:jcr/unit/test/repository/1";
    public static final String MOCK_REPOSITORY_NAME_ALT = "java:jcr/unit/test/repository/2";
    private JndiSessionFactory factory;
    private Mockery context;
    private Repository mockRepository;
    private Session session;

    @Before
    public void beforeEach() throws Exception {
        this.context = new Mockery();
        this.mockRepository = (Repository)this.context.mock(Repository.class);
        MockInitialContext.register((String)MOCK_REPOSITORY_NAME, (Object)this.mockRepository);
        this.factory = new JndiSessionFactory();
    }

    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            this.session.logout();
        }
        MockInitialContext.tearDown();
    }

    protected void assertNotRegistered(String name) {
        try {
            new InitialContext().lookup(name);
            Assert.fail((String)"Unexpectedly found registered object");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    protected void assertRegistered(String name, Object obj) {
        try {
            Assert.assertThat((Object)new InitialContext().lookup(name), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)obj)));
        }
        catch (NamingException e) {
            Assert.fail((String)("Failed to find registered object \"" + name + "\""));
        }
    }

    @Test
    public void shouldCreateSessionForRegisteredRepository() {
    }

    @Test(expected=SystemFailureException.class)
    public void shouldThrowSystemFailureWhenUnableToFindRegisteredRepository() throws Exception {
        this.factory.createSession("java:jcr/unit/test/repository/1something_extra_that_can't_be_found");
    }

    @Test
    public void shouldFindWorkspaceInRegisteredName() {
        Assert.assertThat((Object)this.factory.getWorkspaceName("java:jcr/path/to/repository/workspaceName"), (Matcher)Is.is((Object)"workspaceName"));
    }

    @Test
    public void shouldReturnNullWorkspaceIfRegisteredNameEndsInDelimiter() {
        Assert.assertThat((Object)this.factory.getWorkspaceName("java:jcr/path/to/repository/"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnNullWorkspaceIfRegisteredNameHasNoDelimiter() {
        Assert.assertThat((Object)this.factory.getWorkspaceName("java:jcr"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldFindRepositoryInRegisteredName() {
        Assert.assertThat((Object)this.factory.getRepositoryName("java:jcr/path/to/repository/workspaceName"), (Matcher)Is.is((Object)"java:jcr/path/to/repository"));
    }

    @Test
    public void shouldConsiderWholeRegisteredNameToBeRepositoryNameIfRegisteredNameEndsInDelimiter() {
        Assert.assertThat((Object)this.factory.getRepositoryName("java:jcr/path/to/repository/"), (Matcher)Is.is((Object)"java:jcr/path/to/repository"));
    }

    @Test
    public void shouldConsiderWholeRegisteredNameToBeRepositoryNameIfRegisteredNameHasNoDelimiter() {
        Assert.assertThat((Object)this.factory.getRepositoryName("java:jcr"), (Matcher)Is.is((Object)"java:jcr"));
    }

    @Test
    public void shouldRegisterSuppliedRepositoryInJndi() throws Exception {
        this.assertNotRegistered(MOCK_REPOSITORY_NAME_ALT);
        this.factory.registerRepository(MOCK_REPOSITORY_NAME_ALT, this.mockRepository);
        this.assertRegistered(MOCK_REPOSITORY_NAME_ALT, this.mockRepository);
    }

    @Test
    public void shouldUnregisterRepositoryInJndiIfNullRepositoryReference() throws Exception {
        this.assertRegistered(MOCK_REPOSITORY_NAME, this.mockRepository);
        this.factory.registerRepository(MOCK_REPOSITORY_NAME, null);
        this.assertNotRegistered(MOCK_REPOSITORY_NAME);
    }

    @Test
    public void shouldRemoveAllTrailingDelimitersWhenRegisteringRepository() throws Exception {
        this.assertNotRegistered("java:jcr/unit/test/repository");
        this.factory.registerRepository("java:jcr/unit/test/repository///", this.mockRepository);
        this.assertRegistered("java:jcr/unit/test/repository", this.mockRepository);
    }

    @Test
    public void shouldCreateAnonymousSessionInRepositoryIfNoCredentialsAreRegisterd() throws Exception {
        Repository repository = this.getRepository();
        this.factory.registerRepository("java:jcr/unit/test/repository/", repository);
        this.session = this.factory.createSession("java:jcr/unit/test/repository/default");
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.session.getUserID(), (Matcher)Is.is((Object)"anonymous"));
    }

    @Test
    public void shouldCreateNonAnonymousSessionInRepositoryIfCredentialsAreRegistered() throws Exception {
        Repository repository = this.getRepository();
        this.factory.registerRepository("java:jcr/unit/test/repository/", repository);
        this.factory.registerCredentials("java:jcr/unit/test/repository/default", "jsmith", "secret".toCharArray());
        this.session = this.factory.createSession("java:jcr/unit/test/repository/default");
        Assert.assertThat((Object)this.session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.session.getUserID(), (Matcher)Is.is((Object)"jsmith"));
    }
}

