/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.common.SystemFailureException;
import org.jboss.dna.common.jcr.AbstractJcrRepositoryTest;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.repository.util.JcrTools;
import org.jboss.dna.repository.util.SessionFactory;
import org.junit.Assert;

public class MockExecutionContext
implements ExecutionContext {
    private JcrTools tools = new JcrTools();
    private SessionFactory sessionFactory;

    public MockExecutionContext(final AbstractJcrRepositoryTest test, final String repositoryName) {
        this.sessionFactory = new SessionFactory(){

            public Session createSession(String name) throws RepositoryException {
                Assert.assertThat((Object)name, (Matcher)Is.is((Object)repositoryName));
                try {
                    return test.getRepository().login(test.getTestCredentials());
                }
                catch (IOException e) {
                    throw new SystemFailureException((Throwable)e);
                }
            }
        };
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public JcrTools getTools() {
        return this.tools;
    }
}

